/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gamedata;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.npc.faction.PlayerFactionEntry;
import net.shadowmage.ancientwarfare.npc.network.PacketFactionUpdate;

public class FactionData
extends WorldSavedData {
    private static final String FACTION_INIT_TAG = "factionInit";
    private static final String FACTION_UPDATE_TAG = "factionUpdate";
    private HashMap<String, PlayerFactionEntry> playerFactionEntries = new HashMap();

    public FactionData(String par1Str) {
        super(par1Str);
    }

    public void onPlayerLogin(EntityPlayer player) {
        String name = player.func_70005_c_();
        if (!this.playerFactionEntries.containsKey(name)) {
            this.playerFactionEntries.put(name, new PlayerFactionEntry(name));
            this.func_76185_a();
        }
        this.sendFactionEntry(player);
    }

    public PlayerFactionEntry getEntryFor(String playerName) {
        return this.playerFactionEntries.get(playerName);
    }

    public int getStandingFor(String playerName, String faction) {
        if (this.playerFactionEntries.containsKey(playerName)) {
            return this.playerFactionEntries.get(playerName).getStandingFor(faction);
        }
        return 0;
    }

    public void adjustStandingFor(World world, String playerName, String faction, int adjustment) {
        if (this.playerFactionEntries.containsKey(playerName)) {
            this.playerFactionEntries.get(playerName).adjustStandingFor(faction, adjustment);
            this.func_76185_a();
        }
        this.sendFactionUpdate(world, playerName, faction);
    }

    public void setStandingFor(String playerName, String faction, int setting) {
        if (this.playerFactionEntries.containsKey(playerName)) {
            this.playerFactionEntries.get(playerName).setStandingFor(faction, setting);
            this.func_76185_a();
        }
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = entryList.func_150305_b(i);
            this.readEntryFromNBT(entryTag);
        }
    }

    private void readEntryFromNBT(NBTTagCompound entryTag) {
        PlayerFactionEntry entry = new PlayerFactionEntry(entryTag);
        this.playerFactionEntries.put(entry.playerName, entry);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTTagList entryList = new NBTTagList();
        for (PlayerFactionEntry entry : this.playerFactionEntries.values()) {
            entryList.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        return tag;
    }

    public void handlePacketData(EntityPlayer player, NBTTagCompound tag) {
        if (tag.func_74764_b(FACTION_UPDATE_TAG)) {
            this.handleClientFactionUpdate(player, tag.func_74775_l(FACTION_UPDATE_TAG));
        }
        if (tag.func_74764_b(FACTION_INIT_TAG)) {
            this.handleClientFactionInit(tag.func_74775_l(FACTION_INIT_TAG));
        }
    }

    private void handleClientFactionUpdate(EntityPlayer player, NBTTagCompound tag) {
        String faction = tag.func_74779_i("faction");
        int standing = tag.func_74762_e("standing");
        this.setStandingFor(player.func_70005_c_(), faction, standing);
    }

    private void handleClientFactionInit(NBTTagCompound tag) {
        this.readEntryFromNBT(tag);
    }

    private void sendFactionEntry(EntityPlayer player) {
        PlayerFactionEntry entry = this.getEntryFor(player.func_70005_c_());
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound initTag = entry.writeToNBT(new NBTTagCompound());
        tag.func_74782_a(FACTION_INIT_TAG, (NBTBase)initTag);
        PacketFactionUpdate pkt = new PacketFactionUpdate(tag);
        NetworkHandler.sendToPlayer((EntityPlayerMP)player, pkt);
    }

    private void sendFactionUpdate(World world, String playerName, String factionName) {
        EntityPlayer player = world.func_72924_a(playerName);
        if (player instanceof EntityPlayerMP) {
            int standing = this.getStandingFor(playerName, factionName);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound updateTag = new NBTTagCompound();
            updateTag.func_74778_a("faction", factionName);
            updateTag.func_74768_a("standing", standing);
            tag.func_74782_a(FACTION_UPDATE_TAG, (NBTBase)updateTag);
            PacketFactionUpdate pkt = new PacketFactionUpdate(tag);
            NetworkHandler.sendToPlayer((EntityPlayerMP)player, pkt);
        }
    }
}

