/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gamedata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.owner.TeamViewerRegistry;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.faction.FactionEntry;
import net.shadowmage.ancientwarfare.npc.gamedata.FactionData;
import net.shadowmage.ancientwarfare.npc.gamedata.Team;
import net.shadowmage.ancientwarfare.npc.network.PacketTeamMembershipUpdate;
import net.shadowmage.ancientwarfare.npc.network.PacketTeamStandingUpdate;
import net.shadowmage.ancientwarfare.npc.network.PacketTeamStandingsUpdate;

public class TeamData
extends WorldSavedData {
    private HashMap<String, Set<Team>> playerTeamsLookup = new HashMap();
    private HashMap<ResourceLocation, Team> teams = new HashMap();
    private Map<String, Set<LeavingTeam>> playerLeavingTeams = new HashMap<String, Set<LeavingTeam>>();
    private static final int LEAVING_EXPIRATION_TIME = 120000;
    private static final int LEAVING_CHECK_INTERVAL = 1200;
    private long nextLeavingCheck = Long.MIN_VALUE;
    private static final int MEMBERSHIP_CHECK_INTERVAL = 100;
    private long nextMembershipCheck = Long.MIN_VALUE;

    private void addTeamMemberUpdateStanding(ResourceLocation teamName, String playerName, FactionData factionData) {
        Team team = this.addTeamMember(teamName, playerName);
        NetworkHandler.sendToAllPlayers(new PacketTeamMembershipUpdate(teamName, playerName, PacketTeamMembershipUpdate.Action.ADD));
        team.updateFactionStandings(factionData, playerName);
        NetworkHandler.sendToAllPlayers(new PacketTeamStandingsUpdate(teamName, team.getFactionStandings()));
        this.func_76185_a();
    }

    public Team addTeamMember(ResourceLocation teamName, String playerName) {
        if (!this.teams.containsKey(teamName)) {
            this.teams.put(teamName, new Team(teamName));
        }
        Team team = this.teams.get(teamName);
        team.addMember(playerName);
        if (!this.playerTeamsLookup.containsKey(playerName)) {
            this.playerTeamsLookup.put(playerName, new HashSet());
        }
        this.playerTeamsLookup.get(playerName).add(team);
        if (this.playerLeavingTeams.containsKey(playerName)) {
            this.playerLeavingTeams.get(playerName).removeIf(leavingTeam -> ((LeavingTeam)leavingTeam).getTeamName().equals((Object)teamName));
        }
        this.func_76185_a();
        return team;
    }

    private void removeTeamMember(ResourceLocation teamName, String player, long totalWorldTime) {
        this.removeTeamMember(teamName, player, totalWorldTime, true);
    }

    public void removeTeamMember(ResourceLocation teamName, String player, long totalWorldTime, boolean isServer) {
        if (!this.teams.containsKey(teamName)) {
            AncientWarfareNPC.LOG.error("Non existent team can't have members removed");
            return;
        }
        Team team = this.teams.get(teamName);
        team.removeMember(player);
        if (this.playerTeamsLookup.containsKey(player)) {
            this.playerTeamsLookup.get(player).remove(team);
        }
        this.addToPlayerLeavingTeams(teamName, player, totalWorldTime);
        if (isServer) {
            NetworkHandler.sendToAllPlayers(new PacketTeamMembershipUpdate(teamName, player, PacketTeamMembershipUpdate.Action.REMOVE));
        }
        this.func_76185_a();
    }

    private void addToPlayerLeavingTeams(ResourceLocation teamName, String player, long totalWorldTime) {
        if (!this.playerLeavingTeams.containsKey(player)) {
            this.playerLeavingTeams.put(player, new HashSet());
        }
        this.playerLeavingTeams.get(player).add(new LeavingTeam(totalWorldTime, teamName));
    }

    public TeamData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList teamsNBT = nbt.func_150295_c("teams", 10);
        for (int i = 0; i < teamsNBT.func_74745_c(); ++i) {
            NBTTagCompound teamNBT = teamsNBT.func_150305_b(i);
            Team team = Team.deserializeNBT(teamNBT);
            this.teams.put(team.getName(), team);
            for (String member : team.getMembers()) {
                if (!this.playerTeamsLookup.containsKey(member)) {
                    this.playerTeamsLookup.put(member, new HashSet());
                }
                this.playerTeamsLookup.get(member).add(team);
            }
        }
        this.playerLeavingTeams = NBTHelper.getMap(nbt.func_150295_c("playerLeavingTeams", 10), t -> t.func_74779_i("playerName"), t -> NBTHelper.getSet(t.func_150295_c("leavingTeams", 10), leavingTeamNBT -> LeavingTeam.deserializeNBT((NBTTagCompound)leavingTeamNBT)));
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList teamsNBT = new NBTTagList();
        for (Team team : this.teams.values()) {
            teamsNBT.func_74742_a((NBTBase)team.serializeNBT());
        }
        if (teamsNBT.func_74745_c() > 0) {
            compound.func_74782_a("teams", (NBTBase)teamsNBT);
        }
        NBTHelper.mapToCompoundList(this.playerLeavingTeams, (tag, key) -> tag.func_74778_a("playerName", key), (tag, leavingTeams) -> tag.func_74782_a("leavingTeams", (NBTBase)NBTHelper.getTagList(leavingTeams, LeavingTeam::serializeNBT)));
        return compound;
    }

    public void checkAndUpdatePlayerTeamMemberships(EntityPlayer player) {
        String playerName = player.func_70005_c_();
        Set<ResourceLocation> teamNames = TeamViewerRegistry.getPlayerTeamNames(player.field_70170_p, player.func_110124_au(), playerName);
        FactionData factionData = AWGameData.INSTANCE.getData(player.field_70170_p, FactionData.class);
        for (ResourceLocation teamName : teamNames) {
            this.addTeamMemberUpdateStanding(teamName, playerName, factionData);
        }
        if (this.playerTeamsLookup.containsKey(playerName)) {
            for (Team team : this.playerTeamsLookup.get(playerName)) {
                if (teamNames.contains(team.getName())) continue;
                this.removeTeamMember(team.getName(), playerName, player.field_70170_p.func_82737_E());
            }
        }
    }

    public int getWorstStandingFor(World world, UUID playerUUID, String playerName, String factionName, long totalWorldTime) {
        if (!world.field_72995_K) {
            this.checkTeamMembershipChanges(world, playerUUID, playerName);
        }
        return this.getWorstStandingFor(playerName, factionName, totalWorldTime);
    }

    public int getWorstStandingFor(String playerName, String factionName, long totalWorldTime) {
        int leavingStanding;
        int currentStanding = this.getWorstCurrentTeamsStanding(playerName, factionName);
        return currentStanding < (leavingStanding = this.getWorstLeavingTeamStanding(playerName, factionName, totalWorldTime)) ? currentStanding : leavingStanding;
    }

    private void checkTeamMembershipChanges(World world, UUID playerUUID, String playerName) {
        if (this.nextMembershipCheck > world.func_82737_E()) {
            return;
        }
        this.nextMembershipCheck = world.func_82737_E() + 100L;
        Set<String> domainsToRefresh = TeamViewerRegistry.getRegularlyCheckedViewerNames();
        Set<ResourceLocation> currentPlayerTeamNames = TeamViewerRegistry.getRegularlyCheckedPlayerTeamNames(world, playerUUID, playerName);
        HashSet<ResourceLocation> teamsToRemoveFrom = new HashSet<ResourceLocation>();
        Set playerTeams = this.playerTeamsLookup.getOrDefault(playerName, new HashSet());
        for (Team team : playerTeams) {
            ResourceLocation teamName2 = team.getName();
            if (!domainsToRefresh.contains(teamName2.func_110624_b()) || currentPlayerTeamNames.contains(teamName2)) continue;
            teamsToRemoveFrom.add(teamName2);
        }
        teamsToRemoveFrom.forEach(teamName -> this.removeTeamMember((ResourceLocation)teamName, playerName, world.func_82737_E()));
        for (ResourceLocation teamName3 : currentPlayerTeamNames) {
            if (this.teams.containsKey(teamName3) && this.teams.get(teamName3).isMember(playerName)) continue;
            this.addTeamMemberUpdateStanding(teamName3, playerName, AWGameData.INSTANCE.getData(world, FactionData.class));
        }
    }

    private int getWorstCurrentTeamsStanding(String playerName, String factionName) {
        int worstStanding = Integer.MAX_VALUE;
        if (!this.playerTeamsLookup.containsKey(playerName)) {
            return worstStanding;
        }
        Set<Team> playersTeams = this.playerTeamsLookup.get(playerName);
        for (Team team : playersTeams) {
            int teamStanding = team.getFactionStanding(factionName);
            if (teamStanding >= worstStanding) continue;
            worstStanding = teamStanding;
        }
        return worstStanding;
    }

    private int getWorstLeavingTeamStanding(String playerName, String factionName, long totalWorldTime) {
        this.checkLeavingExpiration(totalWorldTime);
        int worstStanding = Integer.MAX_VALUE;
        if (this.playerLeavingTeams.containsKey(playerName)) {
            for (LeavingTeam team : this.playerLeavingTeams.get(playerName)) {
                int teamStanding;
                ResourceLocation teamName = team.getTeamName();
                if (!this.teams.containsKey(teamName) || (teamStanding = this.teams.get(teamName).getFactionStanding(factionName)) >= worstStanding) continue;
                worstStanding = teamStanding;
            }
        }
        return worstStanding;
    }

    private void checkLeavingExpiration(long totalWorldTime) {
        if (this.nextLeavingCheck > totalWorldTime) {
            return;
        }
        this.nextLeavingCheck = totalWorldTime + 1200L;
        for (Set<LeavingTeam> leavingTeams : this.playerLeavingTeams.values()) {
            leavingTeams.removeIf(leavingTeam -> ((LeavingTeam)leavingTeam).getLeftWorldTime() + 120000L < totalWorldTime);
        }
    }

    public void adjustStanding(World world, FactionData factionData, String playerName, String factionName, int change) {
        EntityPlayer player = world.func_72924_a(playerName);
        if (player != null && !world.field_72995_K) {
            this.checkTeamMembershipChanges(world, player.func_110124_au(), playerName);
        }
        if (!this.playerTeamsLookup.containsKey(playerName)) {
            factionData.adjustStandingFor(world, playerName, factionName, change);
            return;
        }
        factionData.adjustStandingFor(world, playerName, factionName, change);
        Set<Team> playersTeams = this.playerTeamsLookup.get(playerName);
        for (Team team : playersTeams) {
            team.adjustStandingFor(world, factionData, factionName, change, playerName);
            NetworkHandler.sendToAllPlayers(new PacketTeamStandingUpdate(team.getName(), factionName, team.getFactionStanding(factionName)));
        }
        this.func_76185_a();
    }

    public void updateTeamStandings(ResourceLocation teamName, FactionEntry factionEntry) {
        if (this.teams.containsKey(teamName)) {
            this.teams.get(teamName).setFactionStandings(factionEntry);
        }
        this.func_76185_a();
    }

    public void updateTeamStanding(ResourceLocation teamName, String factionName, int standing) {
        if (this.teams.containsKey(teamName)) {
            this.teams.get(teamName).setFactionStanding(factionName, standing);
        }
        this.func_76185_a();
    }

    public Collection<Team> getTeams() {
        return this.teams.values();
    }

    public Optional<Team> getTeam(ResourceLocation teamName) {
        return Optional.ofNullable(this.teams.get(teamName));
    }

    public Set<Team> getPlayerTeams(String playerName) {
        return this.playerTeamsLookup.getOrDefault(playerName, new HashSet());
    }

    private static class LeavingTeam {
        private final long leftWorldTime;
        private final ResourceLocation teamName;

        private LeavingTeam(long leftWorldTime, ResourceLocation teamName) {
            this.leftWorldTime = leftWorldTime;
            this.teamName = teamName;
        }

        private long getLeftWorldTime() {
            return this.leftWorldTime;
        }

        private ResourceLocation getTeamName() {
            return this.teamName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeavingTeam that = (LeavingTeam)o;
            return this.teamName.equals((Object)that.teamName);
        }

        public int hashCode() {
            return this.teamName.hashCode();
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74772_a("leftWorldTime", this.leftWorldTime);
            ret.func_74778_a("teamName", this.teamName.toString());
            return ret;
        }

        public static LeavingTeam deserializeNBT(NBTTagCompound tag) {
            return new LeavingTeam(tag.func_74763_f("leftWorldTime"), new ResourceLocation(tag.func_74779_i("teamName")));
        }
    }
}

