/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcCreativeControls;
import net.shadowmage.ancientwarfare.npc.container.ISkinSettingsContainer;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.gui.GuiSkinSelection;

public class GuiNpcCreativeControls
extends GuiContainerBase<ContainerNpcCreativeControls> {
    private Text ownerNameInput;
    private NumberInput attackDamageOverrideInput;
    private NumberInput armorValueOverrideInput;
    private NumberInput maxHealthOverrideInput;
    private Checkbox wanderCheckbox;
    private Checkbox customEquipmentCheckbox;
    private boolean hasChanged = false;

    public GuiNpcCreativeControls(ContainerBase container) {
        super(container);
    }

    @Override
    public void initElements() {
        int totalHeight = 8;
        Label label = new Label(8, totalHeight + 1, "guistrings.npc.owner_name");
        this.addGuiElement(label);
        this.ownerNameInput = new Text(100, totalHeight, 140, "", this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                ((ContainerNpcCreativeControls)GuiNpcCreativeControls.this.getContainer()).ownerName = newText;
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.ownerNameInput);
        label = new Label(8, (totalHeight += 12) + 1, "guistrings.npc.custom_texture");
        this.addGuiElement(label);
        Button skinButton = new Button(100, totalHeight, 140, 12, ((ContainerNpcCreativeControls)this.getContainer()).skinSettings.getDescription()){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSkinSelection(GuiNpcCreativeControls.this, (ISkinSettingsContainer)GuiNpcCreativeControls.this.getContainer()));
            }
        };
        this.addGuiElement(skinButton);
        label = new Label(8, (totalHeight += 12) + 1, "guistrings.npc.health_override");
        this.addGuiElement(label);
        this.maxHealthOverrideInput = new NumberInput(120, totalHeight, 60, 0.0f, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerNpcCreativeControls)GuiNpcCreativeControls.this.getContainer()).maxHealth = (int)value;
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.maxHealthOverrideInput);
        this.maxHealthOverrideInput.setIntegerValue().setAllowNegative();
        label = new Label(8, (totalHeight += 12) + 1, "guistrings.npc.damage_override");
        this.addGuiElement(label);
        this.attackDamageOverrideInput = new NumberInput(120, totalHeight, 60, 0.0f, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerNpcCreativeControls)GuiNpcCreativeControls.this.getContainer()).attackDamage = (int)value;
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.attackDamageOverrideInput);
        this.attackDamageOverrideInput.setIntegerValue().setAllowNegative();
        label = new Label(8, (totalHeight += 12) + 1, "guistrings.npc.armor_override");
        this.addGuiElement(label);
        this.armorValueOverrideInput = new NumberInput(120, totalHeight, 60, 0.0f, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerNpcCreativeControls)GuiNpcCreativeControls.this.getContainer()).armorValue = (int)value;
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.armorValueOverrideInput);
        this.armorValueOverrideInput.setIntegerValue().setAllowNegative();
        this.wanderCheckbox = new Checkbox(8, totalHeight += 12, 16, 16, "guistrings.npc.allow_wander"){

            @Override
            public void onToggled() {
                ((ContainerNpcCreativeControls)GuiNpcCreativeControls.this.getContainer()).wander = this.checked();
                GuiNpcCreativeControls.this.hasChanged = true;
            }
        };
        this.addGuiElement(this.wanderCheckbox);
        if (((ContainerNpcCreativeControls)this.getContainer()).isFactionNpc()) {
            this.customEquipmentCheckbox = new Checkbox(100, totalHeight, 16, 16, "guistrings.npc.custom_equipment"){

                @Override
                public void onToggled() {
                    ((ContainerNpcCreativeControls)GuiNpcCreativeControls.this.getContainer()).hasCustomEquipment = this.checked();
                    GuiNpcCreativeControls.this.hasChanged = true;
                }
            };
            this.customEquipmentCheckbox.addTooltip(I18n.func_135052_a((String)"guistrings.npc.custom_equipment.tooltip", (Object[])new Object[0]));
            this.addGuiElement(this.customEquipmentCheckbox);
        }
        this.field_147000_g = (totalHeight += 16) + 8;
    }

    @Override
    public void setupElements() {
        this.ownerNameInput.setText(((ContainerNpcCreativeControls)this.getContainer()).ownerName);
        this.attackDamageOverrideInput.setValue(((ContainerNpcCreativeControls)this.getContainer()).attackDamage);
        this.armorValueOverrideInput.setValue(((ContainerNpcCreativeControls)this.getContainer()).armorValue);
        this.maxHealthOverrideInput.setValue(((ContainerNpcCreativeControls)this.getContainer()).maxHealth);
        this.wanderCheckbox.setChecked(((ContainerNpcCreativeControls)this.getContainer()).wander);
        if (((ContainerNpcCreativeControls)this.getContainer()).isFactionNpc()) {
            this.customEquipmentCheckbox.setChecked(((ContainerNpcCreativeControls)this.getContainer()).hasCustomEquipment);
        }
    }

    @Override
    protected boolean onGuiCloseRequested() {
        if (this.hasChanged) {
            ((ContainerNpcCreativeControls)this.getContainer()).sendChangesToServer();
        }
        ((NpcBase)((ContainerNpcCreativeControls)this.getContainer()).entity).openGUI(this.player);
        return false;
    }
}

