/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Line;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcPlayerOwnedTrade;
import net.shadowmage.ancientwarfare.npc.entity.NpcTrader;
import net.shadowmage.ancientwarfare.npc.trade.POTrade;
import net.shadowmage.ancientwarfare.npc.trade.Trade;

public class GuiNpcPlayerOwnedTrade
extends GuiContainerBase<ContainerNpcPlayerOwnedTrade> {
    private CompositeScrolled area;
    private boolean owner;

    public GuiNpcPlayerOwnedTrade(ContainerBase container) {
        super(container);
    }

    @Override
    public void initElements() {
        int areaSize = this.field_147000_g - 8 - 4 - 8 - 72;
        int areaY = 0;
        if (((NpcTrader)((ContainerNpcPlayerOwnedTrade)((Object)this.getContainer())).entity).isOwner(this.player)) {
            areaSize -= 24;
            areaY = 24;
            this.owner = true;
        }
        this.area = new CompositeScrolled(this, 0, areaY, this.field_146999_f, areaSize);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        this.clearElements();
        if (this.owner) {
            Button inventory = new Button(8, 8, 240, 12, "guistrings.inventory"){

                @Override
                protected void onPressed() {
                    NetworkHandler.INSTANCE.openGui(GuiNpcPlayerOwnedTrade.this.player, 4, ((NpcTrader)((ContainerNpcPlayerOwnedTrade)((Object)GuiNpcPlayerOwnedTrade.this.getContainer())).entity).func_145782_y(), 0, 0);
                }
            };
            this.addGuiElement(inventory);
        }
        this.addGuiElement(this.area);
        if (((ContainerNpcPlayerOwnedTrade)((Object)this.getContainer())).storage != null) {
            this.addTrades();
        } else {
            this.addSingleMessage("guistrings.trader.missing_backpack");
        }
    }

    private void addSingleMessage(String text) {
        this.area.addGuiElement(new Label(8, 8, text));
    }

    private void addTrades() {
        int totalHeight = 8;
        if (((ContainerNpcPlayerOwnedTrade)((Object)this.getContainer())).tradeList.isEmpty()) {
            this.addSingleMessage("guistrings.trader.no_trade");
        } else {
            for (int i = 0; i < ((ContainerNpcPlayerOwnedTrade)((Object)this.getContainer())).tradeList.size(); ++i) {
                POTrade trade = (POTrade)((ContainerNpcPlayerOwnedTrade)((Object)this.getContainer())).tradeList.get(i);
                if (!trade.isAvailable(((ContainerNpcPlayerOwnedTrade)((Object)this.getContainer())).storage)) continue;
                totalHeight = this.addTrade(trade, i, totalHeight);
            }
            if (totalHeight == 8) {
                this.addSingleMessage("guistrings.trader.cant_trade");
            }
        }
        this.area.setAreaSize(totalHeight);
    }

    private int addTrade(final Trade trade, final int tradeIndex, int startHeight) {
        int gridX = 0;
        int gridY = 0;
        for (int i = 0; i < trade.size(); ++i) {
            int slotX = gridX * 18 + 8;
            int slotY = gridY * 18 + startHeight;
            this.addTradeInputSlot(trade, slotX, slotY, i);
            this.addTradeOutputSlot(trade, slotX += 63, slotY, i);
            if (++gridX < 3) continue;
            gridX = 0;
            ++gridY;
        }
        int startWidth = 62;
        if (trade.size() < 3) {
            startWidth += (trade.size() - 3) * 18;
        }
        this.area.addGuiElement(new Label(startWidth + 1, startHeight + (gridY + 1) * 5, ">"));
        Button tradeButton = new Button(2 * startWidth + 9, startHeight + 17, 70, 20, "guistrings.trade"){

            @Override
            protected void onPressed() {
                trade.performTrade(GuiNpcPlayerOwnedTrade.this.player, ((ContainerNpcPlayerOwnedTrade)((Object)GuiNpcPlayerOwnedTrade.this.getContainer())).storage);
                ((ContainerNpcPlayerOwnedTrade)((Object)GuiNpcPlayerOwnedTrade.this.getContainer())).doTrade(tradeIndex);
                GuiNpcPlayerOwnedTrade.this.refreshGui();
            }
        };
        this.area.addGuiElement(tradeButton);
        this.area.addGuiElement(new Line(0, (startHeight += 18 * gridY) + 1, this.field_146999_f, startHeight + 1, 1, 255));
        return startHeight += 5;
    }

    private void addTradeInputSlot(Trade trade, int x, int y, int slotNum) {
        ItemStack stack = trade.getInputStack(slotNum);
        stack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
        ItemSlot slot = new ItemSlot(x, y, stack, this);
        if (stack.func_190926_b()) {
            slot.addTooltip("guistrings.npc.trade_input_slot");
        }
        this.area.addGuiElement(slot);
    }

    private void addTradeOutputSlot(Trade trade, int x, int y, int slotNum) {
        ItemStack stack = trade.getOutputStack(slotNum);
        stack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
        ItemSlot slot = new ItemSlot(x, y, stack, this);
        if (stack.func_190926_b()) {
            slot.addTooltip("guistrings.npc.trade_output_slot");
        }
        this.area.addGuiElement(slot);
    }
}

