/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiSelectFromList;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBase;
import net.shadowmage.ancientwarfare.npc.container.ISkinSettingsContainer;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinManager;
import net.shadowmage.ancientwarfare.npc.skin.NpcSkinSettings;

public class GuiSkinSelection
extends GuiContainerBase {
    private final GuiContainerBase<? extends ContainerNpcBase<NpcBase>> parent;
    private Checkbox defaultType;
    private Checkbox playerType;
    private Checkbox npcType;
    private NpcSkinSettings skinSettings;
    private ISkinSettingsContainer skinSettingsContainer;
    private int previewTop = 0;
    private static final int SUBCONTROLS_INDENT = 24;
    private int mouseX;
    private int mouseY;
    private int playerSkinUpdateCooldown = 0;
    private boolean updatePlayerSkin = false;

    public GuiSkinSelection(GuiContainerBase<? extends ContainerNpcBase<NpcBase>> parent, ISkinSettingsContainer skinSettingsContainer) {
        super(new ContainerBase(parent.getContainer().player), 200, 240);
        this.parent = parent;
        this.skinSettings = skinSettingsContainer.getSkinSettings();
        this.skinSettingsContainer = skinSettingsContainer;
    }

    @Override
    public void setupElements() {
        this.clearElements();
        this.field_147000_g = this.calculateYSize();
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        int startHeight = 8;
        this.defaultType = new Checkbox(8, startHeight, 12, 12, "gui.ancientwarfarenpc.skin_selection.default"){

            @Override
            public void onToggled() {
                super.onToggled();
                if (this.checked()) {
                    GuiSkinSelection.this.skinSettings.setSkinType(NpcSkinSettings.SkinType.DEFAULT);
                    GuiSkinSelection.this.playerType.setChecked(false);
                    GuiSkinSelection.this.npcType.setChecked(false);
                    GuiSkinSelection.this.refreshGui();
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.defaultType.setChecked(this.skinSettings.getSkinType() == NpcSkinSettings.SkinType.DEFAULT);
        this.addGuiElement(this.defaultType);
        this.playerType = new Checkbox(8, startHeight += 16, 12, 12, "gui.ancientwarfarenpc.skin_selection.player"){

            @Override
            public void onToggled() {
                super.onToggled();
                if (this.checked()) {
                    GuiSkinSelection.this.skinSettings.setSkinType(NpcSkinSettings.SkinType.PLAYER);
                    GuiSkinSelection.this.defaultType.setChecked(false);
                    GuiSkinSelection.this.npcType.setChecked(false);
                    GuiSkinSelection.this.refreshGui();
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.playerType.setChecked(this.skinSettings.getSkinType() == NpcSkinSettings.SkinType.PLAYER);
        this.addGuiElement(this.playerType);
        startHeight += 16;
        if (this.playerType.checked()) {
            startHeight = this.addPlayerElements(startHeight);
        }
        this.npcType = new Checkbox(8, startHeight, 12, 12, "gui.ancientwarfarenpc.skin_selection.npc_type"){

            @Override
            public void onToggled() {
                super.onToggled();
                if (this.checked()) {
                    GuiSkinSelection.this.skinSettings.setSkinType(NpcSkinSettings.SkinType.NPC_TYPE);
                    GuiSkinSelection.this.playerType.setChecked(false);
                    GuiSkinSelection.this.defaultType.setChecked(false);
                    GuiSkinSelection.this.refreshGui();
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.npcType.setChecked(this.skinSettings.getSkinType() == NpcSkinSettings.SkinType.NPC_TYPE);
        this.addGuiElement(this.npcType);
        startHeight += 16;
        if (this.npcType.checked()) {
            startHeight = this.addNpcTypeElements(startHeight);
        }
        if (!this.defaultType.checked()) {
            Checkbox alex = new Checkbox(8, startHeight, 16, 16, "gui.ancientwarfarenpc.skin_selection.alex_model"){

                @Override
                public void onToggled() {
                    super.onToggled();
                    GuiSkinSelection.this.skinSettings.setAlexModel(this.checked());
                    GuiSkinSelection.this.refreshGui();
                }
            };
            alex.setChecked(this.skinSettings.isAlexModel());
            this.addGuiElement(alex);
            startHeight += 20;
        }
        this.previewTop = startHeight;
    }

    private int calculateYSize() {
        switch (this.skinSettings.getSkinType()) {
            case NPC_TYPE: {
                return this.skinSettings.getNpcTypeName().isEmpty() || this.skinSettings.isRandom() ? 250 : 266;
            }
            case PLAYER: {
                return 230;
            }
        }
        return 194;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        int posX = this.field_147003_i + this.field_146999_f / 2;
        int posY = this.field_147009_r + this.previewTop + 8 + 100;
        int backgroundWidth = this.field_146999_f - 16;
        int backgroundHeigth = 130;
        this.processPlayerSkinUpdate();
        RenderTools.renderColoredQuad(posX - backgroundWidth / 2, this.field_147009_r + this.previewTop, backgroundWidth, backgroundHeigth, 0.0f, 0.0f, 0.0f);
        GuiSkinSelection.drawEntityOnScreen(posX, posY, 35, posX - this.mouseX, posY - 50 - this.mouseY, (EntityLivingBase)this.parent.getContainer().entity);
    }

    private void processPlayerSkinUpdate() {
        if (this.playerSkinUpdateCooldown > 0) {
            --this.playerSkinUpdateCooldown;
            return;
        }
        if (!this.updatePlayerSkin) {
            return;
        }
        this.updatePlayerSkin = false;
        this.skinSettingsContainer.handleNpcSkinUpdate();
        this.playerSkinUpdateCooldown = 40;
    }

    private int addNpcTypeElements(int startHeight) {
        this.addGuiElement(new Button(24, startHeight, 150, 12, this.skinSettings.getNpcTypeName().isEmpty() ? "gui.ancientwarfarenpc.skin_selection.select_npc_type" : this.skinSettings.getNpcTypeName()){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a(new GuiSelectFromList<String>(GuiSkinSelection.this, GuiSkinSelection.this.skinSettings.getNpcTypeName(), s -> s, this::getNpcTypes, s -> {
                    this.setText((String)s);
                    GuiSkinSelection.this.skinSettings.setNpcTypeName((String)s);
                    GuiSkinSelection.this.skinSettings.resetNpcTypeSkin();
                    GuiSkinSelection.this.refreshGui();
                }));
            }

            private List<String> getNpcTypes() {
                return NpcSkinManager.getSkinTypes().stream().sorted().collect(Collectors.toList());
            }
        });
        Checkbox random = new Checkbox(24, startHeight += 16, 16, 16, "gui.ancientwarfarenpc.skin_selection.random"){

            @Override
            public void onToggled() {
                super.onToggled();
                GuiSkinSelection.this.skinSettings.setRandom(this.checked());
                GuiSkinSelection.this.refreshGui();
            }
        };
        random.setChecked(this.skinSettings.isRandom());
        this.addGuiElement(random);
        startHeight += 20;
        if (!this.skinSettings.getNpcTypeName().isEmpty() && !this.skinSettings.isRandom()) {
            this.addGuiElement(new Button(24, startHeight, 150, 12, this.skinSettings.getNpcTypeSkin().map(rl -> rl.toString().replace("ancientwarfare:skinpack/", "").replace(".png", "")).orElse("gui.ancientwarfarenpc.skin_selection.select_npc_skin")){

                @Override
                protected void onPressed() {
                    Minecraft.func_71410_x().func_147108_a(new GuiSelectFromList<ResourceLocation>(GuiSkinSelection.this, GuiSkinSelection.this.skinSettings.getNpcTypeSkin().orElse(null), rl -> rl == null ? "" : rl.toString().replace("ancientwarfare:skinpack/", "").replace(".png", ""), this::getNpcTypes, rl -> {
                        this.setText(rl.toString());
                        GuiSkinSelection.this.skinSettings.setNpcTypeSkin((ResourceLocation)rl);
                    }));
                }

                private List<ResourceLocation> getNpcTypes() {
                    return NpcSkinManager.getTypeSkins(GuiSkinSelection.this.skinSettings.getNpcTypeName()).stream().sorted().collect(Collectors.toList());
                }
            });
            startHeight += 16;
        }
        return startHeight;
    }

    private int addPlayerElements(int startHeight) {
        this.addGuiElement(new Text(24, startHeight, 100, this.skinSettings.getPlayerName(), this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                GuiSkinSelection.this.skinSettings.setPlayerName(newText);
                GuiSkinSelection.this.updatePlayerSkin = true;
            }
        });
        return startHeight + 16;
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        this.skinSettingsContainer.setSkinSettings(this.skinSettings);
        this.skinSettingsContainer.handleNpcSkinUpdate();
        this.parent.refreshGui();
        Minecraft.func_71410_x().func_147108_a(this.parent);
        return false;
    }

    @Override
    public void initElements() {
    }
}

