/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import java.util.Optional;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.npc.container.ContainerUpkeepOrder;

public class GuiUpkeepOrder
extends GuiContainerBase<ContainerUpkeepOrder> {
    private boolean hasChanged = false;

    public GuiUpkeepOrder(ContainerBase container) {
        super(container, 246, 38);
    }

    @Override
    public void initElements() {
    }

    @Override
    public void setupElements() {
        this.clearElements();
        Optional<BlockPos> pos = ((ContainerUpkeepOrder)((Object)this.getContainer())).upkeepOrder.getUpkeepPosition();
        if (pos.isPresent()) {
            ItemSlot slot = new ItemSlot(8, 10, ((ContainerUpkeepOrder)((Object)this.getContainer())).upkeepBlock, this);
            this.addGuiElement(slot);
            Label label = new Label(30, 8, StringTools.formatPos(pos.get()));
            this.addGuiElement(label);
            Button button = new Button(101, 18, 55, 12, this.getSideName(((ContainerUpkeepOrder)((Object)this.getContainer())).upkeepOrder.getUpkeepBlockSide())){

                @Override
                protected void onPressed() {
                    ((ContainerUpkeepOrder)((Object)GuiUpkeepOrder.this.getContainer())).upkeepOrder.changeBlockSide();
                    this.setText(GuiUpkeepOrder.this.getSideName(((ContainerUpkeepOrder)((Object)GuiUpkeepOrder.this.getContainer())).upkeepOrder.getUpkeepBlockSide()));
                    GuiUpkeepOrder.this.hasChanged = true;
                    GuiUpkeepOrder.this.refreshGui();
                }
            };
            this.addGuiElement(button);
            label = new Label(166, 8, "guistrings.npc.upkeep_time");
            this.addGuiElement(label);
            NumberInput input = new NumberInput(166, 18, 60, (float)((ContainerUpkeepOrder)((Object)this.getContainer())).upkeepOrder.getUpkeepAmount() / 1200.0f, this){

                @Override
                public void onValueUpdated(float value) {
                    float val = value * 1200.0f;
                    ((ContainerUpkeepOrder)((Object)GuiUpkeepOrder.this.getContainer())).upkeepOrder.setUpkeepAmount((int)val);
                    GuiUpkeepOrder.this.hasChanged = true;
                }
            };
            this.addGuiElement(input);
        } else {
            Label label = new Label(8, 8, "guistrings.npc.assign_upkeep_point");
            this.addGuiElement(label);
        }
    }

    private String getSideName(EnumFacing side) {
        return side == null ? "" : "guistrings.inventory.direction." + side.func_176610_l();
    }

    @Override
    protected boolean onGuiCloseRequested() {
        if (this.hasChanged) {
            ((ContainerUpkeepOrder)((Object)this.getContainer())).onClose();
        }
        return super.onGuiCloseRequested();
    }
}

