/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.init;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowmage.ancientwarfare.core.util.InjectionTools;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.item.ItemBardInstrument;
import net.shadowmage.ancientwarfare.npc.item.ItemClub;
import net.shadowmage.ancientwarfare.npc.item.ItemCoin;
import net.shadowmage.ancientwarfare.npc.item.ItemCombatOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;
import net.shadowmage.ancientwarfare.npc.item.ItemExtendedReachWeapon;
import net.shadowmage.ancientwarfare.npc.item.ItemFoodBundle;
import net.shadowmage.ancientwarfare.npc.item.ItemIceSpear;
import net.shadowmage.ancientwarfare.npc.item.ItemMacuahuitl;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;
import net.shadowmage.ancientwarfare.npc.item.ItemPitchfork;
import net.shadowmage.ancientwarfare.npc.item.ItemRoutingOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemScythe;
import net.shadowmage.ancientwarfare.npc.item.ItemShield;
import net.shadowmage.ancientwarfare.npc.item.ItemSickle;
import net.shadowmage.ancientwarfare.npc.item.ItemTradeOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemUpkeepOrder;
import net.shadowmage.ancientwarfare.npc.item.ItemWorkOrder;
import net.shadowmage.ancientwarfare.npc.registry.FactionDefinition;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;
import net.shadowmage.ancientwarfare.structure.block.BlockFlag;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockColored;

@GameRegistry.ObjectHolder(value="ancientwarfarenpc")
@Mod.EventBusSubscriber(modid="ancientwarfarenpc")
public class AWNPCItems {
    public static final ItemCommandBaton IRON_COMMAND_BATON = (ItemCommandBaton)InjectionTools.nullValue();
    public static final ItemShield WOODEN_SHIELD = (ItemShield)InjectionTools.nullValue();
    public static final Item NPC_SPAWNER = (Item)InjectionTools.nullValue();
    public static final Item WORK_ORDER = (Item)InjectionTools.nullValue();
    public static final Item UPKEEP_ORDER = (Item)InjectionTools.nullValue();
    public static final Item COMBAT_ORDER = (Item)InjectionTools.nullValue();
    public static final Item ROUTING_ORDER = (Item)InjectionTools.nullValue();
    public static final Item TRADE_ORDER = (Item)InjectionTools.nullValue();
    public static final Item BARD_INSTRUMENT = (Item)InjectionTools.nullValue();
    public static final Item COIN = (Item)InjectionTools.nullValue();

    private AWNPCItems() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("wooden_command_baton", Item.ToolMaterial.WOOD));
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("stone_command_baton", Item.ToolMaterial.STONE));
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("iron_command_baton", Item.ToolMaterial.IRON));
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("gold_command_baton", Item.ToolMaterial.GOLD));
        registry.register((IForgeRegistryEntry)new ItemCommandBaton("diamond_command_baton", Item.ToolMaterial.DIAMOND));
        registry.register((IForgeRegistryEntry)new ItemBardInstrument("bard_instrument"));
        registry.register((IForgeRegistryEntry)new ItemShield("wooden_shield", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemShield("stone_shield", Item.ToolMaterial.STONE, 506));
        registry.register((IForgeRegistryEntry)new ItemShield("iron_shield", Item.ToolMaterial.IRON, 759));
        registry.register((IForgeRegistryEntry)new ItemShield("gold_shield", Item.ToolMaterial.GOLD, 64));
        registry.register((IForgeRegistryEntry)new ItemShield("diamond_shield", Item.ToolMaterial.DIAMOND, 1138));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_tribal_1", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_tribal_2", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_round_1", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_round_2", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_round_3", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_round_4", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_round_5", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_round_6", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_witchbane_1", Item.ToolMaterial.IRON, 759));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_witchbane_2", Item.ToolMaterial.IRON, 759));
        registry.register((IForgeRegistryEntry)new ItemShield("shield_buffloka", Item.ToolMaterial.WOOD, 336));
        registry.register((IForgeRegistryEntry)new ItemWorkOrder());
        registry.register((IForgeRegistryEntry)new ItemUpkeepOrder());
        registry.register((IForgeRegistryEntry)new ItemCombatOrder());
        registry.register((IForgeRegistryEntry)new ItemRoutingOrder());
        registry.register((IForgeRegistryEntry)new ItemTradeOrder());
        registry.register((IForgeRegistryEntry)new ItemNpcSpawner());
        registry.register((IForgeRegistryEntry)new ItemCoin());
        registry.register((IForgeRegistryEntry)new ItemMacuahuitl(Item.ToolMaterial.IRON, "macuahuitl"));
        registry.register((IForgeRegistryEntry)new ItemSickle(Item.ToolMaterial.IRON, -2.3f));
        registry.register((IForgeRegistryEntry)new ItemPitchfork(Item.ToolMaterial.IRON, -2.3f));
        registry.register((IForgeRegistryEntry)new ItemScythe(Item.ToolMaterial.IRON, "scythe", 0.0f, -2.3f));
        registry.register((IForgeRegistryEntry)new ItemScythe(Item.ToolMaterial.DIAMOND, "death_scythe", 0.0f, -2.3f){

            @Override
            protected void applyPotionEffect(EntityLivingBase target) {
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100));
            }
        });
        registry.register((IForgeRegistryEntry)new ItemClub(Item.ToolMaterial.DIAMOND, "giant_club", 3.5, -3.6, 4.2f));
        registry.register((IForgeRegistryEntry)new ItemIceSpear(Item.ToolMaterial.DIAMOND, "ice_spear", 2.0, -3.0, 4.2f));
        ItemFoodBundle bundle = new ItemFoodBundle();
        registry.register((IForgeRegistryEntry)bundle);
        OreDictionary.registerOre((String)"foodBundle", (Item)bundle);
        AWNPCItems.registerExtendedReachWeapons((IForgeRegistry<Item>)registry, "spear", 2.0, -3.0, 4.2f);
        AWNPCItems.registerExtendedReachWeapons((IForgeRegistry<Item>)registry, "halberd", 3.0, -3.2, 4.5f);
        AWNPCItems.registerExtendedReachWeapons((IForgeRegistry<Item>)registry, "lance", 2.5, -3.2, 5.5f);
        AWNPCItems.registerExtendedReachWeapons((IForgeRegistry<Item>)registry, "cleaver", 3.5, -2.8, 3.0f);
        AWNPCItems.registerUniqueExtendedReachWeapon((IForgeRegistry<Item>)registry, "obsidian_spear", 2.0, -3.0, 4.2f);
    }

    private static void registerExtendedReachWeapons(IForgeRegistry<Item> registry, String name, double attackOffset, double attackSpeed, float reach) {
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.WOOD, "wooden_" + name, attackOffset, attackSpeed, reach));
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.STONE, "stone_" + name, attackOffset, attackSpeed, reach));
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.IRON, "iron_" + name, attackOffset, attackSpeed, reach));
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.GOLD, "golden_" + name, attackOffset, attackSpeed, reach));
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.DIAMOND, "diamond_" + name, attackOffset, attackSpeed, reach));
    }

    private static void registerUniqueExtendedReachWeapon(IForgeRegistry<Item> registry, String name, double attackOffset, double attackSpeed, float reach) {
        registry.register((IForgeRegistryEntry)new ItemExtendedReachWeapon(Item.ToolMaterial.DIAMOND, name, attackOffset, attackSpeed, reach));
    }

    public static void addFactionBlocks() {
        for (FactionDefinition definition : FactionRegistry.getFactionDefinitions()) {
            AWStructureBlocks.PROTECTION_FLAG.addFlagDefinition(new BlockFlag.FlagDefinition(definition.getName()));
            AWStructureBlocks.DECORATIVE_FLAG.addFlagDefinition(new BlockFlag.FlagDefinition(definition.getName()));
            for (Map.Entry<String, NBTTagCompound> blockData : definition.getThemedBlocksTags().entrySet()) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockData.getKey()));
                if (block == null) {
                    AncientWarfareNPC.LOG.warn("Can't find block with registry name {} in block registry, skipping...", (Object)blockData.getKey());
                    continue;
                }
                Item itemBlock = Item.func_150898_a((Block)block);
                if (!(itemBlock instanceof ItemBlockColored)) continue;
                blockData.getValue().func_74778_a("unlocalizedNamePart", "faction");
                ((ItemBlockColored)itemBlock).addCustomItemTag(blockData.getValue());
            }
        }
    }
}

