/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.npc.init.AWNPCItems;
import net.shadowmage.ancientwarfare.npc.item.ItemBaseNPC;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.init.AWStructureSounds;

public class ItemCoin
extends ItemBaseNPC {
    private static final Map<CoinMetal, Block> METALS_TO_BLOCKS = ImmutableMap.of((Object)((Object)CoinMetal.ANCIENT), (Object)AWStructureBlocks.COIN_STACK_ANCIENT, (Object)((Object)CoinMetal.GOLD), (Object)AWStructureBlocks.COIN_STACK_GOLD, (Object)((Object)CoinMetal.SILVER), (Object)AWStructureBlocks.COIN_STACK_SILVER, (Object)((Object)CoinMetal.COPPER), (Object)AWStructureBlocks.COIN_STACK_COPPER);

    public ItemCoin() {
        super("coin");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        Arrays.stream(CoinMetal.values()).forEach(metal -> {
            ItemStack subItem = ItemCoin.getCoinStack(metal);
            items.add((Object)subItem);
        });
    }

    private static ItemStack getCoinStack(CoinMetal metal) {
        return ItemCoin.getCoinStack(metal, 1);
    }

    public static ItemStack getCoinStack(CoinMetal metal, int stackSize) {
        ItemStack coinStack = new ItemStack(AWNPCItems.COIN);
        coinStack.func_77983_a("metal", (NBTBase)new NBTTagString(metal.getName()));
        coinStack.func_190920_e(stackSize);
        return coinStack;
    }

    public static boolean isSpecificCoin(ItemStack stack, CoinMetal coinMetal) {
        return stack.func_77973_b() == AWNPCItems.COIN && ItemCoin.getMetal(stack) == coinMetal;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ItemCoin.getMetalName(stack);
    }

    public static CoinMetal getMetal(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return CoinMetal.COPPER;
        }
        return CoinMetal.byName(ItemCoin.getMetalName(stack));
    }

    private static String getMetalName(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74779_i("metal") : "";
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block coinBlock;
        ItemStack stack = player.func_184586_b(hand);
        CoinMetal metal = ItemCoin.getMetal(stack);
        if (stack.func_190916_E() < 8) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!world.func_190527_a(coinBlock = METALS_TO_BLOCKS.get((Object)metal), pos, false, facing, (Entity)player)) {
            return EnumActionResult.FAIL;
        }
        world.func_175656_a(pos, coinBlock.func_176223_P());
        stack.func_190918_g(8);
        world.func_184133_a(null, pos, AWStructureSounds.COIN_STACK_INTERACT, SoundCategory.PLAYERS, 0.5f, 1.0f);
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ItemCoin.getMetal(stack).equals((Object)CoinMetal.ANCIENT)) {
            tooltip.add(I18n.func_135052_a((String)"item.coin.ancient.tooltip", (Object[])new Object[]{TextFormatting.DARK_AQUA.toString() + TextFormatting.ITALIC.toString()}));
        }
    }

    public static enum CoinMetal {
        ANCIENT("ancient", 4479304),
        GOLD("gold", 16766720),
        SILVER("silver", 0xC0C0C0),
        COPPER("copper", 12088115);

        private String name;
        private int color;
        private static Map<String, CoinMetal> values;

        private CoinMetal(String name, int color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public static CoinMetal byName(String name) {
            return values.get(name);
        }

        public int getColor() {
            return this.color;
        }

        static {
            values = new HashMap<String, CoinMetal>();
            Arrays.stream(CoinMetal.values()).forEach(m -> values.put(m.getName(), (CoinMetal)((Object)m)));
        }
    }
}

