/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.IAdditionalAttribute;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefault;
import org.apache.commons.lang3.Range;

@Immutable
public class FactionNpcDefault
extends NpcDefault {
    private Map<IAdditionalAttribute<?>, Object> additionalAttributes;
    private boolean enabled;
    private ResourceLocation lootTable;
    private Range<Float> heightRange;
    private float thinness;
    private String spells;

    public FactionNpcDefault(Map<String, Double> attributes, int experienceDrop, boolean canSwim, boolean canBreakDoors, Map<Integer, Item> equipment, Map<IAdditionalAttribute<?>, Object> additionaAttributes, boolean enabled, @Nullable ResourceLocation lootTable, Range<Float> heightRange, float thinness) {
        super(attributes, experienceDrop, canSwim, canBreakDoors, equipment);
        this.additionalAttributes = additionaAttributes;
        this.enabled = enabled;
        this.lootTable = lootTable;
        this.heightRange = heightRange;
        this.thinness = thinness;
        if (lootTable != null && !LootTableList.func_186374_a().contains(lootTable)) {
            LootTableList.func_186375_a((ResourceLocation)lootTable);
        }
    }

    private FactionNpcDefault copy() {
        return new FactionNpcDefault(new HashMap<String, Double>(this.attributes), this.experienceDrop, this.canSwim, this.canBreakDoors, new HashMap<Integer, Item>(this.equipment), new HashMap(this.additionalAttributes), this.enabled, this.lootTable, this.heightRange, this.thinness);
    }

    private FactionNpcDefault change(Consumer<FactionNpcDefault> makeChange) {
        FactionNpcDefault copy = this.copy();
        makeChange.accept(copy);
        return copy;
    }

    @Override
    public FactionNpcDefault setExperienceDrop(int experienceDrop) {
        return this.change(def -> {
            def.experienceDrop = experienceDrop;
        });
    }

    @Override
    public FactionNpcDefault setCanSwim(boolean canSwim) {
        return this.change(def -> {
            def.canSwim = canSwim;
        });
    }

    @Override
    public FactionNpcDefault setCanBreakDoors(boolean canBreakDoors) {
        return this.change(def -> {
            def.canBreakDoors = canBreakDoors;
        });
    }

    public FactionNpcDefault setEnabled(boolean enabled) {
        return this.change(def -> {
            def.enabled = enabled;
        });
    }

    @Override
    public FactionNpcDefault setAttributes(Map<String, Double> additionalAttributes) {
        return this.change(def -> def.attributes.putAll(additionalAttributes));
    }

    @Override
    public FactionNpcDefault setEquipment(Map<Integer, Item> additionalEquipment) {
        return this.change(def -> def.equipment.putAll(additionalEquipment));
    }

    public FactionNpcDefault setAdditionalAttributes(Map<IAdditionalAttribute<?>, Object> overrides) {
        return this.change(def -> def.additionalAttributes.putAll(overrides));
    }

    public FactionNpcDefault setLootTable(ResourceLocation lootTable) {
        return this.change(def -> {
            def.lootTable = lootTable;
        });
    }

    public FactionNpcDefault setHeightRange(Range<Float> heightRange) {
        return this.change(def -> {
            def.heightRange = heightRange;
        });
    }

    public FactionNpcDefault setThinness(float thinness) {
        return this.change(def -> {
            def.thinness = thinness;
        });
    }

    public FactionNpcDefault setSpells(String spells) {
        return this.change(def -> {
            def.spells = spells;
        });
    }

    public void applyAdditionalAttributes(NpcFaction npc) {
        this.additionalAttributes.forEach(npc::setAdditionalAttribute);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public Range<Float> getHeightRange() {
        return this.heightRange;
    }

    public float getThinness() {
        return this.thinness;
    }

    public String getSpells() {
        return this.spells;
    }
}

