/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.registry.FactionDefinition;
import net.shadowmage.ancientwarfare.npc.registry.TargetRegistry;

public class FactionRegistry {
    private static final Map<String, FactionDefinition> factions = new HashMap<String, FactionDefinition>();
    private static final FactionDefinition EMPTY_FACTION = new FactionDefinition(new FactionDefinition.StandingSettings(0, false, new HashMap<String, Integer>()), new HashSet<String>(), new HashSet<String>()).copy("", -1).build();

    private FactionRegistry() {
    }

    public static Set<String> getFactionNames() {
        return factions.keySet();
    }

    public static FactionDefinition getFaction(String name) {
        return factions.getOrDefault(name, EMPTY_FACTION);
    }

    public static Collection<FactionDefinition> getFactionDefinitions() {
        return factions.values();
    }

    public static class FactionParser
    implements IRegistryDataParser {
        private static final String PLAYER_DEFAULT_STANDING = "player_default_standing";
        private static final String STANDING_CAN_CHANGE = "standing_can_change";
        private static final String HOSTILE_TOWARDS_FACTIONS = "hostile_towards_factions";
        private static final String THEMED_BLOCKS = "themed_blocks";
        private static final String STANDING_CHANGES = "standing_changes";
        private static final String STANDING_SETTINGS = "standing_settings";

        @Override
        public String getName() {
            return "factions";
        }

        @Override
        public void parse(JsonObject json) {
            JsonObject defaults = JsonUtils.func_152754_s((JsonObject)json, (String)"defaults");
            FactionDefinition defaultDefinition = new FactionDefinition(this.parseStandingSettings(defaults), this.parseHostileTowards(defaults).entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toCollection(HashSet::new)), TargetRegistry.parseTargets(defaults).orElse(new HashSet()));
            JsonArray factionsArray = JsonUtils.func_151214_t((JsonObject)json, (String)"factions");
            for (JsonElement e : factionsArray) {
                JsonObject faction = JsonUtils.func_151210_l((JsonElement)e, (String)"faction");
                String factionName = JsonUtils.func_151200_h((JsonObject)faction, (String)"name");
                FactionDefinition.CopyBuilder builder = defaultDefinition.copy(factionName, Integer.parseInt(JsonUtils.func_151200_h((JsonObject)faction, (String)"color"), 16));
                if (faction.has(STANDING_SETTINGS)) {
                    this.overrideStandingSettings(faction, builder);
                }
                builder.removeHostileTowards(factionName);
                if (faction.has(HOSTILE_TOWARDS_FACTIONS)) {
                    Map<String, Boolean> hostileTowards = this.parseHostileTowards(faction);
                    hostileTowards.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(builder::addHostileTowards);
                    hostileTowards.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).forEach(builder::removeHostileTowards);
                }
                TargetRegistry.parseTargets(faction).ifPresent(builder::overrideTargetList);
                if (faction.has(THEMED_BLOCKS)) {
                    builder.overrideThemedBlocksTags(this.parseThemedBLocks(faction, factionName));
                }
                factions.put(factionName, builder.build());
            }
        }

        private void overrideStandingSettings(JsonObject faction, FactionDefinition.CopyBuilder builder) {
            JsonObject standingSettingsJson = JsonUtils.func_152754_s((JsonObject)faction, (String)STANDING_SETTINGS);
            builder.setStandingSettings(standingSettings -> {
                if (standingSettingsJson.has(PLAYER_DEFAULT_STANDING)) {
                    standingSettings.setPlayerDefaultStanding(JsonUtils.func_151203_m((JsonObject)standingSettingsJson, (String)PLAYER_DEFAULT_STANDING));
                }
                if (standingSettingsJson.has(STANDING_CAN_CHANGE)) {
                    standingSettings.setStandingCanChange(JsonUtils.func_151212_i((JsonObject)standingSettingsJson, (String)STANDING_CAN_CHANGE));
                }
                if (standingSettingsJson.has(STANDING_CHANGES)) {
                    standingSettings.overrideStandingChanges(this.parseStandingChanges(standingSettingsJson));
                }
            });
        }

        private FactionDefinition.StandingSettings parseStandingSettings(JsonObject factionSettings) {
            JsonObject standingSettings = JsonUtils.func_152754_s((JsonObject)factionSettings, (String)STANDING_SETTINGS);
            return new FactionDefinition.StandingSettings(JsonUtils.func_151203_m((JsonObject)standingSettings, (String)PLAYER_DEFAULT_STANDING), JsonUtils.func_151212_i((JsonObject)standingSettings, (String)STANDING_CAN_CHANGE), this.parseStandingChanges(standingSettings));
        }

        private Map<String, Integer> parseStandingChanges(JsonObject json) {
            return JsonHelper.mapFromJson(json, STANDING_CHANGES, Map.Entry::getKey, entry -> JsonUtils.func_151215_f((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey())));
        }

        private Map<String, NBTTagCompound> parseThemedBLocks(JsonObject json, String factionName) {
            return JsonHelper.mapFromJson(json, THEMED_BLOCKS, Map.Entry::getKey, entry -> this.getThemedBlocksNBT((JsonElement)entry.getValue(), factionName));
        }

        private NBTTagCompound getThemedBlocksNBT(JsonElement json, String factionName) {
            NBTTagCompound nbt;
            try {
                nbt = JsonToNBT.func_180713_a((String)json.toString());
                nbt.func_74778_a("customData", factionName);
            }
            catch (NBTException e) {
                AncientWarfareNPC.LOG.error("Error parsing themed blocks nbt", (Throwable)e);
                nbt = new NBTTagCompound();
            }
            return nbt;
        }

        private Map<String, Boolean> parseHostileTowards(JsonObject json) {
            return JsonHelper.mapFromJson(json, HOSTILE_TOWARDS_FACTIONS, Map.Entry::getKey, entry -> JsonUtils.func_151216_b((JsonElement)((JsonElement)entry.getValue()), (String)""));
        }
    }
}

