/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.RegistryTools;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.AdditionalAttributes;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.IAdditionalAttribute;
import net.shadowmage.ancientwarfare.npc.init.AWNPCEntities;
import net.shadowmage.ancientwarfare.npc.registry.FactionNpcDefault;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefault;
import net.shadowmage.ancientwarfare.npc.registry.OwnedNpcDefault;
import net.shadowmage.ancientwarfare.npc.registry.TargetRegistry;
import org.apache.commons.lang3.Range;

public class NpcDefaultsRegistry {
    private static final String NPC_SUBTYPES_ELEMENT = "npc_subtypes";
    private static Map<String, Map<String, FactionNpcDefault>> factionNpcDefaults = new HashMap<String, Map<String, FactionNpcDefault>>();
    private static Map<String, OwnedNpcDefault> ownedNpcDefaults = new HashMap<String, OwnedNpcDefault>();
    private static final String FACTION_NPC_PREFIX = "faction.";

    private NpcDefaultsRegistry() {
    }

    public static FactionNpcDefault getFactionNpcDefault(String faction, String npcType) {
        return factionNpcDefaults.get(faction).get(npcType);
    }

    public static FactionNpcDefault getFactionNpcDefault(NpcFaction npc) {
        return factionNpcDefaults.get(npc.getFaction()).get(npc.getNpcType());
    }

    public static OwnedNpcDefault getOwnedNpcDefault(NpcPlayerOwned npc) {
        return ownedNpcDefaults.get(npc.getNpcType());
    }

    public static class FactionNpcDefaultsParser
    extends NpcDefaultsParserBase {
        private static final String HEIGHT_ELEMENT = "height";
        private static final String THINNESS_ELEMENT = "thinness";

        @Override
        public String getName() {
            return "faction_npc_defaults";
        }

        @Override
        public void parse(JsonObject json) {
            Map<String, FactionNpcDefault> npcSubtypeDefaults = this.parseDefaultsWithSubtypes(json);
            this.parseFactions(json, npcSubtypeDefaults);
        }

        private Map<String, FactionNpcDefault> parseDefaultsWithSubtypes(JsonObject json) {
            JsonObject defaults = JsonUtils.func_152754_s((JsonObject)json, (String)"defaults");
            FactionNpcDefault globalDefault = new FactionNpcDefault(this.getAttributes(defaults), this.getExperienceDrop(defaults).orElse(0), this.getCanSwim(defaults).orElse(true), this.getCanBreakDoors(defaults).orElse(true), this.getEquipment(defaults), this.getAdditionalAttributes(defaults), this.getEnabled(defaults).orElse(true), this.getLootTable(defaults).orElse(null), this.getHeightRange(defaults).orElse((Range<Float>)Range.between((Comparable)Float.valueOf(1.8f), (Comparable)Float.valueOf(1.8f))), this.getThinness(defaults).orElse(Float.valueOf(1.0f)).floatValue());
            return this.parseSubtypes(defaults, globalDefault);
        }

        private Map<IAdditionalAttribute<?>, Object> getAdditionalAttributes(JsonObject json) {
            if (!json.has("additional_attributes")) {
                return Collections.emptyMap();
            }
            return JsonHelper.mapFromJson(json, "additional_attributes", e -> AdditionalAttributes.getByName((String)e.getKey()), e -> this.parseAttributeValue(AdditionalAttributes.getByName((String)e.getKey()), ((JsonElement)e.getValue()).getAsString()));
        }

        private <T> T parseAttributeValue(IAdditionalAttribute<T> attribute, String value) {
            return attribute.parseValue(value).orElse(attribute.getValueClass().cast(null));
        }

        private void parseFactions(JsonObject json, Map<String, FactionNpcDefault> npcSubtypeDefaults) {
            JsonHelper.mapFromJson(json, "factions", factionNpcDefaults, Map.Entry::getKey, e -> {
                JsonObject factionElement = JsonUtils.func_151210_l((JsonElement)((JsonElement)e.getValue()), (String)"");
                Map<String, FactionNpcDefault> factionSubtypeDefaults = this.getFactionDefaults((JsonElement)factionElement, npcSubtypeDefaults);
                if (factionElement.has(NpcDefaultsRegistry.NPC_SUBTYPES_ELEMENT)) {
                    factionSubtypeDefaults = this.getFactionNpcDefaults(factionSubtypeDefaults, factionElement.get(NpcDefaultsRegistry.NPC_SUBTYPES_ELEMENT));
                }
                return factionSubtypeDefaults;
            });
            this.fillRemainingFactionDefaults(npcSubtypeDefaults);
        }

        private FactionNpcDefault getSubtypeDefault(String subtype, JsonElement json, Function<String, FactionNpcDefault> getEntry) {
            JsonObject data = JsonUtils.func_151210_l((JsonElement)json, (String)"");
            NpcDefault npcSubtypeDefault = getEntry.apply(subtype);
            npcSubtypeDefault = ((FactionNpcDefault)npcSubtypeDefault).setAttributes((Map)this.getAttributes(data));
            npcSubtypeDefault = this.getExperienceDrop(data).map(((FactionNpcDefault)npcSubtypeDefault)::setExperienceDrop).orElse((FactionNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getCanSwim(data).map(((FactionNpcDefault)npcSubtypeDefault)::setCanSwim).orElse((FactionNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getCanBreakDoors(data).map(((FactionNpcDefault)npcSubtypeDefault)::setCanBreakDoors).orElse((FactionNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = ((FactionNpcDefault)npcSubtypeDefault).setEquipment((Map)this.getEquipment(data));
            npcSubtypeDefault = ((FactionNpcDefault)npcSubtypeDefault).setAdditionalAttributes(this.getAdditionalAttributes(data));
            npcSubtypeDefault = this.getEnabled(data).map(((FactionNpcDefault)npcSubtypeDefault)::setEnabled).orElse((FactionNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getLootTable(data).map(((FactionNpcDefault)npcSubtypeDefault)::setLootTable).orElse((FactionNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getHeightRange(data).map(((FactionNpcDefault)npcSubtypeDefault)::setHeightRange).orElse((FactionNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getThinness(data).map(((FactionNpcDefault)npcSubtypeDefault)::setThinness).orElse((FactionNpcDefault)npcSubtypeDefault);
            if (subtype.contains("spellcaster")) {
                npcSubtypeDefault = this.getSpells(data).map(((FactionNpcDefault)npcSubtypeDefault)::setSpells).orElse((FactionNpcDefault)npcSubtypeDefault);
            }
            return npcSubtypeDefault;
        }

        private Optional<String> getSpells(JsonObject json) {
            return json.has("spells") ? Optional.of(JsonUtils.func_151200_h((JsonObject)json, (String)"spells")) : Optional.empty();
        }

        private Optional<Boolean> getEnabled(JsonObject data) {
            return data.has("enabled") ? Optional.of(JsonUtils.func_151212_i((JsonObject)data, (String)"enabled")) : Optional.empty();
        }

        private Optional<Range<Float>> getHeightRange(JsonObject data) {
            if (!data.has(HEIGHT_ELEMENT)) {
                return Optional.empty();
            }
            if (JsonUtils.func_151201_f((JsonObject)data, (String)HEIGHT_ELEMENT)) {
                return Optional.of(Range.between((Comparable)Float.valueOf(JsonUtils.func_151217_k((JsonObject)data, (String)HEIGHT_ELEMENT)), (Comparable)Float.valueOf(JsonUtils.func_151217_k((JsonObject)data, (String)HEIGHT_ELEMENT))));
            }
            JsonObject range = JsonUtils.func_152754_s((JsonObject)data, (String)HEIGHT_ELEMENT);
            return Optional.of(Range.between((Comparable)Float.valueOf(JsonUtils.func_151217_k((JsonObject)range, (String)"min")), (Comparable)Float.valueOf(JsonUtils.func_151217_k((JsonObject)range, (String)"max"))));
        }

        private Optional<Float> getThinness(JsonObject data) {
            if (!data.has(THINNESS_ELEMENT)) {
                return Optional.empty();
            }
            return Optional.of(Float.valueOf(JsonUtils.func_151217_k((JsonObject)data, (String)THINNESS_ELEMENT)));
        }

        private Optional<ResourceLocation> getLootTable(JsonObject data) {
            return data.has("loot_table") ? Optional.of(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)data, (String)"loot_table"))) : Optional.empty();
        }

        private Map<String, FactionNpcDefault> parseSubtypes(JsonObject json, FactionNpcDefault overallDefault) {
            Map<String, FactionNpcDefault> npcSubtypeDefaults = JsonHelper.mapFromJson(json, NpcDefaultsRegistry.NPC_SUBTYPES_ELEMENT, Map.Entry::getKey, e -> this.getSubtypeDefault((String)e.getKey(), (JsonElement)e.getValue(), s -> overallDefault));
            this.fillRemainingSubtypeDefaults(overallDefault, npcSubtypeDefaults);
            return npcSubtypeDefaults;
        }

        private Map<String, FactionNpcDefault> getFactionDefaults(JsonElement json, Map<String, FactionNpcDefault> npcSubtypeDefaults) {
            HashMap<String, FactionNpcDefault> ret = new HashMap<String, FactionNpcDefault>();
            for (String subtype : npcSubtypeDefaults.keySet()) {
                ret.put(subtype, this.getSubtypeDefault(subtype, json, npcSubtypeDefaults::get));
            }
            return ret;
        }

        private Map<String, FactionNpcDefault> getFactionNpcDefaults(Map<String, FactionNpcDefault> npcSubtypeDefaults, JsonElement subtypesElement) {
            Map<String, FactionNpcDefault> typeDefaults = JsonHelper.mapFromJson(subtypesElement, Map.Entry::getKey, e -> this.getSubtypeDefault((String)e.getKey(), (JsonElement)e.getValue(), npcSubtypeDefaults::get));
            for (Map.Entry<String, FactionNpcDefault> subtypeDefault : npcSubtypeDefaults.entrySet()) {
                if (typeDefaults.keySet().contains(subtypeDefault.getKey())) continue;
                typeDefaults.put(subtypeDefault.getKey(), subtypeDefault.getValue());
            }
            return typeDefaults;
        }

        private void fillRemainingFactionDefaults(Map<String, FactionNpcDefault> npcSubtypeDefaults) {
            for (String faction : FactionRegistry.getFactionNames()) {
                if (factionNpcDefaults.keySet().contains(faction)) continue;
                HashMap typeDefaults = new HashMap();
                npcSubtypeDefaults.forEach(typeDefaults::put);
                factionNpcDefaults.put(faction, typeDefaults);
            }
        }

        private void fillRemainingSubtypeDefaults(FactionNpcDefault overallDefault, Map<String, FactionNpcDefault> npcSubtypeDefaults) {
            for (String subtype : this.getFactionNpcSubtypes()) {
                if (npcSubtypeDefaults.keySet().contains(subtype)) continue;
                npcSubtypeDefaults.put(subtype, overallDefault);
            }
        }

        private List<String> getFactionNpcSubtypes() {
            return AWNPCEntities.getNpcMap().keySet().stream().filter(k -> k.startsWith(NpcDefaultsRegistry.FACTION_NPC_PREFIX)).map(k -> k.replace(NpcDefaultsRegistry.FACTION_NPC_PREFIX, "")).collect(Collectors.toList());
        }
    }

    private static abstract class NpcDefaultsParserBase
    implements IRegistryDataParser {
        private NpcDefaultsParserBase() {
        }

        protected Optional<Boolean> getCanBreakDoors(JsonObject json) {
            return json.has("can_break_doors") ? Optional.of(JsonUtils.func_151212_i((JsonObject)json, (String)"can_break_doors")) : Optional.empty();
        }

        protected Optional<Boolean> getCanSwim(JsonObject json) {
            return json.has("can_swim") ? Optional.of(JsonUtils.func_151212_i((JsonObject)json, (String)"can_swim")) : Optional.empty();
        }

        protected Optional<Integer> getExperienceDrop(JsonObject json) {
            return json.has("experience_drop") ? Optional.of(JsonUtils.func_151203_m((JsonObject)json, (String)"experience_drop")) : Optional.empty();
        }

        protected Map<String, Double> getAttributes(JsonObject json) {
            if (!json.has("attributes")) {
                return Collections.emptyMap();
            }
            return JsonHelper.mapFromJson(json, "attributes", Map.Entry::getKey, e -> JsonUtils.func_151220_d((JsonElement)((JsonElement)e.getValue()), (String)""));
        }

        protected Map<Integer, Item> getEquipment(JsonObject json) {
            if (!json.has("equipment")) {
                return Collections.emptyMap();
            }
            return JsonHelper.mapFromJson(json, "equipment", e -> this.parseEquipmentSlot((String)e.getKey()), e -> this.parseEquipmentItem((JsonElement)e.getValue()));
        }

        private Item parseEquipmentItem(JsonElement itemJson) {
            try {
                return RegistryTools.getItem(JsonUtils.func_151206_a((JsonElement)itemJson, (String)""));
            }
            catch (MissingResourceException ex) {
                AncientWarfareNPC.LOG.error("Error parsing faction npc equipment: ", (Throwable)ex);
                return Items.field_190931_a;
            }
        }

        private int parseEquipmentSlot(String slotName) {
            int slot = Arrays.stream(EntityEquipmentSlot.values()).filter(s -> s.func_188450_d().equals(slotName)).map(Enum::ordinal).findFirst().orElse(-1);
            if (slot > -1) {
                return slot;
            }
            switch (slotName) {
                case "work": {
                    return 6;
                }
                case "upkeep": {
                    return 7;
                }
            }
            throw new JsonParseException("Invalid equipment slot name \"" + slotName + "\"");
        }
    }

    public static class OwnedNpcDefaultsParser
    extends NpcDefaultsParserBase {
        @Override
        public String getName() {
            return "owned_npc_defaults";
        }

        @Override
        public void parse(JsonObject json) {
            OwnedNpcDefault overallDefault = this.parseDefaults(json);
            this.parseSubtypes(json, overallDefault);
        }

        private OwnedNpcDefault parseDefaults(JsonObject json) {
            JsonObject defaults = JsonUtils.func_152754_s((JsonObject)json, (String)"defaults");
            return new OwnedNpcDefault(TargetRegistry.parseTargets(defaults).orElse(new HashSet()), this.getAttributes(defaults), this.getExperienceDrop(defaults).orElse(0), this.getCanSwim(defaults).orElse(true), this.getCanBreakDoors(defaults).orElse(true), this.getEquipment(defaults));
        }

        private void parseSubtypes(JsonObject json, OwnedNpcDefault overallDefault) {
            ownedNpcDefaults.putAll(JsonHelper.mapFromJson(json, NpcDefaultsRegistry.NPC_SUBTYPES_ELEMENT, Map.Entry::getKey, e -> this.getSubtypeDefault((Map.Entry<String, JsonElement>)e, s -> overallDefault)));
            this.fillRemainingSubtypeDefaults(overallDefault, ownedNpcDefaults);
        }

        private OwnedNpcDefault getSubtypeDefault(Map.Entry<String, JsonElement> entry, Function<String, OwnedNpcDefault> setKey) {
            JsonObject data = JsonUtils.func_151210_l((JsonElement)entry.getValue(), (String)"");
            NpcDefault npcSubtypeDefault = setKey.apply(entry.getKey());
            npcSubtypeDefault = ((OwnedNpcDefault)npcSubtypeDefault).setAttributes((Map)this.getAttributes(data));
            npcSubtypeDefault = this.getExperienceDrop(data).map(((OwnedNpcDefault)npcSubtypeDefault)::setExperienceDrop).orElse((OwnedNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getCanSwim(data).map(((OwnedNpcDefault)npcSubtypeDefault)::setCanSwim).orElse((OwnedNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = this.getCanBreakDoors(data).map(((OwnedNpcDefault)npcSubtypeDefault)::setCanBreakDoors).orElse((OwnedNpcDefault)npcSubtypeDefault);
            npcSubtypeDefault = ((OwnedNpcDefault)npcSubtypeDefault).setEquipment((Map)this.getEquipment(data));
            Optional<Set<String>> targets = TargetRegistry.parseTargets(data);
            if (targets.isPresent()) {
                npcSubtypeDefault = ((OwnedNpcDefault)npcSubtypeDefault).overrideTargets(targets.get());
            }
            return npcSubtypeDefault;
        }

        private void fillRemainingSubtypeDefaults(OwnedNpcDefault overallDefault, Map<String, OwnedNpcDefault> npcSubtypeDefaults) {
            for (String subtype : AWNPCEntities.getNpcMap().keySet().stream().filter(k -> !k.startsWith(NpcDefaultsRegistry.FACTION_NPC_PREFIX)).collect(Collectors.toList())) {
                if (npcSubtypeDefaults.keySet().contains(subtype)) continue;
                npcSubtypeDefaults.put(subtype, overallDefault);
            }
        }
    }
}

