/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.tile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.tile.TileOwned;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.container.ContainerTownHall;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.item.ItemNpcSpawner;

public class TileTownHall
extends TileOwned
implements IInteractableTile,
ITickable,
IBlockBreakHandler {
    public boolean alarmActive = false;
    public String name = "Unnamed";
    private int broadcastRange = AWNPCStatics.townMaxRange;
    private int updateDelayTicks = 0;
    private boolean isActive = true;
    private boolean isNeglected = false;
    private String oldOwner = null;
    private final List<NpcDeathEntry> deathNotices = new ArrayList<NpcDeathEntry>();
    private final ItemStackHandler inventory = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileTownHall.this.func_70296_d();
        }
    };
    private final List<ContainerTownHall> viewers = new ArrayList<ContainerTownHall>();
    private ForgeChunkManager.Ticket ticket;

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        --this.updateDelayTicks;
        if (this.updateDelayTicks <= 0 && this.isActive) {
            this.broadcast();
            this.updateDelayTicks = AWNPCStatics.townUpdateFreq;
        }
    }

    public void addViewer(ContainerTownHall viewer) {
        if (!this.viewers.contains((Object)viewer)) {
            this.viewers.add(viewer);
        }
    }

    public void removeViewer(ContainerTownHall viewer) {
        while (this.viewers.contains((Object)viewer)) {
            this.viewers.remove((Object)viewer);
        }
    }

    private void broadcast() {
        AxisAlignedBB bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.broadcastRange), (double)(this.field_174879_c.func_177956_o() - this.broadcastRange / 2), (double)(this.field_174879_c.func_177952_p() - this.broadcastRange), (double)(this.field_174879_c.func_177958_n() + this.broadcastRange + 1), (double)(this.field_174879_c.func_177956_o() + this.broadcastRange / 2 + 1), (double)(this.field_174879_c.func_177952_p() + this.broadcastRange + 1));
        List entities = this.field_145850_b.func_72872_a(NpcPlayerOwned.class, bb);
        if (entities.size() > 0) {
            for (Entity entity : entities) {
                if (!((NpcPlayerOwned)entity).hasCommandPermissions(this.getOwner())) continue;
                ((NpcPlayerOwned)entity).handleTownHallBroadcast(this.field_174879_c);
            }
        }
    }

    public void clearDeathNotices() {
        this.deathNotices.clear();
        this.informViewers();
    }

    public void informViewers() {
        for (ContainerTownHall cth : this.viewers) {
            cth.onTownHallDeathListUpdated();
        }
    }

    public void handleNpcDeath(NpcPlayerOwned npc, DamageSource source) {
        boolean canRes = true;
        NpcDeathEntry entry = new NpcDeathEntry(npc, source, canRes);
        this.deathNotices.add(entry);
        this.informViewers();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        NBTTagList entryList = tag.func_150295_c("deathNotices", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NpcDeathEntry entry = new NpcDeathEntry(entryList.func_150305_b(i));
            this.deathNotices.add(entry);
        }
        if (tag.func_74764_b("name")) {
            this.name = tag.func_74779_i("name");
        }
        if (tag.func_74764_b("range")) {
            this.setRange(tag.func_74762_e("range"));
        }
        if (tag.func_74764_b("alarmActive")) {
            this.alarmActive = tag.func_74767_n("alarmActive");
        }
        if (tag.func_74764_b("isActive")) {
            this.isActive = tag.func_74767_n("isActive");
        }
        if (tag.func_74764_b("isNeglected")) {
            this.isNeglected = tag.func_74767_n("isNeglected");
        }
        if (tag.func_74764_b("oldOwner")) {
            this.oldOwner = tag.func_74779_i("oldOwner");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        NBTTagList entryList = new NBTTagList();
        for (NpcDeathEntry entry : this.deathNotices) {
            entryList.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("deathNotices", (NBTBase)entryList);
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("range", this.broadcastRange);
        tag.func_74757_a("alarmActive", this.alarmActive);
        tag.func_74757_a("isActive", this.isActive);
        tag.func_74757_a("isNeglected", this.isNeglected);
        if (this.oldOwner != null) {
            tag.func_74778_a("oldOwner", this.oldOwner);
        }
        return tag;
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.inventory, this.field_174879_c);
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && this.isOwner(player)) {
            NetworkHandler.INSTANCE.openGui(player, 41, this.field_174879_c);
        }
        return true;
    }

    public List<NpcDeathEntry> getDeathList() {
        return this.deathNotices;
    }

    public int getRange() {
        return this.broadcastRange;
    }

    public void setRange(int val) {
        this.broadcastRange = val < AWNPCStatics.townMaxRange ? val : AWNPCStatics.townMaxRange;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public static class NpcDeathEntry {
        public ItemStack stackToSpawn;
        public String npcType;
        public String npcName;
        public String deathCause;
        public boolean resurrected;
        public boolean canRes;
        public boolean beingResurrected;
        public int[] pos;

        public NpcDeathEntry(NBTTagCompound tag) {
            this.readFromNBT(tag);
        }

        public NpcDeathEntry(NpcPlayerOwned npc, DamageSource source, boolean canRes) {
            this.stackToSpawn = ItemNpcSpawner.getSpawnerItemForNpc(npc);
            this.npcType = npc.getNpcFullType();
            this.npcName = npc.func_95999_t();
            this.deathCause = source.field_76373_n;
            this.canRes = canRes;
            this.pos = new int[]{MathHelper.func_76128_c((double)npc.field_70165_t), MathHelper.func_76128_c((double)npc.field_70163_u), MathHelper.func_76128_c((double)npc.field_70161_v)};
        }

        public final void readFromNBT(NBTTagCompound tag) {
            this.stackToSpawn = new ItemStack(tag.func_74775_l("spawnerStack"));
            this.npcType = tag.func_74779_i("npcType");
            this.npcName = tag.func_74779_i("npcName");
            this.deathCause = tag.func_74779_i("deathCause");
            this.resurrected = tag.func_74767_n("resurrected");
            this.canRes = tag.func_74767_n("canRes");
            this.pos = tag.func_74759_k("pos");
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74782_a("spawnerStack", (NBTBase)this.stackToSpawn.func_77955_b(new NBTTagCompound()));
            tag.func_74778_a("npcType", this.npcType);
            tag.func_74778_a("npcName", this.npcName);
            tag.func_74778_a("deathCause", this.deathCause);
            tag.func_74757_a("resurrected", this.resurrected);
            tag.func_74757_a("canRes", this.canRes);
            tag.func_74783_a("pos", this.pos);
            return tag;
        }
    }
}

