/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;

public abstract class TemplateRule {
    public static final String JSON_PREFIX = "JSON:";
    public int ruleNumber = -1;

    public abstract void handlePlacement(World var1, int var2, BlockPos var3, IStructureBuilder var4);

    public abstract void writeRuleData(NBTTagCompound var1);

    public abstract List<ItemStack> getResources();

    public abstract ItemStack getRemainingStack();

    public abstract boolean shouldPlaceOnBuildPass(World var1, int var2, BlockPos var3, int var4);

    public abstract void parseRule(NBTTagCompound var1);

    public void writeRule(BufferedWriter out) throws IOException {
        out.write(this.getRuleType() + ":");
        out.newLine();
        out.write("plugin=" + this.getPluginName());
        out.newLine();
        out.write("number=" + this.ruleNumber);
        out.newLine();
        out.write("data:");
        out.newLine();
        NBTTagCompound tag = new NBTTagCompound();
        this.writeRuleData(tag);
        this.writeTag(out, tag);
        out.write(":enddata");
        out.newLine();
        out.write(":end" + this.getRuleType());
        out.newLine();
        out.newLine();
    }

    public abstract String getPluginName();

    protected abstract String getRuleType();

    private void writeTag(BufferedWriter out, NBTTagCompound tag) throws IOException {
        String line = JSON_PREFIX + tag.toString();
        out.write(line);
        out.newLine();
    }

    public String toString() {
        return "Template rule: " + this.ruleNumber + " type: " + this.getClass().getSimpleName();
    }

    public boolean placeInSurvival() {
        return false;
    }
}

