/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.api;

import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.registry.StructureBlockRegistry;

public abstract class TemplateRuleBlock
extends TemplateRule {
    protected IBlockState state;
    private ItemStack cachedStack = null;
    private boolean placeInSurvival = false;

    public TemplateRuleBlock(IBlockState state, int turns) {
        this.state = BlockTools.rotateFacing(state, turns);
    }

    public TemplateRuleBlock() {
    }

    public abstract boolean shouldReuseRule(World var1, IBlockState var2, int var3, BlockPos var4);

    @Override
    public List<ItemStack> getResources() {
        if (this.state.func_177230_c() == Blocks.field_150350_a) {
            return Collections.emptyList();
        }
        ItemStack stack = this.getCachedStack();
        if (!stack.func_190926_b()) {
            return Collections.singletonList(stack);
        }
        return Collections.emptyList();
    }

    private ItemStack getCachedStack() {
        this.cacheStack();
        return this.cachedStack;
    }

    private void cacheStack() {
        if (this.cachedStack == null) {
            Optional<ItemStack> stack = this.getStack();
            this.placeInSurvival = stack.isPresent();
            this.cachedStack = stack.orElse(ItemStack.field_190927_a);
        }
    }

    protected Optional<ItemStack> getStack() {
        return StructureBlockRegistry.getItemStackFrom(this.state);
    }

    @Override
    public ItemStack getRemainingStack() {
        return StructureBlockRegistry.getRemainingStackFrom(this.state);
    }

    @Override
    public boolean placeInSurvival() {
        this.cacheStack();
        return this.state.func_177230_c() != Blocks.field_150350_a && this.placeInSurvival;
    }

    @Override
    protected String getRuleType() {
        return "rule";
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        try {
            this.state = NBTHelper.getBlockState(tag.func_74775_l("blockState"));
        }
        catch (MissingResourceException e) {
            AncientWarfareStructure.LOG.warn("Unable to find blockstate while parsing structure template thus replacing it with air - {}.", (Object)e.getMessage());
            this.state = Blocks.field_150350_a.func_176223_P();
        }
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        tag.func_74782_a("blockState", (NBTBase)NBTHelper.getBlockStateTag(this.state));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRule(int turns, BlockPos pos, IBlockAccess blockAccess, BufferBuilder bufferBuilder) {
        Minecraft.func_71410_x().func_175602_ab().func_175018_a(this.getState(turns), pos, blockAccess, bufferBuilder);
    }

    public IBlockState getState(int turns) {
        return BlockTools.rotateFacing(this.state, turns);
    }

    @Nullable
    public TileEntity getTileEntity(int turns) {
        return null;
    }

    public boolean isDynamicallyRendered(int turns) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRuleDynamic(int turns, BlockPos pos) {
        RenderTools.renderTESR(this.getTileEntity(turns), pos);
    }
}

