/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.tile.TileFlag;

public class BlockFlag
extends BlockBaseStructure {
    private static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);
    private Set<FlagDefinition> flagDefinitions = new LinkedHashSet<FlagDefinition>();

    BlockFlag(Material material, String regname) {
        super(material, regname);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_181623_g() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STANDING_AABB;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 16)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(mirrorIn.func_185802_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 16)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ROTATION);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (FlagDefinition flagDefinition : this.flagDefinitions) {
            ItemStack stack = new ItemStack((Block)this);
            stack.func_77982_d(new NBTBuilder().setString("name", flagDefinition.getName()).build());
            items.add((Object)stack);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileFlag) {
            BlockFlag.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)((TileFlag)te).getItemStack());
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return WorldTools.getTile((IBlockAccess)world, pos, TileFlag.class).map(TileFlag::getItemStack).orElse(new ItemStack((Block)this));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)WorldTools.getTile(world, pos, TileFlag.class).map(TileFlag::getItemStack).orElse(new ItemStack((Block)this)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        WorldTools.getTile((IBlockAccess)world, pos, TileFlag.class).ifPresent(te -> te.setFromStack(stack));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int rotation = MathHelper.func_76128_c((double)((double)((placer.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
        return this.func_176223_P().func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(rotation));
    }

    public void addFlagDefinition(FlagDefinition flagDefinition) {
        this.flagDefinitions.add(flagDefinition);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public static class FlagDefinition {
        private String name;

        public FlagDefinition(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

