/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.structure.block.BlockSeat;
import net.shadowmage.ancientwarfare.structure.render.property.StructureProperties;
import net.shadowmage.ancientwarfare.structure.render.property.TopBottomPart;
import net.shadowmage.ancientwarfare.structure.util.RotationLimit;

public class BlockGoldenThrone
extends BlockSeat {
    private static final Map<EnumFacing, AxisAlignedBB> TOP_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 0.9375), (Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 1.0, 0.1875), (Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.0625, 0.0, 0.0, 0.1875, 1.0, 1.0), (Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.8125, 0.0, 0.0, 0.9375, 1.0, 1.0));
    private static final Map<EnumFacing, AxisAlignedBB> BOTTOM_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 1.0, 0.9375), (Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 1.0, 0.9375), (Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 1.0, 1.0), (Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 1.0, 1.0));

    public BlockGoldenThrone() {
        super(Material.field_151573_f, "golden_throne");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING, StructureProperties.TOP_BOTTOM_PART});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a(StructureProperties.TOP_BOTTOM_PART, (Comparable)((Object)TopBottomPart.byMeta(meta >> 2 & 1)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b() | ((TopBottomPart)((Object)state.func_177229_b(StructureProperties.TOP_BOTTOM_PART))).getMeta() << 2;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(StructureProperties.TOP_BOTTOM_PART) == TopBottomPart.BOTTOM ? BOTTOM_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING)) : TOP_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(StructureProperties.TOP_BOTTOM_PART, (Comparable)((Object)TopBottomPart.TOP)));
        world.func_175656_a(pos, state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(StructureProperties.TOP_BOTTOM_PART, (Comparable)((Object)TopBottomPart.BOTTOM)));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b(StructureProperties.TOP_BOTTOM_PART) == TopBottomPart.BOTTOM) {
            return super.func_180639_a(world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        return stateDown.func_177230_c().func_180639_a(world, pos.func_177977_b(), stateDown, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public RotationLimit getRotationLimit(World world, BlockPos seatPos, IBlockState state) {
        return new RotationLimit.FacingQuarter((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockPos otherPos;
        BlockPos blockPos = otherPos = state.func_177229_b(StructureProperties.TOP_BOTTOM_PART) == TopBottomPart.BOTTOM ? pos.func_177984_a() : pos.func_177977_b();
        if (!world.func_175623_d(otherPos)) {
            world.func_175698_g(otherPos);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ResourceLocation assetLocation = new ResourceLocation("ancientwarfare", "structure/" + this.getRegistryName().func_110623_a());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(assetLocation, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        ModelLoaderHelper.registerItem(this, "structure", "inventory");
    }
}

