/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;

public class BlockIronCage
extends BlockBaseStructure {
    private static final PropertyEnum<Part> PART = PropertyEnum.func_177709_a((String)"part", Part.class);
    private static final Map<EnumFacing, List<AxisAlignedBB>> BOTTOM_BASE_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)ImmutableList.of((Object)new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.125, 1.0)), (Object)EnumFacing.SOUTH, (Object)ImmutableList.of((Object)new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.125, 1.0)), (Object)EnumFacing.EAST, (Object)ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.125, 0.875)), (Object)EnumFacing.WEST, (Object)ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.125, 0.875)));
    private static final AxisAlignedBB MIDDLE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final Map<EnumFacing, List<AxisAlignedBB>> TOP_AABBs = ImmutableMap.of((Object)EnumFacing.NORTH, (Object)ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AxisAlignedBB(0.375, 0.625, 0.0, 0.625, 0.875, 1.0)), (Object)EnumFacing.SOUTH, (Object)ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AxisAlignedBB(0.375, 0.625, 0.0, 0.625, 0.875, 1.0)), (Object)EnumFacing.EAST, (Object)ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AxisAlignedBB(0.0, 0.625, 0.375, 1.0, 0.875, 0.625)), (Object)EnumFacing.WEST, (Object)ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AxisAlignedBB(0.0, 0.625, 0.375, 1.0, 0.875, 0.625)));

    public BlockIronCage() {
        super(Material.field_151575_d, "iron_cage");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING, CoreProperties.VISIBLE, PART});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)(meta >> 2 & 3))).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf((meta >> 1 & 1) == 1)).func_177226_a(PART, (Comparable)((Object)Part.byMeta(meta & 1)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b() << 2 | ((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? 1 : 0) << 1 | ((Part)((Object)state.func_177229_b(PART))).getMeta();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE) != false ? super.func_149645_b(state) : EnumBlockRenderType.INVISIBLE;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IBlockState placeState = state.func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        world.func_175656_a(pos, placeState.func_177226_a(PART, (Comparable)((Object)Part.BOTTOM)).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177984_a(), placeState.func_177226_a(PART, (Comparable)((Object)Part.BOTTOM)).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(false)));
        world.func_175656_a(pos.func_177981_b(2), placeState.func_177226_a(PART, (Comparable)((Object)Part.TOP)).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(true)));
        world.func_175656_a(pos.func_177981_b(3), placeState.func_177226_a(PART, (Comparable)((Object)Part.TOP)).func_177226_a((IProperty)CoreProperties.VISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(PART) != Part.BOTTOM || !((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            IBlockState currentState = state;
            BlockPos currentPos = pos;
            for (int i = 1; !(i >= 4 || currentState.func_177229_b(PART) == Part.BOTTOM && ((Boolean)currentState.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()); ++i) {
                currentPos = pos.func_177979_c(i);
                currentState = world.func_180495_p(currentPos);
                if (currentState.func_177230_c() == this) continue;
                return;
            }
            if (currentState.func_177229_b(PART) == Part.BOTTOM && ((Boolean)currentState.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
                currentState.func_177230_c().func_180663_b(world, currentPos, currentState);
                return;
            }
        }
        world.func_175698_g(pos.func_177981_b(3));
        world.func_175698_g(pos.func_177981_b(2));
        world.func_175698_g(pos.func_177984_a());
        world.func_175698_g(pos);
        super.func_180663_b(world, pos, state);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        if (state.func_177229_b(PART) == Part.BOTTOM) {
            if (((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
                return RayTraceUtils.raytraceMultiAABB(BOTTOM_BASE_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING)), pos, start, end, (rtr, aabb) -> rtr);
            }
            return this.func_185503_a(pos, start, end, MIDDLE_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            return this.func_185503_a(pos, start, end, MIDDLE_AABB);
        }
        return RayTraceUtils.raytraceMultiAABB(TOP_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING)), pos, start, end, (rtr, aabb) -> rtr);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return MIDDLE_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        if (state.func_177229_b(PART) == Part.BOTTOM) {
            if (((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                return RayTraceUtils.getSelectedBoundingBox(BOTTOM_BASE_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING)), pos, (EntityPlayer)player);
            }
            return MIDDLE_AABB.func_186670_a(pos);
        }
        if (((Boolean)state.func_177229_b((IProperty)CoreProperties.VISIBLE)).booleanValue()) {
            return MIDDLE_AABB.func_186670_a(pos);
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return RayTraceUtils.getSelectedBoundingBox(TOP_AABBs.get(state.func_177229_b((IProperty)CoreProperties.FACING)), pos, (EntityPlayer)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ResourceLocation assetLocation = new ResourceLocation("ancientwarfare", "structure/" + this.getRegistryName().func_110623_a());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(assetLocation, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        ModelLoaderHelper.registerItem(this, "structure", "inventory");
    }

    public static enum Part implements IStringSerializable
    {
        TOP("top", 0),
        BOTTOM("bottom", 1);

        private String name;
        private int meta;
        private static final Map<Integer, Part> META_TO_PART;

        private Part(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static Part byMeta(int meta) {
            return META_TO_PART.get(meta);
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Part part : Part.values()) {
                builder.put((Object)part.getMeta(), (Object)part);
            }
            META_TO_PART = builder.build();
        }
    }
}

