/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.structure.block.BlockSeat;
import net.shadowmage.ancientwarfare.structure.block.WoodVariant;
import net.shadowmage.ancientwarfare.structure.util.BlockStateProperties;
import net.shadowmage.ancientwarfare.structure.util.RotationLimit;
import net.shadowmage.ancientwarfare.structure.util.WoodVariantHelper;

public class BlockStool
extends BlockSeat {
    private static final Vec3d SEAT_OFFSET = new Vec3d(0.5, 0.35, 0.5);
    private static final AxisAlignedBB STOOL_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.5625, 0.8125);

    public BlockStool() {
        super(Material.field_151575_d, "stool");
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        WoodVariantHelper.getSubBlocks(this, items);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        world.func_175656_a(pos, state.func_177226_a(BlockStateProperties.VARIANT, (Comparable)((Object)WoodVariantHelper.getVariant(stack))));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return WoodVariantHelper.getPickBlock(this, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateProperties.VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BlockStateProperties.VARIANT, (Comparable)((Object)WoodVariant.byMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((WoodVariant)((Object)state.func_177229_b(BlockStateProperties.VARIANT))).getMeta();
    }

    @Override
    protected Vec3d getSeatOffset() {
        return SEAT_OFFSET;
    }

    @Override
    public RotationLimit getRotationLimit(World world, BlockPos pos, IBlockState state) {
        return RotationLimit.NO_LIMIT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STOOL_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        WoodVariantHelper.registerClient(this);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        WoodVariantHelper.getDrops(this, drops, state);
    }
}

