/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockCoffin;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockWoodenCoffin;
import net.shadowmage.ancientwarfare.structure.render.ParticleOnlyModel;
import net.shadowmage.ancientwarfare.structure.render.WoodenCoffinRenderer;
import net.shadowmage.ancientwarfare.structure.tile.TileWoodenCoffin;

public class BlockWoodenCoffin
extends BlockCoffin<TileWoodenCoffin> {
    private static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);

    public BlockWoodenCoffin() {
        super(Material.field_151575_d, "wooden_coffin", TileWoodenCoffin::new, TileWoodenCoffin.class);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Variant variant : Variant.values()) {
            items.add((Object)ItemBlockWoodenCoffin.getVariantStack(variant));
        }
    }

    @Override
    protected List<IProperty> getAdditionalProperties() {
        return Collections.singletonList(VARIANT);
    }

    @Override
    protected void setPlacementProperties(World world, BlockPos pos, EntityLivingBase placer, ItemStack stack, TileWoodenCoffin te) {
        boolean upright = !ItemBlockWoodenCoffin.canPlaceHorizontal(world, pos, placer.func_174811_aO(), placer);
        te.setUpright(upright);
        te.setVariant(ItemBlockWoodenCoffin.getVariant(stack));
    }

    @Override
    protected ItemStack getVariantStack(BlockCoffin.IVariant variant) {
        return ItemBlockWoodenCoffin.getVariantStack(variant);
    }

    @Override
    protected BlockCoffin.IVariant getDefaultVariant() {
        return Variant.getDefault();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a(VARIANT, (Comparable)((Object)WorldTools.getTile(world, pos, TileWoodenCoffin.class).map(TileWoodenCoffin::getVariant).orElse(Variant.OAK)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final EnumMap<Variant, ModelResourceLocation> variantModels = new EnumMap<Variant, ModelResourceLocation>(Variant.class);
        for (Variant variant : Variant.values()) {
            ModelResourceLocation modelLocation = new ModelResourceLocation("ancientwarfare:structure/wooden_coffin", variant.func_176610_l());
            variantModels.put(variant, modelLocation);
            ModelRegistryHelper.register((ModelResourceLocation)modelLocation, (IBakedModel)new ParticleOnlyModel(variant.getBlockTexture()));
        }
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return (ModelResourceLocation)variantModels.get(state.func_177229_b((IProperty)VARIANT));
            }
        });
        ModelRegistryHelper.registerItemRenderer((Item)Item.func_150898_a((Block)this), (IItemRenderer)new WoodenCoffinRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWoodenCoffin.class, (TileEntitySpecialRenderer)new WoodenCoffinRenderer());
    }

    public static enum Variant implements BlockCoffin.IVariant
    {
        OAK("oak", "planks_oak"),
        BIRCH("birch", "planks_birch"),
        SPRUCE("spruce", "planks_spruce"),
        JUNGLE("jungle", "planks_jungle"),
        DARK_OAK("dark_oak", "planks_big_oak"),
        ACACIA("acacia", "planks_acacia");

        private String name;
        private String blockTexture;
        private static final ImmutableMap<String, Variant> NAME_TO_VARIANT;

        private Variant(String name, String blockTexture) {
            this.name = name;
            this.blockTexture = blockTexture;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Variant getDefault() {
            return OAK;
        }

        public static Variant fromName(String name) {
            return (Variant)NAME_TO_VARIANT.getOrDefault((Object)name, (Object)OAK);
        }

        public String getBlockTexture() {
            return this.blockTexture;
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Variant variant : Variant.values()) {
                builder.put((Object)variant.name, (Object)variant);
            }
            NAME_TO_VARIANT = builder.build();
        }
    }
}

