/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block.altar;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.altar.BlockAltarTop;
import net.shadowmage.ancientwarfare.structure.render.ParticleColoredFlame;
import net.shadowmage.ancientwarfare.structure.tile.TileAltarCandle;
import net.shadowmage.ancientwarfare.structure.tile.TileColored;

public class BlockAltarCandle
extends BlockAltarTop {
    private static final AxisAlignedBB CANDLE_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.625, 0.625);

    public BlockAltarCandle() {
        super(Material.field_151573_f, "altar_candle");
        this.func_149675_a(true);
        this.func_149715_a(0.8f);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CANDLE_AABB;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAltarCandle();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return WorldTools.getTile((IBlockAccess)world, pos, TileColored.class).map(TileColored::getPickBlock).orElse(ItemStack.field_190927_a);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        WorldTools.getTile(world, pos, TileAltarCandle.class).ifPresent(t -> drops.add((Object)t.getPickBlock()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        Optional<TileAltarCandle> te = WorldTools.getTile((IBlockAccess)world, pos, TileAltarCandle.class);
        if (!te.isPresent()) {
            return;
        }
        if (te.get().isFlameSmoke()) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        } else if (te.get().getFlameColor() == -1) {
            world.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        } else {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleColoredFlame(world, d0, d1, d2, 0.0, 0.0, 0.0, te.get().getFlameColor()));
        }
    }
}

