/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.config.ModConfiguration;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;

public class AWStructureStatics
extends ModConfiguration {
    public static Set<String> lootTableExclusions;
    public static float chunkClusterValue;
    public static String templateExtension;
    public static String townTemplateExtension;
    public static boolean enableWorldGen;
    public static boolean enableTownGeneration;
    public static boolean enableStructureGeneration;
    public static boolean loadDefaultPack;
    public static float randomGenerationChance;
    public static int spawnProtectionRange;
    public static int townClosestDistance;
    public static float townGenerationChance;
    public static Set<String> excludedSpawnerEntities;
    private static HashSet<String> skippableWorldGenBlocks;
    private static HashSet<String> worldGenTargetBlocks;
    private static HashSet<String> scannerSkippedBlocks;
    public static boolean collectWorldGenStatistics;
    public static int gateVerticalWoodenMaxHealth;
    public static int gateVerticalIronMaxHealth;
    public static int gateSingleWoodMaxHealth;
    public static int gateSingleIronMaxHealth;
    public static int gateDoubleWoodMaxHealth;
    public static int gateDoubleIronMaxHealth;
    public static int drawbridgeMaxHealth;
    private static final String worldGenCategory = "a_world-gen_settings";
    private static final String villageGenCategory = "b_village-gen_settings";
    private static final String excludedEntitiesCategory = "c_excluded_spawner_entities";
    private static final String worldGenBlocks = "d_world_gen_skippable_blocks";
    private static final String targetBlocks = "e_world_gen_target_blocks";
    private static final String scanSkippedBlocks = "f_scanner_skipped_blocks";
    private static final String excludedLootTables = "g_excluded_loot_tables";

    public AWStructureStatics(String mod) {
        super(mod);
    }

    @Override
    public void initializeCategories() {
        this.config.addCustomCategoryComment(worldGenCategory, "Settings that effect all world-structure-generation.");
        this.config.addCustomCategoryComment(villageGenCategory, "Settings that effect the generation of vanilla villages.\nCurrently there are no village-generation options, and no structures will generate in villages.");
        this.config.addCustomCategoryComment(excludedEntitiesCategory, "Entities that will not show up in the Mob Spawner Placer entity selection list.\nAdd any mobs here that will crash if spawned via the vanilla mob-spawner (usually complex NBT-defined entities).");
        this.config.addCustomCategoryComment(worldGenBlocks, "Blocks that should be skipped/ignored during world gen -- should list all plant blocks/logs/foliage");
        this.config.addCustomCategoryComment(targetBlocks, "List of target blocks that structures and towns can spawn on in addition to materials that are automatically whitelisted.");
        this.config.addCustomCategoryComment(scanSkippedBlocks, "List of blocks that the structure scanner will completely ignore.\nWhenever these blocks are encountered the template will instead fill that block position with a hard-air rule.\nAdd any blocks to this list that may cause crashes when scanned or duplicated.\nVanilla blocks should not need to be added, but some mod-blocks may.\nBlock names must be specified by fully-qualified name (e.g. \"minecraft:chests/stronghold_corridor\")");
        this.config.addCustomCategoryComment(excludedLootTables, "List of loot tables that should be excluded from loot chest placer GUI.\nLoot table names must be specified by fully-qualified name (e.g. \"minecraft:stone\")");
    }

    @Override
    protected void initializeValues() {
        templateExtension = this.config.get(worldGenCategory, "template_extension", "aws", "Default=" + templateExtension + "\nThe template extension used when looking for and exporting templates.\nOnly files matching this extension will be examined.").getString();
        enableStructureGeneration = this.config.get(worldGenCategory, "enable_structure_generation", enableStructureGeneration, "Default=" + enableStructureGeneration + "\nEnable or disable structure (not town) generation.").getBoolean(enableStructureGeneration);
        enableTownGeneration = this.config.get(worldGenCategory, "enable_town_generation", enableTownGeneration, "Default=" + enableTownGeneration + "\nEnable or disable custom town generation e.g. walls and additional buildings.").getBoolean(enableTownGeneration);
        loadDefaultPack = this.config.get(worldGenCategory, "load_default_structure_pack", loadDefaultPack, "If true the default structure pack will be loaded and enabled for world-gen.").getBoolean(loadDefaultPack);
        randomGenerationChance = (float)this.config.get(worldGenCategory, "random_generation_chance", (double)randomGenerationChance, "Default=" + randomGenerationChance + "\nAccepts values between 0 and 1.\nDetermines the chance that a structure will attempt to be generated in any given chunk.\nNumber is specified as a percentage -- e.g. 0.75 == 75% chance to attempt generation.\nHigher values will result in more attempts to generate structures.  Actual number\ngenerated will depend upon your specific templates and their validation settings.\nValues of 0 or lower will result in no structures generating.  Values higher than 1\nwill result in a generation attempt in every chunk.").getDouble((double)randomGenerationChance);
        chunkClusterValue = (float)this.config.get(worldGenCategory, "chunk_cluster_value", (double)chunkClusterValue, "Default=" + chunkClusterValue + "\nAccepts values greater than 0.\nDetermines how much total cluster value territory gets per chunk. When structures spawn the total territory cluster value is used to determine how many points remain and thus it influences how big and how many structures can spawn").getDouble((double)chunkClusterValue);
        spawnProtectionRange = this.config.get(worldGenCategory, "spawn_protection_radius", spawnProtectionRange, "Default=" + spawnProtectionRange + "\nDetermines the area around the central spawn coordinate that will be excluded from random structure generation.\nLarger values will see a larger area around spawn that is devoid of structures.").getInt(spawnProtectionRange);
        enableWorldGen = this.config.get("02_server_settings", "enable_world_generation", enableWorldGen, "Default=" + enableWorldGen + "\nEnable or disable world generation entirely. If disabled, all other options will have no effect.").getBoolean(enableWorldGen);
        townClosestDistance = this.config.get(worldGenCategory, "town_min_distance", townClosestDistance, "Default=" + townClosestDistance + "\nMinimum distance between towns.  This should be set to a value quite a bit larger than the largest townthat you have configured for generation.  E.G.  Max town size=16, this value should be >= 40 * 16.").getInt(townClosestDistance);
        townGenerationChance = (float)this.config.get(worldGenCategory, "town_generation_chance", (double)townGenerationChance, "Default=" + townGenerationChance + "\nAccepts values between 0 and 1.0.  Decimal percent chance to -attempt- town generation for any given chunk.  Higher settings may result inmore towns being generated, but may come with a performance hit during new chunk generation.  Lower values WILL result in fewer towns, and-may- improve performance during chunk generation.").getDouble((double)townGenerationChance);
        gateVerticalWoodenMaxHealth = this.config.get(worldGenCategory, "gate_vertical_wooden_max_health", gateVerticalWoodenMaxHealth, "Default=" + gateVerticalWoodenMaxHealth + "\nDetermines the maximum health of the Vertical Wooden Gate.").getInt(gateVerticalWoodenMaxHealth);
        gateVerticalIronMaxHealth = this.config.get(worldGenCategory, "gate_vertical_iron_max_health", gateVerticalIronMaxHealth, "Default=" + gateVerticalIronMaxHealth + "\nDetermines the maximum health of the Vertical Iron Gate.").getInt(gateVerticalIronMaxHealth);
        gateSingleWoodMaxHealth = this.config.get(worldGenCategory, "gate_single_wood_max_health", gateSingleWoodMaxHealth, "Default=" + gateSingleWoodMaxHealth + "\nDetermines the maximum health of the Single Wood Gate.").getInt(gateSingleWoodMaxHealth);
        gateSingleIronMaxHealth = this.config.get(worldGenCategory, "gate_single_iron_max_health", gateSingleIronMaxHealth, "Default=" + gateSingleIronMaxHealth + "\nDetermines the maximum health of the Single Iron Gate.").getInt(gateSingleIronMaxHealth);
        gateDoubleWoodMaxHealth = this.config.get(worldGenCategory, "gate_double_wood_max_health", gateDoubleWoodMaxHealth, "Default=" + gateDoubleWoodMaxHealth + "\nDetermines the maximum health of the Double Wood Gate.").getInt(gateDoubleWoodMaxHealth);
        gateDoubleIronMaxHealth = this.config.get(worldGenCategory, "gate_double_iron_max_health", gateDoubleIronMaxHealth, "Default=" + gateDoubleIronMaxHealth + "\nDetermines the maximum health of the Double Iron Gate.").getInt(gateDoubleIronMaxHealth);
        drawbridgeMaxHealth = this.config.get(worldGenCategory, "drawbridge_max_health", drawbridgeMaxHealth, "Default=" + drawbridgeMaxHealth + "\nDetermines the maximum health of the Drawbridge.").getInt(drawbridgeMaxHealth);
        collectWorldGenStatistics = this.config.get(worldGenCategory, "collect_worldgen_statistics", collectWorldGenStatistics, "If true worldgen statistics are collected. These are useful to debug how often structures spawn, why they don't spawn etc...").getBoolean(collectWorldGenStatistics);
        this.initializeDefaultSkippableBlocks();
        this.initializeDefaultSkippedEntities();
        this.initializeDefaultTargetBlocks();
        this.initializeScannerSkippedBlocks();
        lootTableExclusions = new HashSet<String>(Arrays.asList(this.config.get(excludedLootTables, "excluded_loot_tables", new String[]{"advanced-fishing:gameplay/fishing", "advanced-fishing:gameplay/fishing/cave/25", "advanced-fishing:gameplay/fishing/cave/40", "advanced-fishing:gameplay/fishing/cave/50", "advanced-fishing:gameplay/fishing/dead/tier_1", "advanced-fishing:gameplay/fishing/dead/tier_2", "advanced-fishing:gameplay/fishing/dead/tier_3", "advanced-fishing:gameplay/fishing/dead/treasure", "advanced-fishing:gameplay/fishing/end/tier_1", "advanced-fishing:gameplay/fishing/end/tier_2", "advanced-fishing:gameplay/fishing/end/tier_3", "advanced-fishing:gameplay/fishing/jungle/tier_2", "advanced-fishing:gameplay/fishing/jungle/tier_3", "advanced-fishing:gameplay/fishing/jungle/tier_4", "advanced-fishing:gameplay/fishing/mushroom/tier_3", "advanced-fishing:gameplay/fishing/ocean/tier_1", "advanced-fishing:gameplay/fishing/ocean/tier_2", "advanced-fishing:gameplay/fishing/ocean/tier_3", "advanced-fishing:gameplay/fishing/ocean/tier_4", "advanced-fishing:gameplay/fishing/ocean_deep/tier_3", "advanced-fishing:gameplay/fishing/ocean_deep/tier_4", "advanced-fishing:gameplay/fishing/sandy/tier_2", "advanced-fishing:gameplay/fishing/sandy/tier_3", "advanced-fishing:gameplay/fishing/sandy/tier_4", "advanced-fishing:gameplay/fishing/snowy/tier_2", "advanced-fishing:gameplay/fishing/snowy/tier_3", "advanced-fishing:gameplay/fishing/snowy/tier_4", "advanced-fishing:gameplay/fishing/swamp/tier_2", "advanced-fishing:gameplay/fishing/swamp/tier_3", "advanced-fishing:gameplay/fishing/swamp/tier_4", "advanced-fishing:gameplay/fishing/tier_1", "advanced-fishing:gameplay/fishing/tier_2", "advanced-fishing:gameplay/fishing/tier_3", "advanced-fishing:gameplay/fishing/tier_4", "advanced-fishing:gameplay/fishing_beach", "advanced-fishing:gameplay/fishing_dead", "advanced-fishing:gameplay/fishing_end", "advanced-fishing:gameplay/fishing_jungle", "advanced-fishing:gameplay/fishing_lava", "advanced-fishing:gameplay/fishing_lava/tier_1", "advanced-fishing:gameplay/fishing_lava/tier_2", "advanced-fishing:gameplay/fishing_lava/treasure", "advanced-fishing:gameplay/fishing_lava_nether", "advanced-fishing:gameplay/fishing_lava_nether/tier_1", "advanced-fishing:gameplay/fishing_lava_nether/tier_2", "advanced-fishing:gameplay/fishing_lava_nether/tier_3", "advanced-fishing:gameplay/fishing_lava_nether/tier_4", "advanced-fishing:gameplay/fishing_lava_nether/treasure", "advanced-fishing:gameplay/fishing_mushroom", "advanced-fishing:gameplay/fishing_ocean", "advanced-fishing:gameplay/fishing_ocean_deep", "advanced-fishing:gameplay/fishing_sandy", "advanced-fishing:gameplay/fishing_snowy", "advanced-fishing:gameplay/fishing_swamp", "gravestone-extended:entities/barghest", "gravestone-extended:entities/damned_warrior", "gravestone-extended:entities/drowned", "gravestone-extended:entities/husk_skull_crawler", "gravestone-extended:entities/mummy", "gravestone-extended:entities/phantom_diver", "gravestone-extended:entities/pigman_skull_crawler", "gravestone-extended:entities/possessed_armor", "gravestone-extended:entities/raven", "gravestone-extended:entities/skeleton_cat", "gravestone-extended:entities/skeleton_dog", "gravestone-extended:entities/skull_crawler", "gravestone-extended:entities/stray_skull_crawler", "gravestone-extended:entities/swamp_thing", "gravestone-extended:entities/toxic_sludge", "gravestone-extended:entities/vampire_bat", "gravestone-extended:entities/wither_skull_crawler", "gravestone-extended:entities/zombie_cat", "gravestone-extended:entities/zombie_dog", "gravestone-extended:entities/zombie_skull_crawler", "gravestone-extended:gameplay/fishing_toxic_water", "gravestone-extended:gameplay/fishing_toxic_water/treasure", "gravestone-extended:inject/bat", "gravestone-extended:inject/fishing_lava_nether_enchanted_skull", "ancientwarfare:entities/faction_npc", "betteranimalsplus:bear_black", "betteranimalsplus:bear_brown", "betteranimalsplus:bear_kermode", "betteranimalsplus:crab", "betteranimalsplus:deer", "betteranimalsplus:goat", "betteranimalsplus:hirschgeist", "betteranimalsplus:lammergeier", "betteranimalsplus:lamprey", "betteranimalsplus:nautilus", "betteranimalsplus:pheasant", "betteranimalsplus:reindeer", "betteranimalsplus:shark", "betteranimalsplus:songbird", "betteranimalsplus:wolf_black", "betteranimalsplus:wolf_snowy", "betteranimalsplus:wolf_timber", "charm:entities/spectre", "ebwizardry:entities/mob_additions", "eerieentities:entities/cursed_armor", "eerieentities:entities/nether_knight", "eerieentities:entities/pumpkin_slime", "eerieentities:entities/wisp", "exoticbirds:birds/bluejay", "exoticbirds:birds/booby", "exoticbirds:birds/cardinal", "exoticbirds:birds/cassowary", "exoticbirds:birds/crane", "exoticbirds:birds/duck", "exoticbirds:birds/flamingo", "exoticbirds:birds/gouldianfinch", "exoticbirds:birds/heron", "exoticbirds:birds/hummingbird", "exoticbirds:birds/kingfisher", "exoticbirds:birds/kiwi", "exoticbirds:birds/kookaburra", "exoticbirds:birds/lyrebird", "exoticbirds:birds/magpie", "exoticbirds:birds/ostrich", "exoticbirds:birds/owl", "exoticbirds:birds/parrot", "exoticbirds:birds/peacock", "exoticbirds:birds/peahen", "exoticbirds:birds/pelican", "exoticbirds:birds/penguin", "exoticbirds:birds/phoenix", "exoticbirds:birds/pigeon", "exoticbirds:birds/roadrunner", "exoticbirds:birds/robin", "exoticbirds:birds/seagull", "exoticbirds:birds/swan", "exoticbirds:birds/toucan", "exoticbirds:birds/vulture", "exoticbirds:birds/woodpecker", "exoticbirds:dungeon_phoenix", "explorercraft:entities/enderreeper", "explorercraft:entities/wizard", "explorercraft:inject/sheep", "familiarfauna:entities/butterfly", "familiarfauna:entities/deer", "familiarfauna:entities/dragonfly", "familiarfauna:entities/pixie", "familiarfauna:entities/snail", "familiarfauna:entities/turkey", "harvestersnight:entities/harvester", "minecolonies:entityarcherbarbariandrops", "minecolonies:entityarcherpiratedrops", "minecolonies:entitybarbariandrops", "minecolonies:entitychiefbarbariandrops", "minecolonies:entitychiefpiratedrops", "minecolonies:entitypiratedrops", "minecraft:empty", "minecraft:entities/bat", "minecraft:entities/blaze", "minecraft:entities/cave_spider", "minecraft:entities/chicken", "minecraft:entities/cow", "minecraft:entities/creeper", "minecraft:entities/donkey", "minecraft:entities/elder_guardian", "minecraft:entities/ender_dragon", "minecraft:entities/enderman", "minecraft:entities/endermite", "minecraft:entities/evocation_illager", "minecraft:entities/ghast", "minecraft:entities/giant", "minecraft:entities/guardian", "minecraft:entities/horse", "minecraft:entities/husk", "minecraft:entities/iron_golem", "minecraft:entities/llama", "minecraft:entities/magma_cube", "minecraft:entities/mule", "minecraft:entities/mushroom_cow", "minecraft:entities/ocelot", "minecraft:entities/parrot", "minecraft:entities/pig", "minecraft:entities/polar_bear", "minecraft:entities/rabbit", "minecraft:entities/sheep", "minecraft:entities/sheep/black", "minecraft:entities/sheep/blue", "minecraft:entities/sheep/brown", "minecraft:entities/sheep/cyan", "minecraft:entities/sheep/gray", "minecraft:entities/sheep/green", "minecraft:entities/sheep/light_blue", "minecraft:entities/sheep/lime", "minecraft:entities/sheep/magenta", "minecraft:entities/sheep/orange", "minecraft:entities/sheep/pink", "minecraft:entities/sheep/purple", "minecraft:entities/sheep/red", "minecraft:entities/sheep/silver", "minecraft:entities/sheep/white", "minecraft:entities/sheep/yellow", "minecraft:entities/shulker", "minecraft:entities/silverfish", "minecraft:entities/skeleton", "minecraft:entities/skeleton_horse", "minecraft:entities/slime", "minecraft:entities/snowman", "minecraft:entities/spider", "minecraft:entities/squid", "minecraft:entities/stray", "minecraft:entities/vex", "minecraft:entities/villager", "minecraft:entities/vindication_illager", "minecraft:entities/witch", "minecraft:entities/wither_skeleton", "minecraft:entities/wolf", "minecraft:entities/zombie", "minecraft:entities/zombie_horse", "minecraft:entities/zombie_pigman", "minecraft:entities/zombie_villager", "pirates:ghost_captain", "primitivemobs:chests/mimic_trap", "primitivemobs:chests/mimic_treasure", "primitivemobs:entities/blazing_juggernaut", "primitivemobs:entities/chameleon", "primitivemobs:entities/dodo", "primitivemobs:entities/festive_creeper", "primitivemobs:entities/flame_spewer", "primitivemobs:entities/goblin", "primitivemobs:entities/harpy", "primitivemobs:entities/lily_lurker", "primitivemobs:entities/mimic", "primitivemobs:entities/mother_spider", "primitivemobs:entities/rocket_creeper", "primitivemobs:entities/special/filch_lizard_spawn", "primitivemobs:entities/special/filch_lizard_steal", "primitivemobs:entities/special/haunted_tool", "primitivemobs:entities/special/treasure_slime", "primitivemobs:entities/support_creeper", "primitivemobs:entities/void_eye", "thesummoner:entities/summoner", "thesummoner:entities/summoner_boss", "vampirism:entities/advanced_hunter", "vampirism:entities/advanced_vampire", "vampirism:entities/baron", "vampirism:entities/basic_hunter", "vampirism:entities/basic_vampire", "vampirism:entities/ghost", "vampirism:village_trainer", "waddles:empty", "waddles:entities/penguin", "xreliquary:inject/entities/bat", "xreliquary:inject/entities/blaze", "xreliquary:inject/entities/cave_spider", "xreliquary:inject/entities/creeper", "xreliquary:inject/entities/enderman", "xreliquary:inject/entities/ghast", "xreliquary:inject/entities/guardian", "xreliquary:inject/entities/husk", "xreliquary:inject/entities/magma_cube", "xreliquary:inject/entities/skeleton", "xreliquary:inject/entities/slime", "xreliquary:inject/entities/snowman", "xreliquary:inject/entities/spider", "xreliquary:inject/entities/squid", "xreliquary:inject/entities/stray", "xreliquary:inject/entities/witch", "xreliquary:inject/entities/wither_skeleton", "xreliquary:inject/entities/zombie", "xreliquary:inject/entities/zombie_pigman", "xreliquary:inject/entities/zombie_villager", "silentgems:ender_slime", "twilightforest:entities/armored_giant", "twilightforest:entities/bird", "twilightforest:entities/block_goblin", "twilightforest:entities/bunny", "twilightforest:entities/death_tome", "twilightforest:entities/death_tome_hurt", "twilightforest:entities/deer", "twilightforest:entities/fire_beetle", "twilightforest:entities/giant_miner", "twilightforest:entities/goblin_knight", "twilightforest:entities/helmet_crab", "twilightforest:entities/hydra", "twilightforest:entities/ice_crystal", "twilightforest:entities/ice_exploder", "twilightforest:entities/ice_shooter", "twilightforest:entities/kobold", "twilightforest:entities/lich", "twilightforest:entities/maze_slime", "twilightforest:entities/mini_ghast", "twilightforest:entities/minoshroom", "twilightforest:entities/minotaur", "twilightforest:entities/naga", "twilightforest:entities/raven", "twilightforest:entities/redcap", "twilightforest:entities/skeleton_druid", "twilightforest:entities/slime_beetle", "twilightforest:entities/snow_guardian", "twilightforest:entities/snow_queen", "twilightforest:entities/tower_golem", "twilightforest:entities/tower_termite", "twilightforest:entities/troll", "twilightforest:entities/winter_wolf", "twilightforest:entities/wraith", "twilightforest:entities/yeti", "twilightforest:entities/yeti_alpha", "twilightforest:structures/aurora_boss/aurora_boss", "twilightforest:structures/darktower_boss/darktower_boss", "twilightforest:structures/stronghold_boss/stronghold_boss", "zoocraftdiscoveries:anteater", "zoocraftdiscoveries:camel", "zoocraftdiscoveries:chinchilla", "zoocraftdiscoveries:frog", "zoocraftdiscoveries:gemsbok", "zoocraftdiscoveries:giraffe", "zoocraftdiscoveries:rhino"}).getStringList()));
    }

    private void initializeScannerSkippedBlocks() {
        String[] defaultSkippableBlocks = new String[]{"AncientWarfareStructure:gate_proxy"};
        defaultSkippableBlocks = this.config.getStringList("scanner_skipped_blocks", scanSkippedBlocks, defaultSkippableBlocks, "Blocks TO be skipped by structure scanner");
        Collections.addAll(scannerSkippedBlocks, defaultSkippableBlocks);
    }

    private void initializeDefaultSkippableBlocks() {
        String[] defaultSkippableBlocks = new String[]{"ebwizardry:crystal_ore", "ebwizardry:crystal_flower", "betteranimalsplus:trillium", "coralreef:coral", "dungeontactics:silver_ore", "dungeontactics:nethergold_ore", "dungeontactics:stonequartz_ore", "dungeontactics:enddiamond_ore", "dungeontactics:endlapis_ore", "dungeontactics:flower_bramble", "dungeontactics:flower_bark", "dungeontactics:flower_cinder", "dungeontactics:flower_tangle", "dungeontactics:flower_ailment", "dungeontactics:flower_fade", "dungeontactics:flower_feather", "dungeontactics:bush_cherrybomb", "dungeontactics:bush_incindiberry", "dungeontactics:bush_glowcurrent", "environs:cypress_leaves", "environs:pine_leaves", "environs:cypress_log", "environs:pine_log", "explorercraft:jade_ore", "explorercraft:ruby_ore", "explorercraft:amethyst_ore", "explorercraft:marble", "explorercraft:slate", "explorercraft:ash_leaves", "explorercraft:bamboo_leaves", "explorercraft:cherry_leaves", "explorercraft:maple_leaves", "explorercraft:ash_log", "explorercraft:bamboo_log", "explorercraft:cherry_log", "explorercraft:maple_log", "explorercraft:leek_wild", "explorercraft:daffodil", "minecraftfuture:flowerblue", "minecraftfuture:flowerwhite", "minecraftfuture:flowerblack", "minecraftfuture:berrybush", "minecraftfuture:bamboo", "gemsplusplus:oreruby", "gemsplusplus:oresapphire", "gemsplusplus:oreamethyst", "gemsplusplus:oretopaz", "gemsplusplus:orephoenixite", "gemsplusplus:orejade", "gemsplusplus:orecitrine", "gemsplusplus:oregarnet", "gemsplusplus:orespinel", "gemsplusplus:oreonyx", "gemsplusplus:oreagate", "gemsplusplus:oremalachite", "gemsplusplus:oretourmaline", "gemsplusplus:orechrysocolla", "gemsplusplus:orejasper", "gemsplusplus:oresugilite", "gemsplusplus:netheroreruby", "gemsplusplus:netheroresapphire", "gemsplusplus:netheroreamethyst", "gemsplusplus:netheroretopaz", "gemsplusplus:netherorephoenixite", "gemsplusplus:netherorejade", "gemsplusplus:netherorecitrine", "gemsplusplus:netheroregarnet", "gemsplusplus:netherorespinel", "gemsplusplus:netheroreonyx", "gemsplusplus:netheroreagate", "gemsplusplus:netheroremalachite", "gemsplusplus:netheroretourmaline", "gemsplusplus:netherorechrysocolla", "gemsplusplus:netherorejasper", "gemsplusplus:netheroresugilite", "iceandfire:chared_dirt", "iceandfire:chared_grass", "iceandfire:chared_stone", "iceandfire:chared_cobblestone", "iceandfire:chared_gravel", "iceandfire:chared_grass_path", "iceandfire:silver_ore", "iceandfire:sapphire_ore", "minecraft:snow_layer", "nt:conifer_leaves_yellow", "nt:conifer_leaves_orange", "nt:cherry_leaves_purple", "nt:cherry_leaves_white", "nt:cherry_leaves_pink", "nt:maple_leaves", "nt:jacaranda_leaves", "nt:spruce_leaves_red", "nt:spruce_leaves_blue", "nt:oak_leaves_red", "nt:brownautumn_leaves", "nt:orangeautumn_leaves", "nt:redautumn_leaves", "nt:yellowautumn_leaves", "nt:paulownia_leaves", "nt:orchard_leaves", "nt:whitemyrtle_leaves", "nt:shrub_sapling_acacia", "nt:shrub_sapling_birch", "nt:shrub_sapling_bluespruce", "nt:shrub_sapling_cherrypink", "nt:shrub_sapling_cherrypurple", "nt:shrub_sapling_cherrywhite", "nt:shrub_sapling_coniferorange", "nt:shrub_sapling_coniferyellow", "nt:shrub_sapling_darkoak", "nt:shrub_sapling_jacaranda", "nt:shrub_sapling_jungle", "nt:shrub_sapling_maple", "nt:shrub_sapling_oak", "nt:shrub_sapling_redoak", "nt:shrub_sapling_redspruce", "nt:shrub_sapling_spruce", "redwoods:redwood_log", "redwoods:fir_log", "redwoods:redwood_log_quarter", "redwoods:fir_log_quarter", "redwoods:redwood_leaves", "redwoods:fir_leaves", "traverse:red_autumnal_leaves", "traverse:red_autumnal_sapling", "traverse:brown_autumnal_leaves", "traverse:brown_autumnal_sapling", "traverse:orange_autumnal_leaves", "traverse:orange_autumnal_sapling", "traverse:yellow_autumnal_leaves", "traverse:yellow_autumnal_sapling", "traverse:fir_leaves", "traverse:fir_log", "simplytea:tea_trunk", "rustic:beehive", "rustic:log", "rustic:leaves", "rustic:wildberry_bush", "rustic:blood_orchid", "rustic:chamomile", "rustic:cloudsbluff", "rustic:cohosh", "rustic:core_root", "rustic:deathstalk_mushroom", "rustic:ginseng", "rustic:horsetail", "rustic:marsh_mallow", "rustic:mooncap_mushroom", "rustic:wind_thistle", "byg:structurecheckblock"};
        defaultSkippableBlocks = this.config.get(worldGenBlocks, "skippable_blocks", defaultSkippableBlocks).getStringList();
        Collections.addAll(skippableWorldGenBlocks, defaultSkippableBlocks);
    }

    public static void logSkippableBlocksCoveredByMaterial() {
        skippableWorldGenBlocks.stream().filter(b -> AWStructureStatics.getBlock(b).isPresent() && AWStructureStatics.isSkippableMaterial(AWStructureStatics.getBlock(b).get().func_176223_P().func_185904_a())).forEach(b -> AncientWarfareStructure.LOG.info("Block {} defined as skippable is redundant as its material is already skipped by default", b));
    }

    private static Optional<Block> getBlock(String registryName) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName));
        return block == Blocks.field_150350_a ? Optional.empty() : Optional.ofNullable(block);
    }

    private void initializeDefaultSkippedEntities() {
        String[] defaultExcludedEntities = new String[]{"ancientwarfarestructure:aw_gate", "ancientwarfarevehicle:missile", "ancientwarfarevehicle:vehicle", "arcane_essentials:cyclone bolt", "arcane_essentials:cylone shield", "arcane_essentials:flame pillar", "arcane_essentials:flame pillar spawner", "arcane_essentials:lightning vortex", "arcane_essentials:magic bolt", "arcane_essentials:magic spawner", "arcane_essentials:solar beam", "arcane_essentials:thunder burst", "arcane_essentials:whirlpool", "astikoor:cargocart", "astikoor:carriage", "astikoor:chariot", "astikoor:plowcart", "astikorcarts:cargocart", "astikorcarts:mobcart", "astikorcarts:plowcart", "betteranimalsplus:badgerdirt", "betteranimalsplus:tarantulahair", "bibliocraft:biblioseat", "biomesoplenty:bop_boat", "biomesoplenty:mudball", "bottledmilk:lingeringmilk", "bottledmilk:milkarrow", "bottledmilk:splashmilk", "bullseye:arrow", "bullseye:dye_arrow", "charm:charged_emerald", "charm:endermite_powder", "comforts:_entity_rest", "comforts:_entity_rest", "customnpcs:customnpc", "customnpcs:customnpc64x32", "customnpcs:customnpcchairmount", "customnpcs:customnpcprojectile", "customnpcs:npccrystal", "customnpcs:npcdragon", "customnpcs:npcdwarffemale", "customnpcs:npcdwarfmale", "customnpcs:npcelffemale", "customnpcs:npcelfmale", "customnpcs:npcenderchibi", "customnpcs:npcenderman", "customnpcs:npcfurryfemale", "customnpcs:npcfurrymale", "customnpcs:npcgolem", "customnpcs:npchumanfemale", "customnpcs:npchumanmale", "customnpcs:npcnagafemale", "customnpcs:npcnagamale", "customnpcs:npcorcfemale", "customnpcs:npcorcfmale", "customnpcs:npcpony", "customnpcs:npcskeleton", "customnpcs:npcslime", "customnpcs:npcvillager", "customnpcs:npczombiefemale", "customnpcs:npczombiemale", "dungeonmobs:dmdarkball", "dungeonmobs:dmeyeray", "dungeonmobs:dmlightball", "dungeonmobs:dmmagicmissile", "dungeonmobs:dmpetrified", "dungeonmobs:dmrakshasaimage", "dungeonmobs:dmsonicboom", "dungeontactics:beetrootseed_entity", "dungeontactics:bullet_entity", "dungeontactics:cherrybomb_entity", "dungeontactics:chorusfruit_entity", "dungeontactics:cryobomb_entity", "dungeontactics:cushion_entity", "dungeontactics:flint_entity", "dungeontactics:fragbomb_entity", "dungeontactics:glowcurrent_entity", "dungeontactics:goldnugget_entity", "dungeontactics:incindiberry_entity", "dungeontactics:melonseed_entity", "dungeontactics:netherwart_entity", "dungeontactics:portingbomb_entity", "dungeontactics:powderkeg_entity", "dungeontactics:pumpkinseed_entity", "dungeontactics:pyrobomb_entity", "dungeontactics:throwingknife_entity", "dungeontactics:wheatseed_entity", "ebwizardry:arc", "ebwizardry:arrow_rain", "ebwizardry:black_hole", "ebwizardry:blaze_minion", "ebwizardry:blizzard", "ebwizardry:bubble", "ebwizardry:darkness_orb", "ebwizardry:dart", "ebwizardry:decay", "ebwizardry:decoy", "ebwizardry:earthquake", "ebwizardry:firebolt", "ebwizardry:firebomb", "ebwizardry:force_arrow", "ebwizardry:force_orb", "ebwizardry:forcefield", "ebwizardry:hailstorm", "ebwizardry:healing_aura", "ebwizardry:ice_charge", "ebwizardry:ice_giant", "ebwizardry:ice_lance", "ebwizardry:ice_shard", "ebwizardry:ice_spike", "ebwizardry:lightning_arrow", "ebwizardry:lightning_disc", "ebwizardry:lightning_hammer", "ebwizardry:lightning_pulse", "ebwizardry:magic_missile", "ebwizardry:magic_slime", "ebwizardry:meteor", "ebwizardry:phoenix", "ebwizardry:poison_bomb", "ebwizardry:ring_of_fire", "ebwizardry:shield", "ebwizardry:silverfish_minion", "ebwizardry:skeleton_minion", "ebwizardry:smoke_bomb", "ebwizardry:spark", "ebwizardry:spark_bomb", "ebwizardry:spider_minion", "ebwizardry:spirit_horse", "ebwizardry:spirit_wolf", "ebwizardry:storm_elemental", "ebwizardry:thunderbolt", "ebwizardry:tornado", "ebwizardry:wither_skeleton_minion", "ebwizardry:zombie_minion", "eerieentities:cursed_armor", "eerieentities:nether_knight", "eerieentities:pumpkin_slime", "extra_spells:armor_piercing_missile", "extra_spells:chargable_strike_missile", "gravestone-extended:spawner_helper", "grimoireofgaia:bomb", "grimoireofgaia:bubble", "grimoireofgaia:campfire", "grimoireofgaia:magic", "grimoireofgaia:poison", "grimoireofgaia:small_fireball", "grimoireofgaia:vase", "grimoireofgaia:vase_nether", "grimoireofgaia:web", "iceandfire:amphitherearrow", "iceandfire:deathwormegg", "iceandfire:dragonarrow", "iceandfire:dragonegg", "iceandfire:dragonfirecharge", "iceandfire:dragonicecharge", "iceandfire:dragonskull", "iceandfire:hippogryphegg", "iceandfire:if_cockatriceegg", "iceandfire:if_mob_skull", "iceandfire:myrmex_egg", "iceandfire:pixiecharge", "iceandfire:seaserpentarrow", "iceandfire:seaserpentbubble", "iceandfire:stonestatue", "iceandfire:stymphalianarrow", "iceandfire:stymphalianfeather", "iceandfire:tide_trident", "minecolonies:citizen", "minecolonies:fishhook", "minecraft:area_effect_cloud", "minecraft:armor_stand", "minecraft:arrow", "minecraft:boat", "minecraft:chest_minecart", "minecraft:commandblock_minecart", "minecraft:dragon_fireball", "minecraft:egg", "minecraft:ender_crystal", "minecraft:ender_dragon", "minecraft:ender_pearl", "minecraft:evocation_fangs", "minecraft:eye_of_ender_signal", "minecraft:falling_block", "minecraft:fireball", "minecraft:fireworks_rocket", "minecraft:furnace_minecart", "minecraft:hopper_minecart", "minecraft:item", "minecraft:item_frame", "minecraft:leash_knot", "minecraft:llama_spit", "minecraft:minecart", "minecraft:painting", "minecraft:parrot", "minecraft:potion", "minecraft:shulker_bullet", "minecraft:slime", "minecraft:small_fireball", "minecraft:snowball", "minecraft:spawner_minecart", "minecraft:spectral_arrow", "minecraft:tnt", "minecraft:tnt_minecart", "minecraft:wither", "minecraft:wither_skull", "minecraft:xp_bottle", "minecraft:xp_orb", "minecraftfuture:trident", "mowziesmobs:axe_attack", "mowziesmobs:barakoan_player", "mowziesmobs:block_swapper", "mowziesmobs:boulder", "mowziesmobs:dart", "mowziesmobs:frozen_controller", "mowziesmobs:ice_ball", "mowziesmobs:icebreath", "mowziesmobs:poison_ball", "mowziesmobs:ring", "mowziesmobs:solar_beam", "mowziesmobs:sunstrike", "multimob:dummy", "pirates:bottle", "pirates:bucket_water", "pirates:bullet", "pirates:cannon_ball", "pirates:dingy", "pirates:grapple_hook", "pirates:pulled_block", "primitivemobs:flame_spit", "primitivemobs:primitive_egg", "primitivemobs:primitive_tnt_primed", "primitivemobs:spider_egg", "primitivemobs:thrown_block", "roots:auspicious_point", "roots:barrow", "roots:blink_projectile", "roots:boost", "roots:fairy_circle", "roots:fire_jet", "roots:flare", "roots:petal_shell", "roots:ritual_fire_storm", "roots:ritual_life", "roots:ritual_light", "roots:ritual_regrowth", "roots:ritual_storm", "roots:ritual_warden", "roots:ritual_windwall", "roots:sprout", "roots:thorn_trap", "roots:time_stop", "rustic:chair", "rustic:tomato", "scarecrows:scarecrow", "silentgems:chaosprojectile", "silentgems:chaosprojectilehoming", "silentgems:chaosprojectilescatter", "silentgems:chaosprojectilesweep", "silentgems:enderslime", "silentgems:gemarrow", "silentgems:throwntomahawk", "spartanweaponry:arrow_diamond", "spartanweaponry:arrow_explosive", "spartanweaponry:arrow_iron", "spartanweaponry:arrow_wood", "spartanweaponry:bolt", "spartanweaponry:bolt_diamond", "spartanweaponry:bolt_specral", "spartanweaponry:boomerang_thrown", "spartanweaponry:dagger_thrown", "spartanweaponry:dynamite", "spartanweaponry:javelin_thrown", "spartanweaponry:throwing_axe", "spartanweaponry:throwing_knife", "thejungle:thrownweb", "totemic:baykok", "totemic:invis_arrow", "tumbleweed:tumbleweed", "twilightforest:adherent", "twilightforest:chain_block", "twilightforest:charm_effect", "twilightforest:cube_of_annihilation", "twilightforest:death_tome", "twilightforest:falling_ice", "twilightforest:hydra", "twilightforest:hydra_head", "twilightforest:hydra_mortar", "twilightforest:ice_arrow", "twilightforest:ice_crystal", "twilightforest:ice_snowball", "twilightforest:lich_bolt", "twilightforest:lich_bomb", "twilightforest:moonworm_shot", "twilightforest:nature_bolt", "twilightforest:seeker_arrow", "twilightforest:slider", "twilightforest:slime_blob", "twilightforest:stable_ice_core", "twilightforest:thrown_ice", "twilightforest:thrown_wep", "twilightforest:tome_bolt", "twilightforest:unstable_ice_core", "twilightforest:wand_bolt", "vampirism:crossbow_arrow", "vampirism:dark_blood_projectile", "vampirism:dummy_creature", "vampirism:hunter_trainer_dummy", "vampirism:particle_cloud", "vampirism:soul_orb", "vampirism:throwable_item", "variedcommodities:vcchairmount", "variedcommodities:vcmagicprojectile", "variedcommodities:vcprojectile", "varodd:coin", "varodd:skull_fireball", "xreliquary:blaze_shot", "xreliquary:buster_shot", "xreliquary:concussive_shot", "xreliquary:ender_shot", "xreliquary:ender_staff_projectile", "xreliquary:exorcism_shot", "xreliquary:hand_grenade", "xreliquary:holy_water", "xreliquary:kraken_slime", "xreliquary:lyssa_hook", "xreliquary:neutral_shot", "xreliquary:sand_shot", "xreliquary:seeker_shot", "xreliquary:special_snowball", "xreliquary:storm_shot", "xreliquary:thrown_aphrodite", "xreliquary:thrown_fertility", "xreliquary:thrown_potion", "xreliquary:tipped arrow"};
        defaultExcludedEntities = this.config.get(excludedEntitiesCategory, "excluded_entities", defaultExcludedEntities).getStringList();
        Collections.addAll(excludedSpawnerEntities, defaultExcludedEntities);
    }

    private void initializeDefaultTargetBlocks() {
        String[] defaultTargetBlocks = new String[]{"minecraft:snow", "minecraft:snow_layer", "minecraft:ice", "minecraft:water", "minecraft:clay", "minecraft:mycelium", "minecraft:stone", "minecraft:grass", "minecraft:dirt", "minecraft:sand", "minecraft:gravel", "minecraft:sand", "minecraft:sandstone", "BiomesOPlenty:mud", "BiomesOPlenty:driedDirt", "BiomesOPlenty:rocks", "BiomesOPlenty:ash", "BiomesOPlenty:ashStone", "BiomesOPlenty:hardSand", "BiomesOPlenty:hardDirt", "BiomesOPlenty:biomeBlock", "BiomesOPlenty:crystal", "BiomesOPlenty:gemOre", "BiomesOPlenty:cragRock"};
        defaultTargetBlocks = this.config.get("target_blocks", targetBlocks, defaultTargetBlocks, "List of blocks that are valid").getStringList();
        Collections.addAll(worldGenTargetBlocks, defaultTargetBlocks);
    }

    public static boolean isValidTargetBlock(IBlockState state) {
        return AWStructureStatics.isValidTargetMaterial(state.func_185904_a()) || worldGenTargetBlocks.contains(state.func_177230_c().getRegistryName().toString());
    }

    public static boolean isValidTargetMaterial(Material material) {
        return material == Material.field_151577_b || material == Material.field_151578_c || material == Material.field_151576_e || material == Material.field_151597_y || material == Material.field_151588_w || material == Material.field_151598_x || material == Material.field_151595_p || material == Material.field_151586_h;
    }

    public static boolean isSkippable(IBlockState state) {
        return AWStructureStatics.isSkippableMaterial(state.func_185904_a()) || skippableWorldGenBlocks.contains(state.func_177230_c().getRegistryName().toString());
    }

    public static boolean isSkippableMaterial(Material material) {
        return material == Material.field_151579_a || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151584_j || material == Material.field_151575_d || material == Material.field_151572_C || material == Material.field_151570_A;
    }

    public static boolean shouldSkipScan(Block block) {
        return scannerSkippedBlocks.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    public static boolean withinProtectionRange(double dist) {
        return dist < (double)(spawnProtectionRange * spawnProtectionRange);
    }

    static {
        chunkClusterValue = 1.0f;
        templateExtension = "aws";
        townTemplateExtension = "awt";
        enableWorldGen = true;
        enableTownGeneration = true;
        enableStructureGeneration = true;
        loadDefaultPack = true;
        randomGenerationChance = 0.075f;
        spawnProtectionRange = 400;
        townClosestDistance = 1440;
        townGenerationChance = 0.125f;
        excludedSpawnerEntities = new HashSet<String>();
        skippableWorldGenBlocks = new HashSet();
        worldGenTargetBlocks = new HashSet();
        scannerSkippedBlocks = new HashSet();
        collectWorldGenStatistics = true;
        gateVerticalWoodenMaxHealth = 80;
        gateVerticalIronMaxHealth = 80;
        gateSingleWoodMaxHealth = 80;
        gateSingleIronMaxHealth = 80;
        gateDoubleWoodMaxHealth = 80;
        gateDoubleIronMaxHealth = 80;
        drawbridgeMaxHealth = 80;
    }
}

