/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureSelectionBase;
import net.shadowmage.ancientwarfare.structure.tile.TileDraftingStation;

public class ContainerDraftingStation
extends ContainerStructureSelectionBase {
    private static final String IS_STARTED_TAG = "isStarted";
    private static final String IS_FINISHED_TAG = "isFinished";
    private static final String REMAINING_TIME_TAG = "remainingTime";
    private static final String TOTAL_TIME_TAG = "totalTime";
    private static final String STRUCT_NAME_TAG = "structName";
    private static final String RESOURCE_LIST_TAG = "resourceList";
    public boolean isStarted = false;
    private boolean isFinished = false;
    private int remainingTime;
    private int totalTime;
    public final NonNullList<ItemStack> neededResources = NonNullList.func_191196_a();
    private final TileDraftingStation tile;

    public ContainerDraftingStation(EntityPlayer player, int x, int y, int z) {
        super(player);
        Optional<TileDraftingStation> te = WorldTools.getTile((IBlockAccess)player.field_70170_p, new BlockPos(x, y, z), TileDraftingStation.class);
        if (!te.isPresent()) {
            throw new IllegalArgumentException("No drafting station");
        }
        this.tile = te.get();
        this.structureName = this.tile.getCurrentTemplateName();
        this.neededResources.addAll(InventoryTools.copyStacks(this.tile.getNeededResources()));
        this.isStarted = this.tile.isStarted();
        this.isFinished = this.tile.isFinished();
        this.remainingTime = this.tile.getRemainingTime();
        this.totalTime = this.tile.getTotalTime();
        int y2 = 94;
        for (int y1 = 0; y1 < 3; ++y1) {
            for (int x1 = 0; x1 < 9; ++x1) {
                int slotNum = y1 * 9 + x1;
                int xp = 8 + x1 * 18;
                int yp = y2 + y1 * 18;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.tile.inputSlots, slotNum, xp, yp));
            }
        }
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.tile.outputSlot, 0, 80, 60){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }
        });
        this.addPlayerSlots(156);
    }

    @Override
    public boolean func_75145_c(EntityPlayer var1) {
        return this.tile.func_145835_a(var1.field_70165_t, var1.field_70163_u, var1.field_70161_v) <= 64.0;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            int playerSlotStart = this.tile.inputSlots.getSlots();
            int playerSlotEnd = playerSlotStart + this.playerSlots;
            if (slotClickedIndex < playerSlotStart ? !this.func_75135_a(slotStack, playerSlotStart, playerSlotEnd, false) : slotClickedIndex < playerSlotEnd && !this.func_75135_a(slotStack, 0, playerSlotStart, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                theSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.func_190916_E() == slotStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            theSlot.func_190901_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(IS_STARTED_TAG, this.isStarted);
        tag.func_74757_a(IS_FINISHED_TAG, this.isFinished);
        tag.func_74768_a(REMAINING_TIME_TAG, this.remainingTime);
        tag.func_74768_a(TOTAL_TIME_TAG, this.totalTime);
        if (this.structureName != null) {
            tag.func_74778_a(STRUCT_NAME_TAG, this.structureName);
        }
        tag.func_74782_a(RESOURCE_LIST_TAG, (NBTBase)this.getResourceListTag(this.neededResources));
        this.sendDataToClient(tag);
    }

    private NBTTagList getResourceListTag(NonNullList<ItemStack> resources) {
        NBTTagList list = new NBTTagList();
        for (ItemStack item : resources) {
            NBTTagCompound tag = new NBTTagCompound();
            item.func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    private void readResourceList(NBTTagList list, NonNullList<ItemStack> resources) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack stack = new ItemStack(tag);
            if (stack.func_190926_b()) continue;
            resources.add((Object)stack);
        }
    }

    public void handleStopInput() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("stop", true);
        this.sendDataToServer(tag);
    }

    public void handleStartInput() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("start", true);
        this.sendDataToServer(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(STRUCT_NAME_TAG)) {
            if (this.player.field_70170_p.field_72995_K) {
                this.structureName = tag.func_74779_i(STRUCT_NAME_TAG);
            } else {
                this.tile.setTemplate(tag.func_74779_i(STRUCT_NAME_TAG));
            }
        } else if (tag.func_74764_b("clearName")) {
            this.structureName = null;
        }
        if (tag.func_74764_b(IS_STARTED_TAG)) {
            this.isStarted = tag.func_74767_n(IS_STARTED_TAG);
        }
        if (tag.func_74764_b(IS_FINISHED_TAG)) {
            this.isFinished = tag.func_74767_n(IS_FINISHED_TAG);
        }
        if (tag.func_74764_b(REMAINING_TIME_TAG)) {
            this.remainingTime = tag.func_74762_e(REMAINING_TIME_TAG);
        }
        if (tag.func_74764_b(TOTAL_TIME_TAG)) {
            this.totalTime = tag.func_74762_e(TOTAL_TIME_TAG);
        }
        if (tag.func_74764_b(RESOURCE_LIST_TAG)) {
            this.neededResources.clear();
            this.readResourceList(tag.func_150295_c(RESOURCE_LIST_TAG, 10), this.neededResources);
        }
        if (tag.func_74764_b("stop")) {
            this.tile.stopCurrentWork();
        } else if (tag.func_74764_b("start")) {
            this.tile.tryStart();
        }
        this.refreshGui();
    }

    public void func_75142_b() {
        super.func_75142_b();
        String tileName = this.tile.getCurrentTemplateName();
        NBTTagCompound tag = null;
        if (this.structureName == null && tileName != null || tileName == null && this.structureName != null) {
            tag = new NBTTagCompound();
            this.structureName = tileName;
            if (this.structureName == null) {
                tag.func_74757_a("clearName", true);
            } else {
                tag.func_74778_a(STRUCT_NAME_TAG, this.structureName);
            }
        } else if (this.structureName != null && !this.structureName.equals(tileName)) {
            this.structureName = tileName;
            tag = new NBTTagCompound();
            tag.func_74778_a(STRUCT_NAME_TAG, this.structureName);
        }
        if (this.tile.isFinished() != this.isFinished) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.isFinished = this.tile.isFinished();
            tag.func_74757_a(IS_FINISHED_TAG, this.isFinished);
        }
        if (this.tile.isStarted() != this.isStarted) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.isStarted = this.tile.isStarted();
            tag.func_74757_a(IS_STARTED_TAG, this.isStarted);
        }
        if (this.tile.getRemainingTime() != this.remainingTime) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.remainingTime = this.tile.getRemainingTime();
            tag.func_74768_a(REMAINING_TIME_TAG, this.remainingTime);
        }
        if (this.tile.getTotalTime() != this.totalTime) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.totalTime = this.tile.getTotalTime();
            tag.func_74768_a(TOTAL_TIME_TAG, this.totalTime);
        }
        if (!this.neededResources.equals(this.tile.getNeededResources())) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.neededResources.clear();
            this.neededResources.addAll(InventoryTools.copyStacks(this.tile.getNeededResources()));
            NBTTagList list = this.getResourceListTag(this.neededResources);
            tag.func_74782_a(RESOURCE_LIST_TAG, (NBTBase)list);
        }
        if (tag != null) {
            this.sendDataToClient(tag);
        }
    }
}

