/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gamedata;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.core.util.Zone;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.structure.gamedata.TownEntry;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.util.ConquerHelper;

public class TownMap
extends WorldSavedData {
    private static final Cache<Zone, Set<TownEntry>> CHUNK_TOWN_ENTRIES = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private Set<TownEntry> townEntries = new HashSet<TownEntry>();

    public TownMap(String name) {
        super(name);
    }

    public void setGenerated(TownEntry townEntry) {
        townEntry.setTownMap(this);
        this.townEntries.add(townEntry);
        this.func_76185_a();
    }

    public boolean shouldPreventSpawnAtPos(World world, BlockPos pos) {
        for (TownEntry entry : this.getTownsInChunk(pos)) {
            if (!entry.getBB().contains(pos) || !entry.shouldPreventNaturalHostileSpawns() || entry.getConquered()) continue;
            if (ConquerHelper.checkBBNotConquered(world, entry.getBB())) {
                return true;
            }
            entry.setConquered();
        }
        return false;
    }

    private Set<TownEntry> getTownsInChunk(BlockPos pos) {
        Set towns;
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos min = new BlockPos(chunkPos.field_77276_a * 16, 1, chunkPos.field_77275_b * 16);
        BlockPos max = new BlockPos(chunkPos.field_77276_a * 16 + 15, 255, chunkPos.field_77275_b * 16 + 15);
        Zone chunkZone = new Zone(min, max);
        try {
            towns = (Set)CHUNK_TOWN_ENTRIES.get((Object)chunkZone, () -> this.getTownsIn(chunkZone));
        }
        catch (ExecutionException e) {
            AncientWarfareNPC.LOG.error("Error getting structure entries in chunk for hostile entity check: ", (Throwable)e);
            return new HashSet<TownEntry>();
        }
        return towns;
    }

    private Set<TownEntry> getTownsIn(Zone zone) {
        HashSet<TownEntry> ret = new HashSet<TownEntry>();
        for (TownEntry townEntry : this.townEntries) {
            if (!townEntry.getBB().intersects(zone)) continue;
            ret.add(townEntry);
        }
        return ret;
    }

    public float getClosestTown(int bx, int bz, float defaultVal) {
        float distance = defaultVal;
        for (TownEntry townEntry : this.townEntries) {
            StructureBB bb = townEntry.getBB();
            float d = Trig.getDistance(bx, 0.0, bz, bb.getCenterX(), 0.0, bb.getCenterZ());
            if (!(d < distance)) continue;
            distance = d;
        }
        return distance;
    }

    public boolean intersectsWithTown(StructureBB bb) {
        for (TownEntry townEntry : this.townEntries) {
            if (!townEntry.getBB().intersects(bb)) continue;
            return true;
        }
        return false;
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.townEntries.clear();
        this.legacyDeserialization(tag);
        NBTTagList list = tag.func_150295_c("townEntries", 10);
        for (NBTBase nbt : list) {
            this.townEntries.add(TownEntry.deserializeNBT((NBTTagCompound)nbt).setTownMap(this));
        }
    }

    private void legacyDeserialization(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("boundingBoxes", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            StructureBB bb = new StructureBB(BlockPos.field_177992_a, BlockPos.field_177992_a);
            bb.deserializeNBT(list.func_150305_b(i));
            this.townEntries.add(new TownEntry(bb, false).setTownMap(this));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (TownEntry townEntry : this.townEntries) {
            list.func_74742_a((NBTBase)townEntry.serializeNBT());
        }
        tag.func_74782_a("townEntries", (NBTBase)list);
        return tag;
    }
}

