/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gates.types;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.entity.RotateBoundingBox;
import net.shadowmage.ancientwarfare.structure.gates.types.Gate;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;

public class GateRotatingBridge
extends Gate {
    public GateRotatingBridge(int id, String tex, SoundEvent moveSound, SoundEvent hurtSound, SoundEvent breakSound, int maxHealth) {
        super(id, tex, moveSound, hurtSound, breakSound, maxHealth);
        this.setName("gateDrawbridge");
        this.moveSpeed = 1.0f;
        this.canSoldierInteract = false;
        this.setVariant(Gate.Variant.WOOD_ROTATING);
    }

    @Override
    public void setCollisionBoundingBox(EntityGate gate) {
        if (gate.pos1 == null || gate.pos2 == null) {
            return;
        }
        BlockPos min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPos max = BlockTools.getMax(gate.pos1, gate.pos2);
        this.updateRenderBoundingBox(gate);
        if (gate.edgePosition == 0.0f) {
            gate.func_174826_a(new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)max.func_177958_n() + 1.0, (double)max.func_177956_o() + 1.0, (double)max.func_177952_p() + 1.0));
        } else if (gate.edgePosition < gate.edgeMax) {
            if (!(gate.func_174813_aQ() instanceof RotateBoundingBox)) {
                try {
                    ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)gate, (Object)((Object)new RotateBoundingBox(gate.gateOrientation, min, max.func_177982_a(1, 1, 1))), (String)"field_70121_D");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (gate.func_174813_aQ() instanceof RotateBoundingBox) {
                ((RotateBoundingBox)gate.func_174813_aQ()).rotate((float)gate.getOpeningStatus() * this.getMoveSpeed());
            }
        } else {
            int heightAdj = max.func_177956_o() - min.func_177956_o();
            BlockPos pos3 = max.func_177981_b(-heightAdj).func_177967_a(gate.gateOrientation, heightAdj);
            max = BlockTools.getMax(min, pos3).func_177982_a(1, 1, 1);
            min = BlockTools.getMin(min, pos3);
            gate.func_174826_a(new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)max.func_177958_n(), (double)max.func_177956_o(), (double)max.func_177952_p()));
        }
    }

    @Override
    public boolean canActivate(EntityGate gate, boolean open) {
        if (gate.pos1 == null || gate.pos2 == null) {
            return false;
        }
        if (!open) {
            return super.canActivate(gate, false);
        }
        BlockPos min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPos max = BlockTools.getMax(gate.pos1, gate.pos2);
        int heightAdj = max.func_177956_o() - min.func_177956_o();
        BlockPos pos3 = max.func_177981_b(-heightAdj).func_177967_a(gate.gateOrientation, heightAdj);
        max = BlockTools.getMax(min, pos3);
        min = BlockTools.getMin(min, pos3);
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                BlockPos posToCheck = new BlockPos(x, min.func_177956_o(), z);
                Block id = gate.field_70170_p.func_180495_p(posToCheck).func_177230_c();
                if (gate.field_70170_p.func_175623_d(posToCheck) || id == AWStructureBlocks.GATE_PROXY) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setInitialBounds(EntityGate gate, BlockPos pos1, BlockPos pos2) {
        BlockPos min = BlockTools.getMin(pos1, pos2);
        BlockPos max = BlockTools.getMax(pos1, pos2);
        boolean wideOnXAxis = min.func_177958_n() != max.func_177958_n();
        float width = wideOnXAxis ? (float)(max.func_177958_n() - min.func_177958_n() + 1) : (float)(max.func_177952_p() - min.func_177952_p() + 1);
        float xOffset = wideOnXAxis ? width * 0.5f : 0.5f;
        float zOffset = wideOnXAxis ? 0.5f : width * 0.5f;
        gate.setPositions(min, max);
        gate.setRenderBoundingBox(this.getRenderBoundingBox(gate, min, max));
        gate.edgeMax = 90.0f;
        gate.func_70107_b((float)min.func_177958_n() + xOffset, min.func_177956_o(), (float)min.func_177952_p() + zOffset);
    }

    @Override
    protected AxisAlignedBB getRenderBoundingBox(EntityGate gate, BlockPos min, BlockPos max) {
        int heightAdj = max.func_177956_o() - min.func_177956_o();
        BlockPos pos3 = max.func_177981_b(-heightAdj).func_177967_a(gate.gateOrientation, heightAdj);
        max = BlockTools.getMax(max, pos3).func_177982_a(1, 1, 1);
        min = BlockTools.getMin(min, pos3);
        return new AxisAlignedBB(min, max);
    }

    @Override
    public void onGateFinishOpen(EntityGate gate) {
        BlockPos min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPos max = BlockTools.getMax(gate.pos1, gate.pos2);
        int heightAdj = max.func_177956_o() - min.func_177956_o();
        BlockPos pos3 = max.func_177981_b(-heightAdj).func_177967_a(gate.gateOrientation, heightAdj);
        max = BlockTools.getMax(min, pos3);
        min = BlockTools.getMin(min, pos3);
        this.closeBetween(gate, min, max);
    }

    @Override
    public void onGateStartClose(EntityGate gate) {
        BlockPos min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPos max = BlockTools.getMax(gate.pos1, gate.pos2);
        boolean widestOnXAxis = gate.pos1.func_177958_n() != gate.pos2.func_177958_n();
        int heightAdj = max.func_177956_o() - min.func_177956_o();
        BlockPos pos3 = max.func_177981_b(-heightAdj).func_177967_a(gate.gateOrientation, heightAdj);
        max = BlockTools.getMax(min, pos3);
        min = BlockTools.getMin(min, pos3);
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    Block id;
                    if (widestOnXAxis && z == gate.pos1.func_177952_p() || !widestOnXAxis && x == gate.pos1.func_177958_n() || (id = gate.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c()) != AWStructureBlocks.GATE_PROXY) continue;
                    gate.field_70170_p.func_175698_g(new BlockPos(x, y, z));
                }
            }
        }
    }
}

