/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.biome.Biome;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureScanner;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureScanner;
import net.shadowmage.ancientwarfare.structure.registry.BiomeGroupRegistry;

public class GuiStructureBiomeSelection
extends GuiContainerBase {
    private final GuiStructureScanner parent;
    private Checkbox whiteList;
    private Text biomeSearchBox;
    private CompositeScrolled biomeArea;
    private CompositeScrolled biomeGroupArea;
    private Listener listener;
    private Text biomeGroupSearchBox;

    public GuiStructureBiomeSelection(GuiStructureScanner parent) {
        super(new ContainerBase(((ContainerStructureScanner)((Object)parent.getContainer())).player));
        this.parent = parent;
        this.shouldCloseOnVanillaKeys = false;
    }

    @Override
    public void initElements() {
        this.addGuiElement(new Label(8, 22, I18n.func_135052_a((String)"guistrings.scanner.biome_groups", (Object[])new Object[0]) + ":"));
        this.biomeGroupSearchBox = new Text(80, 22, 170, "", this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                super.onTextUpdated(oldText, newText);
                if (!oldText.equals(newText)) {
                    GuiStructureBiomeSelection.this.refreshGui();
                }
            }
        };
        this.addGuiElement(this.biomeGroupSearchBox);
        this.biomeGroupArea = new CompositeScrolled(this, 0, 36, 256, 80);
        this.addGuiElement(this.biomeGroupArea);
        this.whiteList = new Checkbox(8, 118, 16, 16, "guistrings.biome_whitelist"){

            @Override
            public void onToggled() {
                ((ContainerStructureScanner)((Object)GuiStructureBiomeSelection.this.parent.getContainer())).updateValidator(v -> v.setBiomeWhiteList(this.checked()));
            }
        };
        this.whiteList.setChecked(((ContainerStructureScanner)((Object)this.parent.getContainer())).getValidator().isBiomeWhiteList());
        this.addGuiElement(this.whiteList);
        this.addGuiElement(new Label(8, 138, I18n.func_135052_a((String)"guistrings.scanner.biomes", (Object[])new Object[0]) + ":"));
        this.biomeSearchBox = new Text(80, 138, 170, "", this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                super.onTextUpdated(oldText, newText);
                if (!oldText.equals(newText)) {
                    GuiStructureBiomeSelection.this.refreshGui();
                }
            }
        };
        this.addGuiElement(this.biomeSearchBox);
        this.biomeArea = new CompositeScrolled(this, 0, 152, 256, 100);
        this.addGuiElement(this.biomeArea);
        Button button = new Button(193, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiStructureBiomeSelection.this.parent);
            }
        };
        this.addGuiElement(button);
        this.listener = new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    Set<String> biomeNames = ((ContainerStructureScanner)((Object)GuiStructureBiomeSelection.this.parent.getContainer())).getValidator().getBiomeList();
                    if (((BiomeCheck)widget).checked()) {
                        biomeNames.add(((BiomeCheck)widget).name);
                    } else {
                        biomeNames.remove(((BiomeCheck)widget).name);
                    }
                    ((ContainerStructureScanner)((Object)GuiStructureBiomeSelection.this.parent.getContainer())).updateValidator(v -> v.setBiomeList(biomeNames));
                }
                return true;
            }
        };
        this.refreshBiomeGroupList();
        this.refreshBiomeList();
    }

    private void refreshBiomeList() {
        Set<String> biomeNames = ((ContainerStructureScanner)((Object)this.parent.getContainer())).getValidator().getBiomeList();
        this.biomeArea.clearElements();
        int totalHeight = 3;
        for (Biome biome : Biome.field_185377_q) {
            String name = biome.getRegistryName().toString();
            if (!name.contains(this.biomeSearchBox.getText()) && !biome.func_185359_l().contains(this.biomeSearchBox.getText())) continue;
            BiomeCheck box = new BiomeCheck(totalHeight, biome);
            this.biomeArea.addGuiElement(box);
            totalHeight += 16;
            if (biomeNames.contains(name)) {
                box.setChecked(true);
            }
            box.addNewListener(this.listener);
        }
        this.biomeArea.setAreaSize(totalHeight);
    }

    private void refreshBiomeGroupList() {
        int totalHeight = 3;
        Set<String> biomeGroupNames = ((ContainerStructureScanner)((Object)this.parent.getContainer())).getValidator().getBiomeGroupList();
        this.biomeGroupArea.clearElements();
        for (String biomeGroup : BiomeGroupRegistry.getBiomeGroups().stream().filter(bg -> bg.contains(this.biomeGroupSearchBox.getText())).sorted(Comparator.naturalOrder()).collect(Collectors.toList())) {
            Checkbox box = new Checkbox(8, totalHeight, 16, 16, biomeGroup){

                @Override
                public void onToggled() {
                    Set<String> biomeGroups = ((ContainerStructureScanner)((Object)GuiStructureBiomeSelection.this.parent.getContainer())).getValidator().getBiomeGroupList();
                    if (this.checked()) {
                        biomeGroups.add(this.label);
                    } else {
                        biomeGroups.remove(this.label);
                    }
                    ((ContainerStructureScanner)((Object)GuiStructureBiomeSelection.this.parent.getContainer())).updateValidator(v -> v.setBiomeGroupList(biomeGroups));
                }
            };
            this.biomeGroupArea.addGuiElement(box);
            totalHeight += 16;
            if (!biomeGroupNames.contains(biomeGroup)) continue;
            box.setChecked(true);
        }
        this.biomeGroupArea.setAreaSize(totalHeight);
    }

    @Override
    public void setupElements() {
        this.whiteList.setChecked(((ContainerStructureScanner)((Object)this.parent.getContainer())).getValidator().isBiomeWhiteList());
        this.refreshBiomeGroupList();
        this.refreshBiomeList();
    }

    private class BiomeCheck
    extends Checkbox {
        private final String name;

        public BiomeCheck(int topLeftY, Biome biome) {
            super(8, topLeftY, 16, 16, String.format("%s (%s)", biome.func_185359_l(), biome.getRegistryName().toString()));
            this.name = biome.getRegistryName().toString();
        }
    }
}

