/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiSelectFromList;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.interfaces.IWidgetSelection;
import net.shadowmage.ancientwarfare.core.util.RegistryTools;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureScanner;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureScanner;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.IStructureValidationProperty;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationPropertyBool;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationPropertyInteger;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationPropertyResourceLocation;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationPropertyString;

public class GuiStructureValidationSettings
extends GuiContainerBase {
    private final GuiStructureScanner parent;
    private CompositeScrolled area;
    private Label typeLabel;
    private static final Set<IStructureValidationProperty> EXCLUDED_PROPERTIES = ImmutableSet.of((Object)StructureValidationProperties.BIOME_GROUP_LIST, (Object)StructureValidationProperties.BIOME_LIST, (Object)StructureValidationProperties.BIOME_WHITE_LIST, (Object)StructureValidationProperties.DIMENSION_LIST, (Object)StructureValidationProperties.DIMENSION_WHITE_LIST);

    public GuiStructureValidationSettings(GuiStructureScanner parent) {
        super(new ContainerBase(((ContainerStructureScanner)((Object)parent.getContainer())).player));
        this.parent = parent;
        this.shouldCloseOnVanillaKeys = false;
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 30, 256, 210);
        this.addGuiElement(this.area);
        this.typeLabel = new Label(8, 8, "");
        this.addGuiElement(this.typeLabel);
        Button doneButton = new Button(193, 8, 55, 12, "guistrings.done");
        doneButton.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiStructureValidationSettings.this.closeGui();
                }
                return true;
            }
        });
        this.addGuiElement(doneButton);
    }

    private Listener getListener(final StructureValidationType validationType) {
        return new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiStructureValidationSettings.this.onTypeButtonPressed(validationType);
                }
                return true;
            }
        };
    }

    private void onTypeButtonPressed(StructureValidationType type) {
        StructureValidator newValidator = type.getValidator();
        newValidator.inheritPropertiesFrom(((ContainerStructureScanner)((Object)this.parent.getContainer())).getValidator());
        ((ContainerStructureScanner)((Object)this.parent.getContainer())).setValidator(newValidator);
        this.refreshGui();
    }

    @Override
    public void setupElements() {
        this.typeLabel.setText(I18n.func_135052_a((String)"guistrings.validation_type", (Object[])new Object[0]) + ": " + ((ContainerStructureScanner)((Object)this.parent.getContainer())).getValidationTypeName());
        int totalHeight = 0;
        this.area.clearElements();
        this.addValidationButton(8, 8, StructureValidationType.GROUND);
        this.addValidationButton(86, 8, StructureValidationType.UNDERGROUND);
        this.addValidationButton(164, 8, StructureValidationType.SKY);
        this.addValidationButton(8, 24, StructureValidationType.WATER);
        this.addValidationButton(86, 24, StructureValidationType.UNDERWATER);
        this.addValidationButton(164, 24, StructureValidationType.ISLAND);
        this.addValidationButton(8, 40, StructureValidationType.HARBOR);
        totalHeight += 60;
        for (IStructureValidationProperty property : ((ContainerStructureScanner)((Object)this.parent.getContainer())).getValidator().validationType.getValidationProperties()) {
            if (EXCLUDED_PROPERTIES.contains(property)) continue;
            Label label = new Label(8, totalHeight, "structure.validation." + property.getName());
            this.area.addGuiElement(label);
            if (StructureValidationPropertyInteger.class.isAssignableFrom(property.getClass())) {
                PropertyNumberInputInteger input = new PropertyNumberInputInteger(200, totalHeight - 1, 32, (StructureValidationPropertyInteger)property, this);
                this.area.addGuiElement(input);
            } else if (StructureValidationPropertyBool.class.isAssignableFrom(property.getClass())) {
                PropertyCheckbox box = new PropertyCheckbox(200, totalHeight - 3, 16, 16, (StructureValidationPropertyBool)property);
                this.area.addGuiElement(box);
            } else if (StructureValidationPropertyResourceLocation.class.isAssignableFrom(property.getClass())) {
                this.area.addGuiElement(new PropertyBiomeInput(100, totalHeight - 1, 132, 14, (StructureValidationPropertyResourceLocation)property));
            } else if (StructureValidationPropertyString.class.isAssignableFrom(property.getClass())) {
                this.area.addGuiElement(new PropertyText(100, totalHeight - 3, 132, this, (StructureValidationPropertyString)property));
            }
            totalHeight += 16;
        }
        this.area.setAreaSize(totalHeight);
    }

    private void addValidationButton(int topLeftX, int topLeftY, StructureValidationType validationType) {
        Button button = new Button(topLeftX, topLeftY, 78, 16, validationType.getName());
        button.addNewListener(this.getListener(validationType));
        this.area.addGuiElement(button);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }

    private class PropertyBiomeInput
    extends Button {
        private final StructureValidationPropertyResourceLocation property;

        private PropertyBiomeInput(int topLeftX, int topLeftY, int width, int height, StructureValidationPropertyResourceLocation property) {
            super(topLeftX, topLeftY, width, height, ((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).getValidator().getPropertyValue(property).toString());
            this.property = property;
        }

        @Override
        protected void onPressed() {
            Minecraft.func_71410_x().func_147108_a(new GuiSelectFromList<String>(GuiStructureValidationSettings.this, this.text, s -> s, () -> ForgeRegistries.BIOMES.getEntries().stream().map(e -> ((ResourceLocation)e.getKey()).toString()).sorted(Comparator.naturalOrder()).collect(() -> {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add(RegistryTools.EMPTY_REGISTRY_NAME.toString());
                return ret;
            }, List::add, List::addAll), s -> {
                this.setText((String)s);
                StructureValidator validator = ((ContainerStructureScanner)((Object)((Object)GuiStructureValidationSettings.this.parent.getContainer()))).getValidator();
                validator.setPropertyValue(this.property, new ResourceLocation(s));
                ((ContainerStructureScanner)((Object)((Object)GuiStructureValidationSettings.this.parent.getContainer()))).setValidator(validator);
            }));
            GuiStructureValidationSettings.this.refreshGui();
        }
    }

    private class PropertyNumberInputInteger
    extends NumberInput {
        private final StructureValidationPropertyInteger prop;

        private PropertyNumberInputInteger(int topLeftX, int topLeftY, int width, StructureValidationPropertyInteger property, IWidgetSelection selector) {
            super(topLeftX, topLeftY, width, ((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).getValidator().getPropertyValue(property).intValue(), selector);
            this.prop = property;
            this.setIntegerValue();
        }

        @Override
        public void onValueUpdated(float value) {
            StructureValidator validator = ((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).getValidator();
            validator.setPropertyValue(this.prop, (int)value);
            ((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).setValidator(validator);
        }
    }

    private class PropertyCheckbox
    extends Checkbox {
        private final StructureValidationPropertyBool prop;

        private PropertyCheckbox(int topLeftX, int topLeftY, int width, int height, StructureValidationPropertyBool property) {
            super(topLeftX, topLeftY, width, height, "");
            this.prop = property;
            this.setChecked(((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).getValidator().getPropertyValue(this.prop));
        }

        @Override
        public void onToggled() {
            StructureValidator validator = ((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).getValidator();
            validator.setPropertyValue(this.prop, this.checked());
            ((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).setValidator(validator);
        }
    }

    private class PropertyText
    extends Text {
        private final StructureValidationPropertyString prop;

        public PropertyText(int topLeftX, int topLeftY, int width, IWidgetSelection selector, StructureValidationPropertyString property) {
            super(topLeftX, topLeftY, width, ((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).getValidator().getPropertyValue(property), selector);
            this.prop = property;
        }

        @Override
        public void onTextUpdated(String oldText, String newText) {
            StructureValidator validator = ((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).getValidator();
            validator.setPropertyValue(this.prop, newText);
            ((ContainerStructureScanner)((Object)GuiStructureValidationSettings.this.parent.getContainer())).setValidator(validator);
        }
    }
}

