/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.input.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.item.ItemBlockBase;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;

public class ItemBlockAdvancedSpawner
extends ItemBlockBase
implements IItemKeyInterface {
    private static final String SPAWNER_SETTINGS_TAG = "spawnerSettings";

    public ItemBlockAdvancedSpawner(Block block) {
        super(block);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(SPAWNER_SETTINGS_TAG)) {
            SpawnerSettings settings = SpawnerSettings.getDefaultSettings();
            NBTTagCompound defaultTag = new NBTTagCompound();
            settings.writeToNBT(defaultTag);
            stack.func_77983_a(SPAWNER_SETTINGS_TAG, (NBTBase)defaultTag);
        }
        boolean val = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (!world.field_72995_K && val) {
            WorldTools.getTile((IBlockAccess)world, pos, TileAdvancedSpawner.class).ifPresent(t -> {
                SpawnerSettings settings = new SpawnerSettings();
                settings.readFromNBT(stack.func_77978_p().func_74775_l(SPAWNER_SETTINGS_TAG));
                t.setSettings(settings);
            });
        }
        return val;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        if (player.func_70093_af()) {
            NetworkHandler.INSTANCE.openGui(player, 9, 0, 0, 0);
        } else {
            NetworkHandler.INSTANCE.openGui(player, 7, 0, 0, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(SPAWNER_SETTINGS_TAG)) {
            tooltip.add(I18n.func_135052_a((String)"guistrings.corrupt_item", (Object[])new Object[0]));
            return;
        }
        SpawnerSettings tooltipSettings = new SpawnerSettings();
        tooltipSettings.readFromNBT(stack.func_77978_p().func_74775_l(SPAWNER_SETTINGS_TAG));
        List<SpawnerSettings.EntitySpawnGroup> groups = tooltipSettings.getSpawnGroups();
        tooltip.add(I18n.func_135052_a((String)"guistrings.spawner.group_count", (Object[])new Object[0]) + ": " + groups.size());
        for (int i = 0; i < groups.size(); ++i) {
            SpawnerSettings.EntitySpawnGroup group = groups.get(i);
            tooltip.add(I18n.func_135052_a((String)"guistrings.spawner.group_number", (Object[])new Object[0]) + ": " + (i + 1) + " " + I18n.func_135052_a((String)"guistrings.spawner.group_weight", (Object[])new Object[0]) + ": " + group.getWeight());
            for (SpawnerSettings.EntitySpawnSettings set : group.getEntitiesToSpawn()) {
                tooltip.add("  " + I18n.func_135052_a((String)"guistrings.spawner.entity_type", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)set.getEntityName(), (Object[])new Object[0]) + " " + set.getSpawnMin() + " to " + set.getSpawnMax() + " (" + (set.getSpawnTotal() < 0 ? "infinite" : Integer.valueOf(set.getSpawnTotal())) + " total)");
            }
        }
    }
}

