/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.structure.block.BlockCoffin;
import net.shadowmage.ancientwarfare.structure.block.BlockWoodenCoffin;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockCoffin;

public class ItemBlockWoodenCoffin
extends ItemBlockCoffin {
    private static final String VARIANT_TAG = "variant";

    public ItemBlockWoodenCoffin(Block block) {
        super(block);
    }

    @Override
    public boolean mayPlace(World world, BlockPos pos, EnumFacing sidePlacedOn, EntityPlayer placer) {
        return ItemBlockWoodenCoffin.canPlace(world, pos, sidePlacedOn, placer);
    }

    public static boolean canPlace(World world, BlockPos pos, EnumFacing sidePlacedOn, EntityPlayer placer) {
        return ItemBlockWoodenCoffin.canPlaceHorizontal(world, pos, sidePlacedOn, (EntityLivingBase)placer) || ItemBlockWoodenCoffin.canPlaceVertical(world, pos, sidePlacedOn);
    }

    private static boolean canPlaceVertical(World world, BlockPos pos, EnumFacing sidePlacedOn) {
        for (int offset = 0; offset < 3; ++offset) {
            if (ItemBlockWoodenCoffin.mayPlaceAt(world, pos.func_177967_a(EnumFacing.UP, offset), sidePlacedOn, offset == 0)) continue;
            return false;
        }
        return true;
    }

    public static boolean canPlaceHorizontal(World world, BlockPos pos, EnumFacing sidePlacedOn, EntityLivingBase placer) {
        EnumFacing facing = placer.func_174811_aO();
        for (int offset = 1; offset < 3; ++offset) {
            if (ItemBlockWoodenCoffin.mayPlaceAt(world, pos.func_177967_a(facing, offset), sidePlacedOn, false)) continue;
            return false;
        }
        return true;
    }

    public static BlockWoodenCoffin.Variant getVariant(ItemStack stack) {
        return stack.func_77942_o() ? BlockWoodenCoffin.Variant.fromName(stack.func_77978_p().func_74779_i(VARIANT_TAG)) : BlockWoodenCoffin.Variant.getDefault();
    }

    public static ItemStack getVariantStack(BlockCoffin.IVariant variant) {
        ItemStack stack = new ItemStack(AWStructureBlocks.WOODEN_COFFIN);
        stack.func_77982_d(new NBTBuilder().setString(VARIANT_TAG, variant.func_176610_l()).build());
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77667_c(stack);
        }
        return String.format("%s.%s", super.func_77667_c(stack), stack.func_77978_p().func_74779_i(VARIANT_TAG));
    }
}

