/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.awt.Color;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.input.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureScanner;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.save.TemplateExporter;
import net.shadowmage.ancientwarfare.structure.template.scan.TemplateScanner;

public class ItemStructureScanner
extends ItemBaseStructure
implements IItemKeyInterface,
IBoxRenderer {
    private static final String VALIDATOR_TAG = "validator";
    private static final String STRUCTURE_NAME_TAG = "structureName";
    private static final String INCLUDE_TAG = "include";
    private static final String MOD_DEPENDENCIES_TAG = "mods";

    public ItemStructureScanner(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_190926_b()) {
            ItemStructureSettings viewSettings = ItemStructureSettings.getSettingsFor(stack);
            String key = InputHandler.ALT_ITEM_USE_1.getDisplayName();
            if (!viewSettings.hasPos1()) {
                tooltip.add(I18n.func_135052_a((String)"guistrings.structure.scanner.select_first_pos", (Object[])new Object[]{key}));
                tooltip.add("(1/4)");
            } else if (!viewSettings.hasPos2()) {
                tooltip.add(I18n.func_135052_a((String)"guistrings.structure.scanner.select_second_pos", (Object[])new Object[]{key}));
                tooltip.add("(2/4)");
            } else if (!viewSettings.hasBuildKey()) {
                tooltip.add(I18n.func_135052_a((String)"guistrings.structure.scanner.select_offset", (Object[])new Object[]{key}));
                tooltip.add("(3/4)");
            } else {
                tooltip.add(key + " : " + I18n.func_135052_a((String)"guistrings.structure.scanner.click_to_process", (Object[])new Object[0]));
                tooltip.add("(4/4)");
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        ItemStructureSettings scanSettings = ItemStructureSettings.getSettingsFor(stack);
        if (player.func_70093_af()) {
            scanSettings.clearSettings();
            ItemStructureSettings.setSettingsFor(stack, scanSettings);
        } else if (ItemStructureScanner.readyToExport(scanSettings)) {
            BlockPos key = scanSettings.key;
            if (player.func_70011_f((double)key.func_177958_n() + 0.5, (double)key.func_177956_o(), (double)key.func_177952_p() + 0.5) > 10.0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.scanner.too_far", new Object[0]));
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.scanner.exporting", new Object[0]));
            NetworkHandler.INSTANCE.openGui(player, 1, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static boolean readyToExport(ItemStack scanner) {
        return ItemStructureScanner.readyToExport(ItemStructureSettings.getSettingsFor(scanner));
    }

    private static boolean readyToExport(ItemStructureSettings scanSettings) {
        return scanSettings.hasPos1() && scanSettings.hasPos2() && scanSettings.hasBuildKey();
    }

    public static void setStructureName(ItemStack stack, String name) {
        stack.func_77983_a(STRUCTURE_NAME_TAG, (NBTBase)new NBTTagString(name));
    }

    public static String getStructureName(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74779_i(STRUCTURE_NAME_TAG) : "";
    }

    public static void setValidator(ItemStack stack, StructureValidator validator) {
        stack.func_77983_a(VALIDATOR_TAG, (NBTBase)validator.serializeToNBT());
    }

    public static StructureValidator getValidator(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(VALIDATOR_TAG)) {
            return StructureValidationType.GROUND.getValidator();
        }
        NBTTagCompound validatorTag = stack.func_77978_p().func_74775_l(VALIDATOR_TAG);
        Optional<StructureValidationType> type = StructureValidationType.getTypeFromName(validatorTag.func_74779_i("validationType"));
        if (!type.isPresent()) {
            return StructureValidationType.GROUND.getValidator();
        }
        StructureValidator validator = type.get().getValidator();
        validator.readFromNBT(validatorTag);
        return validator;
    }

    public static void setIncludeImmediately(ItemStack stack, boolean include) {
        stack.func_77983_a(INCLUDE_TAG, (NBTBase)new NBTTagByte((byte)(include ? 1 : 0)));
    }

    public static boolean getIncludeImmediately(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(INCLUDE_TAG);
    }

    public static boolean scanStructure(World world, ItemStack scanner) {
        ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(scanner);
        int turns = (6 - settings.buildFace.func_176736_b()) % 4;
        StructureTemplate template = TemplateScanner.scan(world, ItemStructureScanner.getModDependencies(scanner), settings.getMin(), settings.getMax(), settings.key, turns, ItemStructureScanner.getStructureName(scanner));
        StructureValidator validator = ItemStructureScanner.getValidator(scanner);
        template.setValidationSettings(validator);
        boolean include = ItemStructureScanner.getIncludeImmediately(scanner);
        if (include) {
            StructureTemplateManager.addTemplate(template);
        }
        return TemplateExporter.exportTo(template, new File(include ? "config/ancientwarfare/structures/included/" : "config/ancientwarfare/structures/export/"));
    }

    public static Set<String> getModDependencies(ItemStack scanner) {
        return scanner.func_77942_o() ? NBTHelper.getStringSet(scanner.func_77978_p().func_150295_c(MOD_DEPENDENCIES_TAG, 8)) : Collections.emptySet();
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        BlockPos hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
        if (hit == null) {
            return;
        }
        ItemStructureSettings scanSettings = ItemStructureSettings.getSettingsFor(stack);
        if (!scanSettings.hasPos1()) {
            scanSettings.setPos1(hit);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.scanner.set_first_pos", new Object[0]));
        } else if (!scanSettings.hasPos2()) {
            scanSettings.setPos2(hit);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.scanner.set_second_pos", new Object[0]));
        } else if (!scanSettings.hasBuildKey()) {
            scanSettings.setBuildKey(hit, player.func_174811_aO());
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.scanner.set_offset_pos", new Object[0]));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.structure.scanner.click_to_process", new Object[0]));
        }
        ItemStructureSettings.setSettingsFor(stack, scanSettings);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBox(EntityPlayer player, EnumHand hand, ItemStack stack, float delta) {
        ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(stack);
        BlockPos firstCorner = settings.hasPos1() ? settings.getPos1() : BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
        BlockPos secondCorner = settings.hasPos2() ? settings.getPos2() : BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
        if (firstCorner == null || secondCorner == null) {
            return;
        }
        BlockPos min = BlockTools.getMin(firstCorner, secondCorner);
        BlockPos max = BlockTools.getMax(firstCorner, secondCorner);
        IBoxRenderer.Util.renderBoundingBox(player, min, max, delta);
        if (settings.hasPos2()) {
            BlockPos buildKey = settings.buildKey();
            if (!settings.hasBuildKey()) {
                buildKey = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
            }
            if (buildKey != null) {
                IBoxRenderer.Util.renderBoundingBox(player, buildKey, buildKey, delta, Color.GREEN);
                BlockPos outerFirst = new BlockPos(min.func_177958_n() - 1, buildKey.func_177956_o(), min.func_177952_p() - 1);
                BlockPos outerSecond = new BlockPos(max.func_177958_n() + 1, buildKey.func_177956_o(), max.func_177952_p() + 1);
                IBoxRenderer.Util.renderBoundingBoxTopSide(player, outerFirst, outerSecond, delta, new Color(Color.GREEN.getRed(), Color.GREEN.getGreen(), Color.GREEN.getBlue(), 80));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(1, GuiStructureScanner.class);
    }

    public static void clearSettings(ItemStack scanner) {
        ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(scanner);
        settings.clearSettings();
        ItemStructureSettings.setSettingsFor(scanner, settings);
        scanner.func_77978_p().func_82580_o(STRUCTURE_NAME_TAG);
        scanner.func_77978_p().func_82580_o(MOD_DEPENDENCIES_TAG);
        scanner.func_77978_p().func_82580_o(INCLUDE_TAG);
        scanner.func_190919_e(VALIDATOR_TAG);
    }

    public static void setModDependencies(ItemStack scanner, Set<String> mods) {
        scanner.func_77983_a(MOD_DEPENDENCIES_TAG, (NBTBase)NBTHelper.getNBTStringList(mods));
    }
}

