/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;

public class PacketStructure
extends PacketBase {
    public NBTTagCompound packetData = new NBTTagCompound();

    @Override
    protected void writeToStream(ByteBuf data) {
        if (this.packetData != null) {
            try (ByteBufOutputStream outputStream = new ByteBufOutputStream(data);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.packetData, (OutputStream)outputStream);
            }
            catch (IOException e) {
                AncientWarfareStructure.LOG.error("Error writing structure template packet: ", (Throwable)e);
            }
        }
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        try (ByteBufInputStream inputStream = new ByteBufInputStream(data);){
            this.packetData = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        }
        catch (IOException e) {
            AncientWarfareStructure.LOG.error("Error reading structure template packet: ", (Throwable)e);
        }
    }

    @Override
    protected void execute() {
        StructureTemplateManager.onTemplateData(this.packetData);
    }
}

