/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.proxy;

import codechicken.lib.util.ResourceUtils;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.proxy.IClientRegister;
import net.shadowmage.ancientwarfare.structure.client.AWStructureBlockColors;
import net.shadowmage.ancientwarfare.structure.client.AWStructureItemColors;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.gui.GuiGateControl;
import net.shadowmage.ancientwarfare.structure.gui.GuiGateControlCreative;
import net.shadowmage.ancientwarfare.structure.proxy.CommonProxyStructure;
import net.shadowmage.ancientwarfare.structure.render.BlockHighlightRenderer;
import net.shadowmage.ancientwarfare.structure.render.ParticleOnlyModel;
import net.shadowmage.ancientwarfare.structure.render.PreviewRenderer;
import net.shadowmage.ancientwarfare.structure.render.RenderGateInvisible;
import net.shadowmage.ancientwarfare.structure.render.StructureBoundingBoxRenderer;
import net.shadowmage.ancientwarfare.structure.render.StructureEntryBBRenderer;
import net.shadowmage.ancientwarfare.structure.sounds.SoundLoader;

@SideOnly(value=Side.CLIENT)
public class ClientProxyStructure
extends CommonProxyStructure {
    private Set<IClientRegister> clientRegisters = Sets.newHashSet();
    private Map<BlockPos, PositionedSoundRecord> currentSounds = new HashMap<BlockPos, PositionedSoundRecord>();

    public ClientProxyStructure() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (IClientRegister register : this.clientRegisters) {
            register.registerClient();
        }
    }

    @Override
    public void addClientRegister(IClientRegister register) {
        this.clientRegisters.add(register);
    }

    @Override
    public void preInit() {
        super.preInit();
        NetworkHandler.registerGui(11, GuiGateControl.class);
        NetworkHandler.registerGui(58, GuiGateControlCreative.class);
        MinecraftForge.EVENT_BUS.register((Object)new StructureBoundingBoxRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new BlockHighlightRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new StructureEntryBBRenderer());
        MinecraftForge.EVENT_BUS.register((Object)this);
        RenderingRegistry.registerEntityRenderingHandler(EntityGate.class, RenderGateInvisible::new);
        ResourceUtils.registerReloadListener((IResourceManagerReloadListener)ParticleOnlyModel.INSTANCE);
    }

    @Override
    public void init() {
        super.init();
        ResourceUtils.registerReloadListener((IResourceManagerReloadListener)new SoundLoader());
        AWStructureBlockColors.init();
        AWStructureItemColors.init();
    }

    @Override
    public void clearTemplatePreviewCache() {
        PreviewRenderer.clearCache();
    }

    @Override
    public void resetSoundAt(BlockPos pos) {
        this.currentSounds.remove(pos);
    }

    @Override
    public void setSoundAt(BlockPos pos, SoundEvent soundEvent, float volume) {
        this.currentSounds.put(pos, this.getPositionedSoundRecord(soundEvent, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), volume));
    }

    private PositionedSoundRecord getPositionedSoundRecord(SoundEvent soundEvent, float x, float y, float z, float volume) {
        return new PositionedSoundRecord(soundEvent.func_187503_a(), SoundCategory.RECORDS, volume, 1.0f, false, 0, ISound.AttenuationType.LINEAR, x, y, z);
    }

    @Override
    public void stopSoundAt(BlockPos pos) {
        if (this.currentSounds.containsKey(pos)) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.currentSounds.get(pos));
        }
    }

    @Override
    public boolean hasSoundAt(BlockPos pos) {
        return this.currentSounds.containsKey(pos);
    }

    @Override
    public boolean isSoundPlayingAt(BlockPos pos) {
        if (!this.hasSoundAt(pos)) {
            return false;
        }
        ISound positionedsoundrecord = (ISound)this.currentSounds.get(pos);
        return Minecraft.func_71410_x().func_147118_V().func_147692_c(positionedsoundrecord);
    }

    @Override
    public void playSoundAt(BlockPos pos) {
        if (this.hasSoundAt(pos)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.currentSounds.get(pos));
        }
    }

    @Override
    public double getClientPlayerDistanceTo(BlockPos pos) {
        return Minecraft.func_71410_x().field_71439_g.func_70011_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    @Override
    public Optional<EntityPlayer> getPlayer() {
        return Optional.of(Minecraft.func_71410_x().field_71439_g);
    }
}

