/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class LayeredCustomColorMaskTexture
extends AbstractTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation textureLocation;
    private final List<String> textures;
    private final List<Integer> colors;

    public LayeredCustomColorMaskTexture(ResourceLocation textureLocation, List<String> textures, List<Integer> colors) {
        this.textureLocation = textureLocation;
        this.textures = textures;
        this.colors = colors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        IResource resource = null;
        try {
            resource = resourceManager.func_110536_a(this.textureLocation);
            BufferedImage bufferedimage1 = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
            int i = bufferedimage1.getType();
            if (i == 0) {
                i = 6;
            }
            BufferedImage bufferedimage = new BufferedImage(bufferedimage1.getWidth(), bufferedimage1.getHeight(), i);
            Graphics graphics = bufferedimage.getGraphics();
            graphics.drawImage(bufferedimage1, 0, 0, null);
            for (int j = 0; j < 17 && j < this.textures.size() && j < this.colors.size(); ++j) {
                String texture = this.textures.get(j);
                int color = this.colors.get(j);
                this.overlayTexture(resourceManager, bufferedimage, bufferedimage1, texture, color);
            }
            TextureUtil.func_110987_a((int)this.func_110552_b(), (BufferedImage)bufferedimage);
        }
        catch (IOException ioexception) {
            try {
                LOGGER.error("Couldn't load layered image", (Throwable)ioexception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resource);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
        IOUtils.closeQuietly((Closeable)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overlayTexture(IResourceManager resourceManager, BufferedImage bufferedimage, BufferedImage bufferedimage1, String textureName, int color) throws IOException {
        IResource iresource1 = null;
        try {
            BufferedImage bufferedimage2;
            if (textureName != null && (bufferedimage2 = TextureUtil.func_177053_a((InputStream)(iresource1 = resourceManager.func_110536_a(new ResourceLocation(textureName))).func_110527_b())).getWidth() == bufferedimage.getWidth() && bufferedimage2.getHeight() == bufferedimage.getHeight() && bufferedimage2.getType() == 6) {
                for (int l = 0; l < bufferedimage2.getHeight(); ++l) {
                    for (int i1 = 0; i1 < bufferedimage2.getWidth(); ++i1) {
                        int j1 = bufferedimage2.getRGB(i1, l);
                        if ((j1 & 0xFF000000) == 0) continue;
                        int k1 = (j1 & 0xFF0000) << 8 & 0xFF000000;
                        int l1 = bufferedimage1.getRGB(i1, l);
                        int i2 = MathHelper.func_180188_d((int)l1, (int)color) & 0xFFFFFF;
                        bufferedimage2.setRGB(i1, l, k1 | i2);
                    }
                }
                bufferedimage.getGraphics().drawImage(bufferedimage2, 0, 0, null);
            }
        }
        finally {
            IOUtils.closeQuietly(iresource1);
        }
    }
}

