/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render;

import codechicken.lib.render.CCModelState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.TransformUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBanner;
import net.minecraft.client.model.ModelHumanoidHead;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.shadowmage.ancientwarfare.structure.tile.TileFlag;

public class ProtectionFlagRenderer
extends TileEntitySpecialRenderer<TileFlag>
implements IItemRenderer {
    private final ModelBanner bannerModel = new ModelBanner();
    private final ModelSkeletonHead humanoidHead = new ModelHumanoidHead();
    private static final IModelState TRANSFORMS;

    public void render(TileFlag te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        boolean flag = te.func_145831_w() != null;
        int angle = flag ? te.func_145832_p() : 0;
        long worldTime = flag ? te.func_145831_w().func_82737_E() : 0L;
        String faction = te.getName();
        BlockPos pos = te.func_174877_v();
        this.render((float)x, (float)y, (float)z, partialTicks, alpha, angle, worldTime, faction, pos);
        if (te.isPlayerOwned()) {
            this.renderPlayerHead(te.getPlayerProfile(), (float)x, (float)y, (float)z, partialTicks, angle);
        }
    }

    private void renderPlayerHead(GameProfile profile, float x, float y, float z, float animateTicks, int rotation) {
        ResourceLocation resourcelocation;
        Minecraft minecraft = Minecraft.func_71410_x();
        Map map = minecraft.func_152342_ad().func_152788_a(profile);
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        } else {
            UUID uuid = EntityPlayer.func_146094_a((GameProfile)profile);
            resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
        }
        this.func_147499_a(resourcelocation);
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 2.0f), (float)(z + 0.5f));
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        this.humanoidHead.func_78088_a(null, animateTicks, 0.0f, 0.0f, 360.0f * ((float)rotation / 16.0f) - 180.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
    }

    private void render(float x, float y, float z, float partialTicks, float alpha, int rotation, float worldTime, String faction, BlockPos pos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.5f), (float)(z + 0.5f));
        float f1 = (float)(rotation * 360) / 16.0f;
        GlStateManager.func_179114_b((float)(-f1), (float)0.0f, (float)1.0f, (float)0.0f);
        this.bannerModel.field_178688_b.field_78806_j = true;
        float f3 = (float)(pos.func_177958_n() * 7 + pos.func_177956_o() * 9 + pos.func_177952_p() * 13) + worldTime + partialTicks;
        this.bannerModel.field_178690_a.field_78795_f = (-0.0125f + 0.01f * MathHelper.func_76134_b((float)(f3 * (float)Math.PI * 0.02f))) * (float)Math.PI;
        GlStateManager.func_179091_B();
        ResourceLocation resourcelocation = this.getBannerResourceLocation(faction);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resourcelocation);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.6666667f, (float)-0.6666667f, (float)-0.6666667f);
        this.bannerModel.func_178687_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179121_F();
    }

    private ResourceLocation getBannerResourceLocation(String faction) {
        ResourceLocation textureEntry = new ResourceLocation("ancientwarfare", "textures/entity/structure/banner/" + faction + ".png");
        return textureEntry;
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        if (!stack.func_77942_o()) {
            return;
        }
        GlStateManager.func_179094_E();
        NBTTagCompound tag = stack.func_77978_p();
        this.render(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0, 0.0f, tag.func_74779_i("name"), BlockPos.field_177992_a);
        GlStateManager.func_179121_F();
    }

    public IModelState getTransforms() {
        return TRANSFORMS;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    static {
        HashMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
        TRSRTransformation thirdPerson = TransformUtils.create((float)0.0f, (float)2.5f, (float)0.0f, (float)75.0f, (float)-45.0f, (float)0.0f, (float)0.6f);
        map.put(ItemCameraTransforms.TransformType.GUI, TransformUtils.create((float)0.0f, (float)-3.0f, (float)0.0f, (float)30.0f, (float)45.0f, (float)0.0f, (float)0.525f));
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f));
        map.put(ItemCameraTransforms.TransformType.FIXED, TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft((TRSRTransformation)thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-45.0f, (float)0.0f, (float)0.4f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)225.0f, (float)0.0f, (float)0.4f));
        TRANSFORMS = new CCModelState(map);
    }
}

