/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render.statue;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.ModelEnderman;
import net.minecraft.client.model.ModelSkeleton;
import net.minecraft.client.model.ModelZombie;
import net.minecraft.client.model.ModelZombieVillager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.structure.render.statue.BipedStatueModel;
import net.shadowmage.ancientwarfare.structure.render.statue.GuardianStatueModel;
import net.shadowmage.ancientwarfare.structure.render.statue.IStatueModel;
import net.shadowmage.ancientwarfare.structure.render.statue.VexStatueModel;

@SideOnly(value=Side.CLIENT)
public class StatueEntityRegistry {
    private static final Map<String, StatueEntity> STATUE_ENTITIES;

    private StatueEntityRegistry() {
    }

    public static Set<String> getStatueEntityNames() {
        return STATUE_ENTITIES.keySet();
    }

    public static StatueEntity getStatueEntity(String name) {
        return STATUE_ENTITIES.get(name);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"Zombie", (Object)new StatueEntity("Zombie", EntityZombie::new, () -> new BipedStatueModel<ModelZombie>(new ModelZombie())));
        builder.put((Object)"Enderman", (Object)new StatueEntity("Enderman", EntityEnderman::new, () -> new BipedStatueModel<ModelEnderman>(new ModelEnderman(0.0f))));
        builder.put((Object)"Skeleton", (Object)new StatueEntity("Skeleton", EntitySkeleton::new, () -> new BipedStatueModel<ModelSkeleton>(new ModelSkeleton())));
        builder.put((Object)"Vex", (Object)new StatueEntity("Vex", EntityVex::new, VexStatueModel::new));
        builder.put((Object)"Zombie Villager", (Object)new StatueEntity("Zombie Villager", EntityZombieVillager::new, () -> new BipedStatueModel<ModelZombieVillager>(new ModelZombieVillager())));
        builder.put((Object)"Elder Guardian", (Object)new StatueEntity("Elder Guardian", EntityElderGuardian::new, GuardianStatueModel::new));
        builder.put((Object)"Guardian", (Object)new StatueEntity("Guardian", EntityGuardian::new, GuardianStatueModel::new));
        STATUE_ENTITIES = builder.build();
    }

    public static class StatueEntity {
        private String name;
        private Function<World, EntityLivingBase> instantiateEntity;
        private Supplier<IStatueModel> getStatueModel;

        public StatueEntity(String name, Function<World, EntityLivingBase> instantiateEntity, Supplier<IStatueModel> getStatueModel) {
            this.name = name;
            this.instantiateEntity = instantiateEntity;
            this.getStatueModel = getStatueModel;
        }

        public EntityLivingBase instantiateEntity(World world) {
            return this.instantiateEntity.apply(world);
        }

        public IStatueModel getStatueModel() {
            return this.getStatueModel.get();
        }
    }
}

