/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render.statue;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.shadowmage.ancientwarfare.core.util.MathUtils;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.render.statue.IStatueModel;
import net.shadowmage.ancientwarfare.structure.render.statue.StatueEntityRegistry;
import net.shadowmage.ancientwarfare.structure.tile.EntityStatueInfo;
import net.shadowmage.ancientwarfare.structure.tile.TileStatue;

public class StatueRenderer
extends TileEntitySpecialRenderer<TileStatue> {
    private static final Method GET_ENTITY_TEXTURE = ObfuscationReflectionHelper.findMethod(Render.class, (String)"func_110775_a", ResourceLocation.class, (Class[])new Class[]{Entity.class});

    public void render(TileStatue te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        EntityStatueInfo statueInfo = te.getEntityStatueInfo();
        if (statueInfo.getRenderType() == EntityStatueInfo.RenderType.MODEL) {
            StatueEntityRegistry.StatueEntity statueEntity = StatueEntityRegistry.getStatueEntity(statueInfo.getStatueEntityName());
            EntityLivingBase entity = statueEntity.instantiateEntity((World)Minecraft.func_71410_x().field_71441_e);
            RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
            Render render = rendermanager.func_78713_a((Entity)entity);
            RenderLivingBase livingRender = (RenderLivingBase)render;
            IStatueModel statueModel = statueEntity.getStatueModel();
            this.applyPartTransforms(statueModel, statueInfo.getPartTransforms());
            this.doRender((RenderLivingBase<EntityLivingBase>)livingRender, statueModel, statueInfo.getOverallTransform(), entity, (float)x + 0.5f, (float)y, (float)z + 0.5f, this.getEntityTexture((Render)livingRender, (Entity)entity), te.getPrimaryFacing());
        }
    }

    private void applyPartTransforms(IStatueModel statueModel, Map<String, EntityStatueInfo.Transform> partTransforms) {
        for (String partName : statueModel.getModelPartNames()) {
            ModelRenderer part = statueModel.getModelPart(partName);
            EntityStatueInfo.Transform transform = partTransforms.getOrDefault(partName, new EntityStatueInfo.Transform());
            EntityStatueInfo.Transform baseTransform = statueModel.getBaseTransforms().getOrDefault(partName, new EntityStatueInfo.Transform());
            part.field_82906_o = baseTransform.getOffsetX() + transform.getOffsetX();
            part.field_82908_p = baseTransform.getOffsetY() + transform.getOffsetY();
            part.field_82907_q = baseTransform.getOffsetZ() + transform.getOffsetZ();
            part.field_78795_f = baseTransform.getRotationX() + transform.getRotationX();
            part.field_78796_g = baseTransform.getRotationY() + transform.getRotationY();
            part.field_78808_h = baseTransform.getRotationZ() + transform.getRotationZ();
        }
    }

    private void doRender(RenderLivingBase<EntityLivingBase> renderer, IStatueModel statueModel, EntityStatueInfo.Transform overallTransform, EntityLivingBase entity, float x, float y, float z, ResourceLocation entityTexture, EnumFacing primaryFacing) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        try {
            float scale;
            float f = entity.field_70761_aq + overallTransform.getRotationY() + primaryFacing.func_185119_l();
            GlStateManager.func_179109_b((float)(x + overallTransform.getOffsetX()), (float)(y + overallTransform.getOffsetY()), (float)(z + overallTransform.getOffsetZ()));
            GlStateManager.func_179114_b((float)(180.0f - f), (float)0.0f, (float)1.0f, (float)0.0f);
            if (!MathUtils.epsilonEquals(overallTransform.getRotationX(), 0.0f)) {
                GlStateManager.func_179114_b((float)overallTransform.getRotationX(), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (!MathUtils.epsilonEquals(overallTransform.getRotationZ(), 0.0f)) {
                GlStateManager.func_179114_b((float)overallTransform.getRotationZ(), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (!MathUtils.epsilonEquals(scale = overallTransform.getScale(), 1.0f)) {
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            }
            float f4 = renderer.func_188322_c(entity, 0.0f);
            float limbSwingAmount = 0.0f;
            float limbSwing = 0.0f;
            if (!entity.func_184218_aH()) {
                limbSwingAmount = entity.field_184618_aE;
                limbSwing = entity.field_184619_aG - entity.field_70721_aZ;
                if (entity.func_70631_g_()) {
                    limbSwing *= 3.0f;
                }
                if (limbSwingAmount > 1.0f) {
                    limbSwingAmount = 1.0f;
                }
            }
            GlStateManager.func_179141_d();
            statueModel.getModel().func_78086_a(entity, limbSwing, limbSwingAmount, 0.0f);
            this.renderModel(statueModel, entityTexture, f4);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179101_C();
        }
        catch (Exception exception) {
            AncientWarfareStructure.LOG.error("Couldn't render entity", (Throwable)exception);
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private ResourceLocation getEntityTexture(Render render, Entity entity) {
        try {
            return (ResourceLocation)GET_ENTITY_TEXTURE.invoke((Object)render, entity);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            AncientWarfareStructure.LOG.error("Error getting entity texture: ", (Throwable)e);
            return new ResourceLocation("");
        }
    }

    private void renderModel(IStatueModel model, ResourceLocation entityTexture, float scale) {
        if (!this.bindEntityTexture(entityTexture)) {
            return;
        }
        GlStateManager.func_179094_E();
        model.render(scale);
        GlStateManager.func_179121_F();
    }

    private boolean bindEntityTexture(@Nullable ResourceLocation resourcelocation) {
        if (resourcelocation == null) {
            return false;
        }
        this.func_147499_a(resourcelocation);
        return true;
    }

    public void func_147499_a(ResourceLocation location) {
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(location);
    }
}

