/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.biome.BiomeSavanna;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntityBase;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;

public class StructureBuilder
implements IStructureBuilder {
    protected StructureTemplate template;
    protected World world;
    BlockPos buildOrigin;
    EnumFacing buildFace;
    protected int turns;
    int maxPriority = 3;
    int currentPriority;
    Vec3i curTempPos;
    BlockPos destination;
    protected StructureBB bb;
    private boolean isFinished = false;
    private Biome biome;
    private Map<BlockPos, IBlockState> statesToSetAgain = new HashMap<BlockPos, IBlockState>();
    private Map<BlockPos, IBlockState> positionsToUpdate = new HashMap<BlockPos, IBlockState>();
    private static final Set<Block> DOUBLE_SET_BLOCKS = ImmutableSet.of((Object)Blocks.field_150448_aq, (Object)Blocks.field_150408_cc, (Object)Blocks.field_150319_E, (Object)Blocks.field_150318_D);
    private static final Map<Class, Set<IBlockSwapMapping>> BIOME_SWAP_STATES = ImmutableMap.of(BiomeDesert.class, (Object)ImmutableSet.of((Object)new BlockSwapMapping(b -> b == Blocks.field_150364_r || b == Blocks.field_150363_s, s -> Blocks.field_150322_A.func_176223_P()), (Object)new BlockSwapMapping(b -> b == Blocks.field_150347_e, s -> Blocks.field_150322_A.func_176223_P()), (Object)new BlockSwapMapping(b -> b == Blocks.field_150344_f, s -> Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH)), (Object)new BlockSwapMapping(b -> b == Blocks.field_150476_ad, s -> Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))), (Object)new BlockSwapMapping(b -> b == Blocks.field_150446_ar, s -> Blocks.field_150372_bz.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))), (Object)new BlockSwapMapping(b -> b == Blocks.field_150351_n, s -> Blocks.field_150322_A.func_176223_P()), (Object[])new IBlockSwapMapping[0]), BiomeTaiga.class, (Object)ImmutableSet.of((Object)new BlockSwapMapping(b -> b == Blocks.field_150364_r || b == Blocks.field_150363_s, s -> Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))), (Object)new BlockSwapMapping(b -> b == Blocks.field_150344_f, s -> Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE)), (Object)new BlockSwapMapping(b -> b == Blocks.field_150476_ad, s -> Blocks.field_150485_bF.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))), (Object)new BlockSwapMapping(b -> b == Blocks.field_180407_aO, s -> Blocks.field_180408_aP.func_176223_P())), BiomeSavanna.class, (Object)ImmutableSet.of((Object)new BlockSwapMapping(b -> b == Blocks.field_150364_r || b == Blocks.field_150363_s, s -> Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, s.func_177229_b((IProperty)BlockLog.field_176299_a))), (Object)new BlockSwapMapping(b -> b == Blocks.field_150344_f, s -> Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA)), (Object)new BlockSwapMapping(b -> b == Blocks.field_150476_ad, s -> Blocks.field_150400_ck.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, s.func_177229_b((IProperty)BlockStairs.field_176309_a))), (Object)new BlockSwapMapping(b -> b == Blocks.field_150347_e, s -> Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y)), (Object)new BlockSwapMapping(b -> b == Blocks.field_180407_aO, s -> Blocks.field_180405_aT.func_176223_P())));

    public StructureBuilder(World world, StructureTemplate template, EnumFacing face, BlockPos pos) {
        this(world, template, face, pos, new StructureBB(pos, face, template));
    }

    public StructureBuilder(World world, StructureTemplate template, EnumFacing face, BlockPos buildKey, StructureBB bb) {
        this.world = world;
        this.biome = world.field_73011_w.getBiomeForCoords(buildKey);
        this.template = template;
        this.buildFace = face;
        this.bb = bb;
        this.buildOrigin = buildKey;
        this.destination = BlockPos.field_177992_a;
        this.curTempPos = Vec3i.field_177959_e;
        this.currentPriority = 0;
        this.turns = (face.func_176736_b() + 2) % 4;
        this.incrementDestination();
    }

    public StructureTemplate getTemplate() {
        return this.template;
    }

    public StructureBB getBoundingBox() {
        return this.bb;
    }

    protected StructureBuilder() {
        this.destination = BlockPos.field_177992_a;
        this.buildOrigin = BlockPos.field_177992_a;
    }

    public void instantConstruction() {
        while (!this.isFinished()) {
            Optional<TemplateRuleBlock> rule = this.template.getRuleAt(this.curTempPos);
            if (rule.isPresent()) {
                this.placeCurrentPosition(rule.get());
            } else if (this.currentPriority == 0) {
                this.placeAir();
            }
            this.increment();
        }
        this.setStateAgainForSpecialBlocks();
        this.updateNeighbors();
        this.changeBiome();
        this.placeEntities();
    }

    private void changeBiome() {
        ResourceLocation biomeRegistryName = this.template.getValidationSettings().getPropertyValue(StructureValidationProperties.BIOME_REPLACEMENT);
        if (!ForgeRegistries.BIOMES.containsKey(biomeRegistryName)) {
            return;
        }
        Biome replacementBiome = (Biome)ForgeRegistries.BIOMES.getValue(biomeRegistryName);
        BlockPos minPos = this.bb.min;
        BlockPos maxPos = new BlockPos(this.bb.max.func_177958_n(), this.bb.min.func_177956_o(), this.bb.max.func_177952_p());
        BlockPos.func_177980_a((BlockPos)minPos, (BlockPos)maxPos).forEach(pos -> {
            if (this.isTopBlockSolid(this.world, (BlockPos)pos)) {
                WorldTools.changeBiome(this.world, pos, replacementBiome);
            }
        });
    }

    private boolean isTopBlockSolid(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        BlockPos currentPos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (currentPos.func_177956_o() >= 0) {
            BlockPos posDown = currentPos.func_177977_b();
            IBlockState state = chunk.func_177435_g(posDown);
            if (state.func_185904_a() != Material.field_151579_a && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, posDown) && !state.func_177230_c().isFoliage((IBlockAccess)world, posDown)) {
                return !state.func_185904_a().func_76224_d();
            }
            currentPos = posDown;
        }
        return false;
    }

    private void updateNeighbors() {
        for (Map.Entry<BlockPos, IBlockState> entry : this.positionsToUpdate.entrySet()) {
            this.world.func_175722_b(entry.getKey(), entry.getValue().func_177230_c(), true);
            if (entry.getValue().func_185912_n()) {
                this.world.func_175666_e(entry.getKey(), entry.getValue().func_177230_c());
            }
            this.world.func_175684_a(entry.getKey(), entry.getValue().func_177230_c(), this.world.field_73012_v.nextInt(40));
        }
    }

    private void setStateAgainForSpecialBlocks() {
        for (Map.Entry<BlockPos, IBlockState> entry : this.statesToSetAgain.entrySet()) {
            this.world.func_180501_a(entry.getKey(), entry.getValue(), 2);
        }
    }

    private void placeEntities() {
        for (TemplateRuleEntityBase rule : this.template.getEntityRules().values()) {
            this.destination = BlockTools.rotateInArea(rule.getPosition(), this.template.getSize().func_177958_n(), this.template.getSize().func_177952_p(), this.turns).func_177971_a((Vec3i)this.bb.min);
            rule.handlePlacement(this.world, this.turns, this.destination, this);
        }
    }

    @Override
    public boolean placeBlock(BlockPos pos, IBlockState state, int priority) {
        boolean result;
        if (pos.func_177956_o() <= 0 || pos.func_177956_o() >= this.world.func_72800_K()) {
            return false;
        }
        IBlockState adjustedState = state;
        if (this.template.getValidationSettings().isBlockSwap()) {
            adjustedState = this.getBiomeSpecificBlockState(this.biome, state);
        }
        if (result = this.world.func_180501_a(pos, adjustedState, 2)) {
            if (DOUBLE_SET_BLOCKS.contains(adjustedState.func_177230_c())) {
                this.statesToSetAgain.put(pos, adjustedState);
            }
            if (state.func_185897_m()) {
                this.positionsToUpdate.put(pos, adjustedState);
            }
        }
        return result;
    }

    private void placeCurrentPosition(TemplateRule rule) {
        if (rule.shouldPlaceOnBuildPass(this.world, this.turns, this.destination, this.currentPriority)) {
            this.placeRule(rule);
        }
    }

    protected boolean increment() {
        if (this.isFinished) {
            return false;
        }
        if (this.incrementPosition()) {
            this.incrementDestination();
        } else {
            this.isFinished = true;
        }
        return !this.isFinished;
    }

    private void placeAir() {
        if (!this.template.getValidationSettings().isPreserveBlocks()) {
            this.world.func_175698_g(this.destination);
        }
    }

    void placeRule(TemplateRule rule) {
        if (this.destination.func_177956_o() <= 0) {
            return;
        }
        rule.handlePlacement(this.world, this.turns, this.destination, this);
    }

    void incrementDestination() {
        this.destination = BlockTools.rotateInArea(new BlockPos(this.curTempPos), this.template.getSize().func_177958_n(), this.template.getSize().func_177952_p(), this.turns).func_177971_a((Vec3i)this.bb.min);
    }

    private boolean incrementPosition() {
        int currentX = this.curTempPos.func_177958_n();
        int currentY = this.curTempPos.func_177956_o();
        int currentZ = this.curTempPos.func_177952_p();
        if (++currentX >= this.template.getSize().func_177958_n()) {
            currentX = 0;
            if (++currentZ >= this.template.getSize().func_177952_p()) {
                currentZ = 0;
                if (++currentY >= this.template.getSize().func_177956_o()) {
                    currentY = 0;
                    ++this.currentPriority;
                    if (this.currentPriority > this.maxPriority) {
                        this.currentPriority = 0;
                        return false;
                    }
                }
            }
        }
        this.curTempPos = new Vec3i(currentX, currentY, currentZ);
        return true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    float getTotalBlocks() {
        return (float)this.template.getSize().func_177958_n() * (float)this.template.getSize().func_177952_p() * (float)this.template.getSize().func_177956_o();
    }

    public float getPercentDoneWithPass() {
        float max = this.getTotalBlocks();
        float current = (float)this.curTempPos.func_177956_o() * (float)(this.template.getSize().func_177958_n() * this.template.getSize().func_177952_p());
        current += (float)(this.curTempPos.func_177952_p() * this.template.getSize().func_177958_n());
        return (current += (float)this.curTempPos.func_177958_n()) / max;
    }

    public int getPass() {
        return this.currentPriority;
    }

    public int getMaxPasses() {
        return this.maxPriority;
    }

    private IBlockState getBiomeSpecificBlockState(Biome biome, IBlockState originalBlockState) {
        BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(biome, originalBlockState);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getReplacement();
        }
        for (Map.Entry<Class, Set<IBlockSwapMapping>> entry : BIOME_SWAP_STATES.entrySet()) {
            if (!entry.getKey().isInstance(biome)) continue;
            for (IBlockSwapMapping mapping : entry.getValue()) {
                if (!mapping.matches(originalBlockState.func_177230_c())) continue;
                return mapping.swap(originalBlockState);
            }
        }
        return originalBlockState;
    }

    public EnumFacing getBuildFace() {
        return this.buildFace;
    }

    private static class BlockSwapMapping
    implements IBlockSwapMapping {
        private final Predicate<Block> blockMatcher;
        private final Function<IBlockState, IBlockState> doSwap;

        private BlockSwapMapping(Predicate<Block> blockMatcher, Function<IBlockState, IBlockState> doSwap) {
            this.blockMatcher = blockMatcher;
            this.doSwap = doSwap;
        }

        @Override
        public boolean matches(Block block) {
            return this.blockMatcher.test(block);
        }

        @Override
        public IBlockState swap(IBlockState state) {
            return this.doSwap.apply(state);
        }
    }

    private static interface IBlockSwapMapping {
        public boolean matches(Block var1);

        public IBlockState swap(IBlockState var1);
    }
}

