/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.SmoothingMatrixBuilder;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenDetailedLogHelper;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;
import net.shadowmage.ancientwarfare.structure.worldgen.stats.PlacementRejectionReason;
import net.shadowmage.ancientwarfare.structure.worldgen.stats.WorldGenStatistics;

public class StructureValidatorGround
extends StructureValidator {
    StructureValidatorGround() {
        super(StructureValidationType.GROUND);
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, EnumFacing face, StructureTemplate template) {
        IBlockState state = world.func_180495_p(new BlockPos(x, y - 1, z));
        Block block = state.func_177230_c();
        if (!AWStructureStatics.isValidTargetBlock(state)) {
            WorldGenDetailedLogHelper.log("Rejecting due to target block mismatch of: {} at: {},{},{}", () -> block.getRegistryName().toString(), () -> x, () -> y, () -> z);
            return false;
        }
        return true;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        int maxY;
        if (y - template.offset.func_177956_o() <= 0) {
            WorldGenStatistics.addStructurePlacementRejection(template.name, PlacementRejectionReason.TOO_SHALLOW_GROUND);
            WorldGenDetailedLogHelper.log("Ground isn't deep enough for the structure \"{}\" required: {}, found: {}", () -> template.name, () -> Math.abs(bb.min.func_177956_o()), () -> y);
            return false;
        }
        if (y < this.getMinGenerationHeight() || y > this.getMaxGenerationHeight()) {
            WorldGenStatistics.addStructurePlacementRejection(template.name, PlacementRejectionReason.NOT_WITHIN_Y_LIMIT);
            WorldGenDetailedLogHelper.log("Structure \"{}\" isn't within required Y level bounds of min {} and max {}", () -> template.name, this::getMinGenerationHeight, this::getMaxGenerationHeight);
            return false;
        }
        int minY = this.getMinY(template, bb);
        boolean ret = this.validateBorderBlocks(world, bb, minY, maxY = this.getMaxY(template, bb), false);
        if (!ret) {
            WorldGenStatistics.addStructurePlacementRejection(template.name, PlacementRejectionReason.INVALID_BORDER_HEIGHT_OR_BIOME);
        }
        return ret;
    }

    private int getMaxGenerationHeight() {
        return this.getPropertyValue(StructureValidationProperties.MAX_GENERATION_HEIGHT);
    }

    private int getMinGenerationHeight() {
        return this.getPropertyValue(StructureValidationProperties.MIN_GENERATION_HEIGHT);
    }

    @Override
    public void preGeneration(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureBB bb) {
        if (!this.isPreserveBlocks()) {
            this.smoothoutBorder(world, bb, face, template);
            this.clearAboveBB(world, template, bb);
            this.prePlacementUnderfill(world, bb);
        }
    }

    private void smoothoutBorder(World world, StructureBB bb, EnumFacing face, StructureTemplate template) {
        int borderSize = this.getBorderSize();
        int turns = (face.func_176736_b() + 2) % 4;
        if (borderSize > 0) {
            new SmoothingMatrixBuilder(world, bb, borderSize, bb.min.func_177956_o() + template.getOffset().func_177956_o() - 1, p -> this.getStateFromTemplate(template, bb, turns, (BlockPos)p)).build().apply(world, pos -> this.handleClearAction(world, (BlockPos)pos, template, bb));
        }
    }

    private IBlockState getStateFromTemplate(StructureTemplate template, StructureBB bb, int turns, BlockPos pos) {
        int xSize = turns % 2 == 0 ? template.getSize().func_177958_n() : template.getSize().func_177952_p();
        int zSize = turns % 2 == 0 ? template.getSize().func_177952_p() : template.getSize().func_177958_n();
        Optional<TemplateRuleBlock> rule = template.getRuleAt((Vec3i)BlockTools.rotateInArea(pos.func_177982_a(-bb.min.func_177958_n(), -bb.min.func_177956_o(), -bb.min.func_177952_p()), xSize, zSize, -turns));
        return rule.map(r -> r.getState(turns)).orElse(Blocks.field_150346_d.func_176223_P());
    }

    private void clearAboveBB(World world, StructureTemplate template, StructureBB bb) {
        BlockTools.getAllInBoxTopDown(bb.min.func_177982_a(0, bb.max.func_177956_o() - bb.min.func_177956_o() + 1, 0), bb.max.func_177982_a(0, 50 + this.getMaxLeveling(), 0)).forEach(pos -> this.handleClearAction(world, (BlockPos)pos, template, bb));
    }

    @Override
    public void postGeneration(World world, BlockPos origin, StructureBB bb, StructureTemplate template) {
        if (world.func_175708_f(origin.func_177984_a(), false)) {
            WorldStructureGenerator.sprinkleSnow(world, bb, this.getBorderSize());
        }
    }
}

