/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class StructureValidatorUnderground
extends StructureValidator {
    public StructureValidatorUnderground() {
        super(StructureValidationType.UNDERGROUND);
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, EnumFacing face, StructureTemplate template) {
        int tHeight = template.getSize().func_177956_o() - template.getOffset().func_177956_o();
        int low = this.getMinGenerationDepth() + tHeight + this.getMinOverfill();
        return WorldStructureGenerator.getTargetY(world, x, z, true) > low;
    }

    @Override
    public int getAdjustedSpawnY(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        int range = this.getMaxGenerationDepth() - this.getMinGenerationDepth() + 1;
        int tHeight = template.getSize().func_177956_o() - template.getOffset().func_177956_o();
        return WorldStructureGenerator.getTargetY(world, x, z, true) - this.getMinOverfill() - world.field_73012_v.nextInt(range) - tHeight;
    }

    private int getMaxGenerationDepth() {
        return this.getPropertyValue(StructureValidationProperties.MAX_GENERATION_DEPTH);
    }

    private int getMinGenerationDepth() {
        return this.getPropertyValue(StructureValidationProperties.MIN_GENERATION_DEPTH);
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        int minY = bb.min.func_177956_o() + template.getOffset().func_177956_o() + this.getMinOverfill();
        for (int bx = bb.min.func_177958_n(); bx <= bb.max.func_177958_n(); ++bx) {
            for (int bz = bb.min.func_177952_p(); bz <= bb.max.func_177952_p(); ++bz) {
                int topBlockY = WorldStructureGenerator.getTargetY(world, bx, bz, true);
                if (topBlockY > minY) continue;
                return false;
            }
        }
        return true;
    }

    private int getMinOverfill() {
        return this.getPropertyValue(StructureValidationProperties.MIN_OVERFILL);
    }

    @Override
    public void preGeneration(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureBB bb) {
    }
}

