/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.border;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.HorizontalCoords;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.BorderPoint;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.PointType;

public class BorderMatrix {
    private BorderPoint[][] borderPoints;
    private final int fullXSize;
    private final int fullZSize;
    private Map<PointType, Set<BorderPoint>> typePoints = new HashMap<PointType, Set<BorderPoint>>();

    private BorderMatrix(int fullXSize, int fullZSize) {
        this.fullXSize = fullXSize;
        this.fullZSize = fullZSize;
    }

    public BorderMatrix(int xSize, int zSize, int borderSize) {
        this(xSize + 2 * borderSize + 4, zSize + 2 * borderSize + 4);
        this.borderPoints = this.initMatrix(this.fullXSize, this.fullZSize);
    }

    public Optional<BorderPoint> getPoint(int x, int z) {
        if (this.borderPoints.length == 0 || x < 0 || x >= this.borderPoints.length || z < 0 || z >= this.borderPoints[0].length) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.borderPoints[x][z]);
    }

    Optional<BorderPoint> getPoint(HorizontalCoords coords) {
        return this.getPoint(coords.getX(), coords.getZ());
    }

    private BorderPoint[][] initMatrix(int fullXSize, int fullZSize) {
        BorderPoint[][] ret = new BorderPoint[fullXSize][];
        for (int x = 0; x < fullXSize; ++x) {
            ret[x] = new BorderPoint[fullZSize];
        }
        return ret;
    }

    public boolean isEmpty(HorizontalCoords point) {
        return !this.getPoint(point).isPresent();
    }

    public BorderPoint addPoint(int x, int z, PointType type) {
        BorderPoint point = new BorderPoint(x, z, type);
        this.addPoint(point);
        return point;
    }

    private void addTypePoint(PointType type, BorderPoint point) {
        if (!this.typePoints.containsKey((Object)type)) {
            this.typePoints.put(type, new HashSet());
        }
        this.typePoints.get((Object)type).add(point);
    }

    public void addPoint(HorizontalCoords coords, PointType type) {
        this.addPoint(coords.getX(), coords.getZ(), type);
    }

    public int getFullXSize() {
        return this.fullXSize;
    }

    public int getFullZSize() {
        return this.fullZSize;
    }

    public Set<BorderPoint> getPointsOfType(PointType type) {
        return this.typePoints.get((Object)type);
    }

    public void addPoint(BorderPoint point) {
        this.borderPoints[point.getX()][point.getZ()] = point;
        this.addTypePoint(point.getType(), point);
    }
}

