/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.border;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.BorderMatrix;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.BorderPointFiller;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.HorizontalCoords;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.BorderPoint;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.PointType;

public class BorderMatrixBuilder {
    private final BorderMatrix borderMatrix;
    private final int borderSize;
    private final int xSize;
    private final int zSize;

    public BorderMatrixBuilder(int xSize, int zSize, int borderSize) {
        this.xSize = xSize;
        this.zSize = zSize;
        this.borderMatrix = new BorderMatrix(xSize, zSize, borderSize);
        this.borderSize = borderSize;
    }

    public BorderMatrix build() {
        this.inializePoints();
        return this.borderMatrix;
    }

    private void inializePoints() {
        this.addStructureBorder();
        HorizontalCoords fillStartPoint = new HorizontalCoords(this.borderSize + 2 + this.xSize / 2, this.borderSize + 2 + this.zSize / 2);
        if (this.xSize > 2 && this.zSize > 2) {
            this.fillStructureInside(fillStartPoint);
        }
        new BorderPointFiller(this.borderMatrix, this.borderSize).fillInBorderPointsToSmooth(this.getFirstPointToSmooth());
        this.surroundWith(PointType.SMOOTHED_BORDER, PointType.OUTER_BORDER);
        this.surroundWith(PointType.OUTER_BORDER, PointType.REFERENCE_POINT);
        this.setOuterBorderAndReferencePoints();
    }

    private HorizontalCoords getFirstPointToSmooth() {
        Set<BorderPoint> borderPoints = this.borderMatrix.getPointsOfType(PointType.STRUCTURE_BORDER);
        BorderPoint firstBorderPoint = borderPoints.iterator().next();
        HorizontalCoords firstCoords = new HorizontalCoords(firstBorderPoint.getX(), firstBorderPoint.getZ());
        for (HorizontalCoords offset : HorizontalCoords.ADJACENT_OFFSETS) {
            HorizontalCoords point = firstCoords.add(offset);
            if (!this.borderMatrix.isEmpty(point)) continue;
            return point;
        }
        throw new IllegalArgumentException("Incorrect state of matrix or structure data, structure border point should always have snmoothed point on one side");
    }

    private void addStructureBorder() {
        this.addRingPoints(new HorizontalCoords(2 + this.borderSize, 2 + this.borderSize), new HorizontalCoords(this.borderMatrix.getFullXSize() - 2 - this.borderSize - 1, this.borderMatrix.getFullZSize() - 2 - this.borderSize - 1), PointType.STRUCTURE_BORDER);
    }

    private void addRingPoints(HorizontalCoords min, HorizontalCoords max, PointType type) {
        for (int x = min.getX(); x <= max.getX(); ++x) {
            this.borderMatrix.addPoint(x, min.getZ(), type);
            this.borderMatrix.addPoint(x, max.getZ(), type);
        }
        for (int z = min.getZ() + 1; z <= max.getZ() - 1; ++z) {
            this.borderMatrix.addPoint(min.getX(), z, type);
            this.borderMatrix.addPoint(max.getX(), z, type);
        }
    }

    private void fillStructureInside(HorizontalCoords fillStartPoint) {
        HashSet<HorizontalCoords> pointsToFill = new HashSet<HorizontalCoords>();
        pointsToFill.add(fillStartPoint);
        while (!pointsToFill.isEmpty()) {
            Iterator it = pointsToFill.iterator();
            HorizontalCoords nextToFill = (HorizontalCoords)it.next();
            it.remove();
            this.borderMatrix.addPoint(nextToFill.getX(), nextToFill.getZ(), PointType.STRUCTURE_INSIDE);
            this.addAdjacentIfEmpty(pointsToFill, new HorizontalCoords(nextToFill.getX() + 1, nextToFill.getZ()));
            this.addAdjacentIfEmpty(pointsToFill, new HorizontalCoords(nextToFill.getX() - 1, nextToFill.getZ()));
            this.addAdjacentIfEmpty(pointsToFill, new HorizontalCoords(nextToFill.getX(), nextToFill.getZ() + 1));
            this.addAdjacentIfEmpty(pointsToFill, new HorizontalCoords(nextToFill.getX(), nextToFill.getZ() - 1));
        }
    }

    private void addAdjacentIfEmpty(Set<HorizontalCoords> pointsToFill, HorizontalCoords adjacent) {
        if (this.borderMatrix.isEmpty(adjacent)) {
            pointsToFill.add(adjacent);
        }
    }

    private void surroundWith(PointType innerType, PointType outerType) {
        this.addPointsNextTo(innerType, outerType);
        this.fillSpacesInType(innerType, outerType);
    }

    private void addPointsNextTo(PointType innerType, PointType outerType) {
        for (BorderPoint point : this.borderMatrix.getPointsOfType(innerType)) {
            if (point.getDistanceToBorder() < (double)this.borderSize) continue;
            HorizontalCoords current = new HorizontalCoords(point.getX(), point.getZ());
            for (HorizontalCoords offset : HorizontalCoords.ADJACENT_OFFSETS) {
                HorizontalCoords adjacent = current.add(offset);
                if (!this.borderMatrix.isEmpty(adjacent)) continue;
                this.borderMatrix.addPoint(adjacent, outerType);
                this.borderMatrix.getPoint(adjacent).ifPresent(p -> this.updateBorderCoordsIfCloser((BorderPoint)p, point.getStructureBorderDistance() + 1, point.getClosestBorderPoint()));
            }
        }
    }

    private boolean updateBorderCoordsIfCloser(BorderPoint point, int distance, BorderPoint borderPoint) {
        return point.updateBorderCoordsIfCloser(distance, borderPoint);
    }

    private void fillSpacesInType(PointType innerType, PointType outerType) {
        HashSet<BorderPoint> pointsToFill = new HashSet<BorderPoint>();
        HorizontalCoords innerTypePointOffset = null;
        for (BorderPoint point : this.borderMatrix.getPointsOfType(outerType)) {
            HorizontalCoords adjacent;
            int innerTypeCount = 0;
            HashSet<HorizontalCoords> empty = new HashSet<HorizontalCoords>();
            HorizontalCoords current = new HorizontalCoords(point.getX(), point.getZ());
            for (HorizontalCoords offset : HorizontalCoords.ADJACENT_OFFSETS) {
                adjacent = current.add(offset);
                Optional<BorderPoint> adjPoint = this.borderMatrix.getPoint(adjacent);
                if (adjPoint.isPresent()) {
                    BorderPoint adjacentPoint = adjPoint.get();
                    if (adjacentPoint.getType() != innerType) continue;
                    innerTypePointOffset = offset;
                    ++innerTypeCount;
                    continue;
                }
                empty.add(adjacent);
            }
            if (innerTypeCount > 1) {
                for (HorizontalCoords coord : empty) {
                    this.addPointToFill(outerType, pointsToFill, point, coord);
                }
                continue;
            }
            if (innerTypePointOffset == null) continue;
            for (HorizontalCoords coords : innerTypePointOffset.getPerpendicular()) {
                adjacent = current.add(coords);
                if (!this.borderMatrix.isEmpty(adjacent)) continue;
                this.addPointToFill(outerType, pointsToFill, point, adjacent);
            }
        }
        pointsToFill.forEach(this.borderMatrix::addPoint);
    }

    private void addPointToFill(PointType outerType, Set<BorderPoint> pointsToFill, BorderPoint point, HorizontalCoords coord) {
        int x = coord.getX();
        int z = coord.getZ();
        BorderPoint newPoint = new BorderPoint(x, z, outerType);
        this.updateBorderCoordsIfCloser(newPoint, point.getStructureBorderDistance() + 1, point.getClosestBorderPoint());
        pointsToFill.add(newPoint);
    }

    private void setOuterBorderAndReferencePoints() {
        for (BorderPoint outerBorderPoint : this.borderMatrix.getPointsOfType(PointType.OUTER_BORDER)) {
            Set<BorderPoint> borderPointsToSmooth = this.getPointsToClosestStructureBorder(outerBorderPoint);
            BorderPoint referencePoint = this.getReferencePoint(outerBorderPoint);
            for (BorderPoint pointToSmooth : borderPointsToSmooth) {
                pointToSmooth.setOuterBorderAndReferencePoint(outerBorderPoint, referencePoint);
            }
        }
    }

    private BorderPoint getReferencePoint(BorderPoint outerBorderPoint) {
        BorderPoint referencePoint;
        BorderPoint structureBorderPoint = outerBorderPoint.getClosestBorderPoint();
        int xDiff = outerBorderPoint.getX() - structureBorderPoint.getX();
        int zDiff = outerBorderPoint.getZ() - structureBorderPoint.getZ();
        int higherValue = Math.max(Math.abs(xDiff), Math.abs(zDiff));
        float incrementX = (float)xDiff / (float)higherValue;
        float incrementZ = (float)zDiff / (float)higherValue;
        float currentX = (float)outerBorderPoint.getX() + incrementX;
        float currentZ = (float)outerBorderPoint.getZ() + incrementZ;
        do {
            Optional<BorderPoint> refPoint;
            if (!(refPoint = this.borderMatrix.getPoint((int)currentX, (int)currentZ)).isPresent() || refPoint.get().getType() != PointType.REFERENCE_POINT && refPoint.get().getType() != PointType.OUTER_BORDER) {
                throw new IllegalArgumentException("point mismatch, there's supposed to be a reference point here or at most another border");
            }
            referencePoint = refPoint.get();
            currentX += incrementX;
            currentZ += incrementZ;
        } while (referencePoint.getType() != PointType.REFERENCE_POINT);
        return referencePoint;
    }

    private Set<BorderPoint> getPointsToClosestStructureBorder(BorderPoint outerBorderPoint) {
        BorderPoint structureBorderPoint = outerBorderPoint.getClosestBorderPoint();
        int xDiff = structureBorderPoint.getX() - outerBorderPoint.getX();
        int zDiff = structureBorderPoint.getZ() - outerBorderPoint.getZ();
        int totalSteps = Math.max(Math.abs(xDiff), Math.abs(zDiff));
        float incrementX = (float)xDiff / (float)totalSteps;
        float incrementZ = (float)zDiff / (float)totalSteps;
        HashSet<BorderPoint> points = new HashSet<BorderPoint>();
        for (int step = 1; step < totalSteps; ++step) {
            this.borderMatrix.getPoint(outerBorderPoint.getX() + (int)((float)step * incrementX), outerBorderPoint.getZ() + (int)((float)step * incrementZ)).ifPresent(smoothPoint -> {
                if (!smoothPoint.hasOuterBorderPointSet()) {
                    points.add((BorderPoint)smoothPoint);
                }
            });
        }
        return points;
    }
}

