/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.border.points;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.PointType;

public class SmoothingPoint {
    private PointType type;
    private int x;
    private int z;
    private BlockPos worldPos;
    private BlockPos smoothedPos;
    private boolean smoothedPosSet = false;
    private IBlockState blockState;
    private boolean useStateForBlending = false;
    private SmoothingPoint outerBorderPoint = null;
    private SmoothingPoint referencePoint;
    private SmoothingPoint closestBorderPoint;
    private int structureBorderDistance;
    private int waterLevel = 0;

    public SmoothingPoint(int x, int z, BlockPos worldPos, PointType type) {
        this.x = x;
        this.z = z;
        this.worldPos = worldPos;
        this.smoothedPos = worldPos;
        this.type = type;
    }

    public void setBlockState(IBlockState blockState) {
        this.blockState = blockState;
        this.useStateForBlending = true;
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public boolean useStateForBlending() {
        return this.useStateForBlending;
    }

    public BlockPos getSmoothedPos() {
        return this.smoothedPos;
    }

    public BlockPos getWorldPos() {
        return this.worldPos;
    }

    public boolean hasSmoothedPosSet() {
        return this.smoothedPosSet;
    }

    public void setSmoothedPos(BlockPos smoothedPos) {
        this.smoothedPos = smoothedPos;
        this.smoothedPosSet = true;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getStructureBorderDistance() {
        return this.structureBorderDistance;
    }

    public void setStructureBorder(SmoothingPoint closestBorderPoint, int structureBorderDistance) {
        this.closestBorderPoint = closestBorderPoint;
        this.structureBorderDistance = structureBorderDistance;
    }

    public void setOuterBorderAndReferencePoint(SmoothingPoint outerBorder, SmoothingPoint referencePoint) {
        this.outerBorderPoint = outerBorder;
        this.referencePoint = referencePoint;
    }

    public SmoothingPoint getReferencePoint() {
        return this.referencePoint;
    }

    public SmoothingPoint getOuterBorderPoint() {
        return this.outerBorderPoint;
    }

    public SmoothingPoint getClosestBorderPoint() {
        return this.closestBorderPoint;
    }

    public PointType getType() {
        return this.type;
    }

    public void setWaterLevel(int waterLevel) {
        this.waterLevel = waterLevel;
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }
}

