/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FixResult<T> {
    private final T data;
    private final boolean modified;
    private final Set<String> fixesApplied;

    private FixResult(T data, boolean modified, Set<String> fixesApplied) {
        this.data = data;
        this.modified = modified;
        this.fixesApplied = fixesApplied;
    }

    public Set<String> getFixesApplied() {
        return this.fixesApplied;
    }

    public boolean isModified() {
        return this.modified;
    }

    public T getData() {
        return this.data;
    }

    public static class Builder<T> {
        private boolean modified = false;
        private Set<String> fixesApplied = new HashSet<String>();

        public <U> U updateAndGetData(FixResult<U> otherResult) {
            this.modified |= otherResult.isModified();
            this.fixesApplied.addAll(otherResult.getFixesApplied());
            return otherResult.getData();
        }

        public FixResult<T> build(T data) {
            return new FixResult(data, this.modified, this.fixesApplied);
        }
    }

    public static class NotModified<U>
    extends FixResult<U> {
        public NotModified(U data) {
            super(data, false, Collections.emptySet());
        }
    }

    public static class Modified<U>
    extends FixResult<U> {
        public Modified(U data, String fixName) {
            super(data, true, Collections.singleton(fixName));
        }
    }
}

