/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes.fixers;

import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleDataFixerBase;

public abstract class TileRuleDataFixer
extends RuleDataFixerBase {
    private static final String TE_DATA_TAG = "teData";

    @Override
    protected FixResult<String> fixData(String ruleName, String data) {
        NBTTagCompound tag;
        try {
            tag = JsonToNBT.func_180713_a((String)data.substring("JSON:".length()));
        }
        catch (NBTException e) {
            AncientWarfareStructure.LOG.error("Error getting nbt from json string: ", (Throwable)e);
            return new FixResult.NotModified<String>(data);
        }
        return this.fixJSONData(data, tag);
    }

    protected FixResult<String> fixJSONData(String data, NBTTagCompound tag) {
        if (tag.func_74764_b(TE_DATA_TAG)) {
            tag.func_74782_a(TE_DATA_TAG, (NBTBase)this.fixRuleCompoundTag(tag.func_74775_l(TE_DATA_TAG)));
            return new FixResult.Modified<String>("JSON:" + tag.toString(), this.getFixerName());
        }
        return new FixResult.NotModified<String>(data);
    }

    protected abstract String getFixerName();

    protected abstract NBTTagCompound fixRuleCompoundTag(NBTTagCompound var1);
}

