/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.json;

import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleDataFixerBase;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.json.Json;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.json.JsonTagReader;

public class JsonSimplificationFixer
extends RuleDataFixerBase {
    @Override
    public StructureTemplate.Version getVersion() {
        return new StructureTemplate.Version(2, 3);
    }

    @Override
    public boolean isForRule(String ruleName) {
        return true;
    }

    @Override
    protected FixResult<String> fixData(String ruleName, String data) {
        if (!Json.isSerializedJSON(data)) {
            return new FixResult.NotModified<String>(data);
        }
        NBTTagCompound tag = JsonTagReader.parseTagCompound(data);
        return new FixResult.Modified<String>("JSON:" + tag.toString(), "JsonSimplificationFixer");
    }
}

