/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.util.Tuple;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.shadowmage.ancientwarfare.core.util.FileUtils;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateParser;
import net.shadowmage.ancientwarfare.structure.template.save.TemplateExporter;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateManager;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateParser;
import net.shadowmage.ancientwarfare.structure.worldgen.TerritoryManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.util.Supplier;

public class TemplateLoader {
    private static final String DEFAULT_TEMPLATE_DIRECTORY = "assets/ancientwarfare/template";
    public static final String OUTPUT_DIRECTORY = "config/ancientwarfare/structures/export/";
    public static final String INCLUDE_DIRECTORY = "config/ancientwarfare/structures/included/";
    private List<TownTemplate> parsedTownTemplates = new ArrayList<TownTemplate>();
    public static final TemplateLoader INSTANCE = new TemplateLoader();

    private TemplateLoader() {
    }

    public void initializeAndExportDefaults() {
        File existTest = new File(OUTPUT_DIRECTORY);
        if (!existTest.exists()) {
            existTest.mkdirs();
        }
        if (!(existTest = new File(INCLUDE_DIRECTORY)).exists()) {
            existTest.mkdirs();
        }
    }

    public void loadTemplates() {
        int loadedCount = 0;
        if (AWStructureStatics.loadDefaultPack) {
            loadedCount += this.loadTemplatesFromSource(Loader.instance().activeModContainer().getSource(), DEFAULT_TEMPLATE_DIRECTORY, false);
        }
        AncientWarfareStructure.LOG.info("Loaded {} structure(s)", (Object)(loadedCount += this.loadTemplatesFromSource(new File(INCLUDE_DIRECTORY), "", true)));
        this.validateTownTemplates();
    }

    public void reloadAll() {
        StructureTemplateManager.removeAll();
        TownTemplateManager.INSTANCE.removeAll();
        this.loadTemplates();
    }

    private int loadTemplatesFromSource(File source, String base, boolean saveFixedTemplate) {
        TreeMap loaded = new TreeMap();
        FileUtils.findFiles(source, base, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            String extension = FilenameUtils.getExtension((String)file.toString());
            if (extension.equals(AWStructureStatics.townTemplateExtension) || extension.equals(AWStructureStatics.templateExtension)) {
                try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.ISO_8859_1);){
                    List<String> lines = reader.lines().filter(l -> !l.startsWith("#")).collect(Collectors.toList());
                    if (extension.equals(AWStructureStatics.townTemplateExtension)) {
                        this.loadTownTemplate(lines);
                    } else {
                        this.loadTemplate((Path)file, lines, saveFixedTemplate).ifPresent(res -> {
                            if (!loaded.containsKey(res.func_76341_a())) {
                                loaded.put(res.func_76341_a(), new ArrayList());
                            }
                            ((List)loaded.get(res.func_76341_a())).add(res.func_76340_b());
                        });
                    }
                }
                catch (IOException e) {
                    AncientWarfareStructure.LOG.error("Couldn't read template data {} from {}", (Object)name, file, (Object)e);
                }
                catch (UncheckedIOException e) {
                    AncientWarfareStructure.LOG.error("Couldn't read template data {} from {} - most probable cause is incorrect encoding, should be ISO-8859-1", (Object)name, file, (Object)e);
                }
            }
        });
        for (Map.Entry entry : loaded.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = entry::getKey;
            supplierArray[1] = () -> String.join((CharSequence)"\n", (Iterable)entry.getValue());
            AncientWarfareStructure.LOG.error("Template name \"{}\" is present in multiple locations only one of them was used:\n{}", supplierArray);
        }
        return loaded.size();
    }

    private Optional<Tuple<String, String>> loadTemplate(Path fileName, List<String> lines, boolean saveFixedTemplate) {
        Optional<FixResult<StructureTemplate>> result = TemplateParser.INSTANCE.parseTemplate(fileName.toString(), lines);
        if (!result.isPresent()) {
            return Optional.empty();
        }
        FixResult<StructureTemplate> loadedTemplate = result.get();
        StructureTemplate template = loadedTemplate.getData();
        if (loadedTemplate.isModified()) {
            AncientWarfareStructure.LOG.info("Template {} had following fixes applied: {}", new Supplier[]{() -> fileName, () -> String.join((CharSequence)", ", loadedTemplate.getFixesApplied())});
        }
        if (saveFixedTemplate && loadedTemplate.isModified()) {
            TemplateExporter.exportTo(template, fileName.getParent().toFile());
            AncientWarfareStructure.LOG.info("Changes saved to {}", (Object)fileName);
        }
        AncientWarfareStructure.LOG.info("Loaded Structure Template: [{}] WorldGen: {}  Survival: {}", (Object)template.name, (Object)template.getValidationSettings().isWorldGenEnabled(), (Object)template.getValidationSettings().isSurvival());
        StructureTemplateManager.addTemplate(template);
        return Optional.of(new Tuple((Object)template.name, (Object)fileName.toString()));
    }

    private void loadTownTemplate(List<String> lines) {
        TownTemplateParser.parseTemplate(lines).ifPresent(t -> {
            this.parsedTownTemplates.add((TownTemplate)t);
            this.registerTerritoryBiomes((TownTemplate)t);
        });
    }

    private void registerTerritoryBiomes(TownTemplate t) {
        if (t.isBiomeWhiteList()) {
            t.getBiomeList().forEach(biomeName -> TerritoryManager.addTerritoryInBiome(t.getTerritoryName(), biomeName));
        } else {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null) continue;
                String biomeName2 = biome.getRegistryName().toString();
                if (t.getBiomeList().contains(biomeName2)) continue;
                TerritoryManager.addTerritoryInBiome(t.getTerritoryName(), biomeName2);
            }
        }
    }

    private void validateTownTemplates() {
        if (!this.parsedTownTemplates.isEmpty()) {
            AncientWarfareStructure.LOG.info("Loading Town Templates: ");
            for (TownTemplate t : this.parsedTownTemplates) {
                AncientWarfareStructure.LOG.info("Loading town template: {}", (Object)t.getTownTypeName());
                t.validateStructureEntries();
                TownTemplateManager.INSTANCE.loadTemplate(t);
            }
            AncientWarfareStructure.LOG.info("Loaded : {} Town Templates.", (Object)this.parsedTownTemplates.size());
        }
    }
}

