/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IBoundedSite;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;

public class TemplateRuleRotatable
extends TemplateRuleBlock {
    private static final String TE_DATA_TAG = "teData";
    public static final String PLUGIN_NAME = "rotatable";
    private EnumFacing orientation;
    private BlockPos p1;
    private BlockPos p2;
    NBTTagCompound tag;

    public TemplateRuleRotatable(World world, BlockPos pos, IBlockState state, int turns) {
        super(state, turns);
        Optional<TileEntity> te = WorldTools.getTile((IBlockAccess)world, pos);
        if (te.isPresent()) {
            TileEntity worksite = te.get();
            EnumFacing o = ((BlockRotationHandler.IRotatableTile)worksite).getPrimaryFacing();
            if (o.func_176740_k() != EnumFacing.Axis.Y) {
                for (int i = 0; i < turns; ++i) {
                    o = o.func_176746_e();
                }
            }
            this.orientation = o;
            if (worksite instanceof IBoundedSite && ((IBoundedSite)worksite).hasWorkBounds()) {
                this.p1 = BlockTools.rotateAroundOrigin(((IBoundedSite)worksite).getWorkBoundsMin().func_177982_a(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p()), turns);
                this.p2 = BlockTools.rotateAroundOrigin(((IBoundedSite)worksite).getWorkBoundsMax().func_177982_a(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p()), turns);
            }
            this.tag = new NBTTagCompound();
            worksite.func_189515_b(this.tag);
        }
    }

    public TemplateRuleRotatable() {
    }

    @Override
    public boolean shouldReuseRule(World world, IBlockState state, int turns, BlockPos pos) {
        return false;
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        Optional<TileEntity> te;
        if (world.func_180501_a(pos, this.state, 2) && (te = WorldTools.getTile((IBlockAccess)world, pos)).isPresent()) {
            TileEntity worksite = te.get();
            this.tag.func_74768_a("x", pos.func_177958_n());
            this.tag.func_74768_a("y", pos.func_177956_o());
            this.tag.func_74768_a("z", pos.func_177952_p());
            worksite.func_145839_a(this.tag);
            EnumFacing o = this.orientation;
            if (o.func_176740_k() != EnumFacing.Axis.Y) {
                for (int i = 0; i < turns; ++i) {
                    o = o.func_176746_e();
                }
            }
            ((BlockRotationHandler.IRotatableTile)worksite).setPrimaryFacing(o);
            if (worksite instanceof IBoundedSite && this.p1 != null && this.p2 != null) {
                BlockPos pos1 = BlockTools.rotateAroundOrigin(this.p1, turns).func_177971_a((Vec3i)pos);
                BlockPos pos2 = BlockTools.rotateAroundOrigin(this.p2, turns).func_177971_a((Vec3i)pos);
                ((IBoundedSite)worksite).setBounds(pos1, pos2);
            }
            BlockTools.notifyBlockUpdate(world, pos);
        }
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.orientation = EnumFacing.values()[tag.func_74762_e("orientation")];
        if (tag.func_74764_b(TE_DATA_TAG)) {
            this.tag = tag.func_74775_l(TE_DATA_TAG);
        }
        if (tag.func_74764_b("pos1")) {
            this.p1 = NBTHelper.readBlockPosFromNBT(tag.func_74775_l("pos1"));
        }
        if (tag.func_74764_b("pos2")) {
            this.p2 = NBTHelper.readBlockPosFromNBT(tag.func_74775_l("pos2"));
        }
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74768_a("orientation", this.orientation.ordinal());
        if (this.p1 != null) {
            tag.func_74782_a("pos1", (NBTBase)NBTHelper.writeBlockPosToNBT(new NBTTagCompound(), this.p1));
        }
        if (this.p2 != null) {
            tag.func_74782_a("pos2", (NBTBase)NBTHelper.writeBlockPosToNBT(new NBTTagCompound(), this.p2));
        }
        if (this.tag != null) {
            tag.func_74782_a(TE_DATA_TAG, (NBTBase)this.tag);
        }
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, BlockPos pos, int buildPass) {
        return buildPass == 0;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }
}

