/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import java.util.stream.StreamSupport;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleBlockTile;

public class TemplateRuleVanillaSpawner
extends TemplateRuleBlockTile<TileEntityMobSpawner> {
    public static final String PLUGIN_NAME = "vanillaSpawner";
    private static final String SPAWN_DATA_TAG = "SpawnData";
    private static final String TAGS_TAG = "Tags";

    public TemplateRuleVanillaSpawner(World world, BlockPos pos, IBlockState state, int turns) {
        super(world, pos, state, turns);
        if (this.tag.func_74764_b(SPAWN_DATA_TAG)) {
            NBTTagCompound compound = this.tag.func_74775_l(SPAWN_DATA_TAG);
            compound.func_74782_a(TAGS_TAG, (NBTBase)this.getTags(compound));
        }
        if (this.tag.func_74764_b("SpawnPotentials")) {
            NBTTagList spawnPotentials = this.tag.func_150295_c("SpawnPotentials", 10);
            for (NBTBase tag : spawnPotentials) {
                NBTTagCompound compound = (NBTTagCompound)tag;
                compound.func_74782_a(TAGS_TAG, (NBTBase)this.getTags(compound));
            }
        }
    }

    private NBTTagList getTags(NBTTagCompound compound) {
        NBTTagList tags;
        NBTTagList nBTTagList = tags = compound.func_74764_b(TAGS_TAG) ? compound.func_150295_c(TAGS_TAG, 8) : new NBTTagList();
        if (!this.hasNoSpawnPreventionTag(tags)) {
            tags.func_74742_a((NBTBase)new NBTTagString("noSpawnPrevention"));
        }
        return tags;
    }

    private boolean hasNoSpawnPreventionTag(NBTTagList tags) {
        return StreamSupport.stream(tags.spliterator(), false).anyMatch(n -> ((NBTTagString)n).func_150285_a_().equals("noSpawnPrevention"));
    }

    public TemplateRuleVanillaSpawner() {
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }
}

