/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.entityrules;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntityBase;

public class TemplateRuleEntity<T extends Entity>
extends TemplateRuleEntityBase {
    public static final String PLUGIN_NAME = "entity";
    private NBTTagCompound tag;
    public ResourceLocation registryName;
    public float xOffset;
    public float zOffset;
    public float yOffset;
    public float rotation;

    public TemplateRuleEntity() {
    }

    public TemplateRuleEntity(World world, T entity, int turns, int x, int y, int z) {
        this.registryName = EntityList.func_191301_a(entity);
        this.rotation = (((Entity)entity).field_70177_z + 90.0f * (float)turns) % 360.0f;
        float x1 = (float)(((Entity)entity).field_70165_t % 1.0);
        float z1 = (float)(((Entity)entity).field_70161_v % 1.0);
        if (x1 < 0.0f) {
            x1 += 1.0f;
        }
        if (z1 < 0.0f) {
            z1 += 1.0f;
        }
        this.xOffset = BlockTools.rotateFloatX(x1, z1, turns);
        this.zOffset = BlockTools.rotateFloatZ(x1, z1, turns);
        this.yOffset = (float)(((Entity)entity).field_70163_u % 1.0);
        this.tag = entity.func_189511_e(new NBTTagCompound());
        this.tag.func_82580_o("UUIDMost");
        this.tag.func_82580_o("UUIDLeast");
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        this.createEntity(world, turns, pos).ifPresent(arg_0 -> ((World)world).func_72838_d(arg_0));
    }

    private Optional<T> createEntity(World world, int turns, BlockPos pos) {
        Entity e = EntityList.func_188429_b((ResourceLocation)this.registryName, (World)world);
        if (e == null) {
            AncientWarfareStructure.LOG.debug("Could not create entity for name: {} Entity skipped during structure creation.", (Object)this.registryName);
            return Optional.empty();
        }
        NBTTagCompound entityNBT = this.getEntityNBT(pos, turns);
        this.removeNonExistentAttributes(e, entityNBT);
        e.func_70020_e(entityNBT);
        this.updateEntityOnPlacement(turns, pos, e);
        this.addNoSpawnPreventionTag(e);
        return Optional.of(e);
    }

    private void removeNonExistentAttributes(T e, NBTTagCompound entityNBT) {
        if (e instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)e;
            NBTTagList attributes = entityNBT.func_150295_c("Attributes", 10);
            Iterator it = attributes.iterator();
            while (it.hasNext()) {
                NBTBase nbt = (NBTBase)it.next();
                if (nbt.func_74732_a() != 10) continue;
                NBTTagCompound attribute = (NBTTagCompound)nbt;
                if (living.func_110140_aT().func_111152_a(attribute.func_74779_i("Name")) != null) continue;
                it.remove();
            }
        }
    }

    private void addNoSpawnPreventionTag(T e) {
        if (IMob.field_82192_a.apply(e)) {
            e.func_184216_O().add("noSpawnPrevention");
        }
    }

    protected NBTTagCompound getEntityNBT(BlockPos pos, int turns) {
        return this.tag;
    }

    protected void updateEntityOnPlacement(int turns, BlockPos pos, T e) {
        e.func_70080_a((double)((float)pos.func_177958_n() + BlockTools.rotateFloatX(this.xOffset, this.zOffset, turns)), (double)((float)pos.func_177956_o() + this.yOffset), (double)((float)pos.func_177952_p() + BlockTools.rotateFloatZ(this.xOffset, this.zOffset, turns)), (this.rotation + 90.0f * (float)turns) % 360.0f, 0.0f);
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74778_a("mobID", this.registryName.toString());
        tag.func_74776_a("xOffset", this.xOffset);
        tag.func_74776_a("yOffset", this.yOffset);
        tag.func_74776_a("zOffset", this.zOffset);
        tag.func_74776_a("rotation", this.rotation);
        tag.func_74782_a("entityData", (NBTBase)this.tag);
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.registryName = new ResourceLocation(tag.func_74779_i("mobID"));
        this.xOffset = tag.func_74760_g("xOffset");
        this.yOffset = tag.func_74760_g("yOffset");
        this.zOffset = tag.func_74760_g("zOffset");
        this.rotation = tag.func_74760_g("rotation");
        this.tag = tag.func_74775_l("entityData");
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, BlockPos pos, int buildPass) {
        return buildPass == 3;
    }

    @Override
    public List<ItemStack> getResources() {
        return Collections.emptyList();
    }
}

