/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.entityrules;

import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntityBase;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.gates.types.Gate;

public class TemplateRuleGates
extends TemplateRuleEntityBase {
    public static final String PLUGIN_NAME = "awGate";
    private String owner;
    private String gateType;
    private EnumFacing orientation;
    private BlockPos pos1;
    private BlockPos pos2;

    public TemplateRuleGates(World world, Entity entity, int turns, int x, int y, int z) {
        EntityGate gate = (EntityGate)entity;
        this.pos1 = BlockTools.rotateAroundOrigin(gate.pos1.func_177982_a(-x, -y, -z), turns);
        this.pos2 = BlockTools.rotateAroundOrigin(gate.pos2.func_177982_a(-x, -y, -z), turns);
        this.orientation = EnumFacing.field_176754_o[(gate.gateOrientation.func_176736_b() + turns) % 4];
        this.gateType = Gate.getGateNameFor(gate);
        this.owner = gate.getOwner().getName();
    }

    public TemplateRuleGates() {
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        BlockPos p1 = BlockTools.rotateAroundOrigin(this.pos1, turns).func_177971_a((Vec3i)pos);
        BlockPos p2 = BlockTools.rotateAroundOrigin(this.pos2, turns).func_177971_a((Vec3i)pos);
        BlockPos min = BlockTools.getMin(p1, p2);
        BlockPos max = BlockTools.getMax(p1, p2);
        for (int x1 = min.func_177958_n(); x1 <= max.func_177958_n(); ++x1) {
            for (int y1 = min.func_177956_o(); y1 <= max.func_177956_o(); ++y1) {
                for (int z1 = min.func_177952_p(); z1 <= max.func_177952_p(); ++z1) {
                    world.func_175698_g(new BlockPos(x1, y1, z1));
                }
            }
        }
        Optional<EntityGate> gate = Gate.constructGate(world, p1, p2, Gate.getGateByName(this.gateType), EnumFacing.field_176754_o[Ints.constrainToRange((int)((this.orientation.func_176736_b() + turns) % 4), (int)0, (int)4)], this.owner.isEmpty() ? Owner.EMPTY : new Owner(world, this.owner));
        if (!gate.isPresent()) {
            AncientWarfareStructure.LOG.warn("Could not create gate for type: {}", (Object)this.gateType);
            return;
        }
        world.func_72838_d((Entity)gate.get());
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.gateType = tag.func_74779_i("gateType");
        this.orientation = EnumFacing.field_82609_l[tag.func_74771_c("orientation")];
        this.pos1 = NBTHelper.readBlockPosFromNBT(tag.func_74775_l("pos1"));
        this.pos2 = NBTHelper.readBlockPosFromNBT(tag.func_74775_l("pos2"));
        this.owner = tag.func_74779_i("owner");
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74778_a("gateType", this.gateType);
        tag.func_74774_a("orientation", (byte)this.orientation.ordinal());
        tag.func_74782_a("pos1", (NBTBase)NBTHelper.writeBlockPosToNBT(new NBTTagCompound(), this.pos1));
        tag.func_74782_a("pos2", (NBTBase)NBTHelper.writeBlockPosToNBT(new NBTTagCompound(), this.pos2));
        tag.func_74778_a("owner", this.owner);
    }

    @Override
    public List<ItemStack> getResources() {
        return Collections.singletonList(Gate.getItemToConstruct(Gate.getGateByName(this.gateType).getGlobalID()));
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, BlockPos pos, int buildPass) {
        return buildPass == 3;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }
}

