/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.save;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import net.minecraft.util.math.Vec3i;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.datafixes.DataFixManager;

public class TemplateExporter {
    private TemplateExporter() {
    }

    public static boolean exportTo(StructureTemplate template, File directory) {
        File exportFile = new File(directory, template.name + "." + AWStructureStatics.templateExtension);
        if (!exportFile.exists()) {
            try {
                if (!exportFile.createNewFile()) {
                    return false;
                }
            }
            catch (IOException e) {
                AncientWarfareStructure.LOG.error("Could not export template..could not create file : " + exportFile.getAbsolutePath());
                return false;
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(exportFile), StandardCharsets.ISO_8859_1));){
            TemplateExporter.writeHeader(template, writer);
            TemplateExporter.writeValidationSettings(template.getValidationSettings(), writer);
            TemplateExporter.writeLayers(template, writer);
            writer.write("#### RULES ####");
            writer.newLine();
            for (TemplateRule templateRule : template.getBlockRules().values()) {
                templateRule.writeRule(writer);
            }
            writer.write("#### ENTITIES ####");
            writer.newLine();
            for (TemplateRule templateRule : template.getEntityRules().values()) {
                templateRule.writeRule(writer);
            }
        }
        catch (IOException e) {
            AncientWarfareStructure.LOG.error("Could not export template..could not create file : " + exportFile.getAbsolutePath());
            return false;
        }
        return true;
    }

    private static void writeValidationSettings(StructureValidator settings, BufferedWriter writer) throws IOException {
        writer.write("#### VALIDATION ####");
        writer.newLine();
        writer.write("validation:");
        writer.newLine();
        StructureValidator.writeValidator(writer, settings);
        writer.write(":endvalidation");
        writer.newLine();
        writer.newLine();
    }

    private static void writeHeader(StructureTemplate template, BufferedWriter writer) throws IOException {
        Calendar cal = Calendar.getInstance();
        writer.write("# Ancient Warfare Structure Template File");
        writer.newLine();
        writer.write("# Auto-generated structure template file. created on: " + (cal.get(2) + 1) + "/" + cal.get(5) + "/" + cal.get(1) + " at: " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13));
        writer.newLine();
        writer.write("# Lines beginning with # denote comments");
        writer.newLine();
        writer.newLine();
        writer.write("header:");
        writer.newLine();
        writer.write("version=" + DataFixManager.getCurrentVersion().getMajor() + "." + DataFixManager.getCurrentVersion().getMinor());
        writer.newLine();
        writer.write("name=" + template.name);
        writer.newLine();
        writer.write("mods=" + String.join((CharSequence)",", template.modDependencies));
        writer.newLine();
        writer.write("size=" + template.getSize().func_177958_n() + "," + template.getSize().func_177956_o() + "," + template.getSize().func_177952_p());
        writer.newLine();
        writer.write("offset=" + template.getOffset().func_177958_n() + "," + template.getOffset().func_177956_o() + "," + template.getOffset().func_177952_p());
        writer.newLine();
        writer.write(":endheader");
        writer.newLine();
        writer.newLine();
    }

    private static void writeLayers(StructureTemplate template, BufferedWriter writer) throws IOException {
        writer.write("#### LAYERS ####");
        writer.newLine();
        for (int y = 0; y < template.getSize().func_177956_o(); ++y) {
            writer.write("layer: " + y);
            writer.newLine();
            for (int z = 0; z < template.getSize().func_177952_p(); ++z) {
                for (int x = 0; x < template.getSize().func_177958_n(); ++x) {
                    short data = template.getTemplateData()[StructureTemplate.getIndex(new Vec3i(x, y, z), template.getSize())];
                    writer.write(String.valueOf(data));
                    if (x >= template.getSize().func_177958_n() - 1) continue;
                    writer.write(",");
                }
                writer.newLine();
            }
            writer.write(":endlayer");
            writer.newLine();
        }
        writer.newLine();
    }
}

